/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.qing;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.common.helper.DraftBillUpdateFieldFunction;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractDraftBillAmtBankDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ACCEPTER_BANK = "accepterbankcate";
    private static final String ACCEPTER_BANK_NAME = "accepterbankcatename";
    private static final String BILL_TYPE = "billtype";
    private static final String TERM_TYPE = "termtype";
    private static final String TERM = "term";
    private static final String AMOUNT = "amount";
    private static final String COUNT = "count";
    private static final String CLICK = "click";
    private static final String SORT = "sort";
    private static final int TOP_BANK_NUMBER = 10;

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{ACCEPTER_BANK_NAME, ResManager.loadKDString((String)"\u627f\u5151\u673a\u6784", (String)"AbstractDraftBillAmtBankDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{TERM_TYPE, ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b", (String)"AbstractDraftBillAmountDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{TERM, ResManager.loadKDString((String)"\u533a\u95f4", (String)"AbstractDraftBillAmountDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{COUNT, ResManager.loadKDString((String)"\u7b14\u6570", (String)"AbstractDraftBillAmountDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"AbstractDraftBillAmountDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{CLICK, ResManager.loadKDString((String)"\u7a7f\u900f\u5b57\u6bb5", (String)"AbstractDraftBillAmountDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{SORT, ResManager.loadKDString((String)"\u6392\u5e8f\u5e8f\u53f7", (String)"AbstractDraftBillAmountDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), Boolean.FALSE});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        String rpType = this.getRpType();
        DataSet allDs = DraftBillDataHelper.getBillAccruedDataSet((String)this.createAlgoKey(""), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (String)rpType).filter("billtype in ('5', '6', '20')").select(new String[]{ACCEPTER_BANK, BILL_TYPE, AMOUNT, "rptype", "registereddate", "issuedate", ACCEPTER_BANK_NAME}).addField("1", COUNT);
        DataSet[] termTypDS = DraftBillDataHelper.getDateRangeDataSet((DataSet)allDs, (Date)queryDate, null, (boolean)false);
        DataSet resultSet = DecisionAnlsHelper.createEmptyDataSet(allDs.getRowMeta());
        for (int i = 0; i < termTypDS.length; ++i) {
            DataSet dataSetTemp = termTypDS[i];
            dataSetTemp = dataSetTemp.groupBy(new String[]{ACCEPTER_BANK, ACCEPTER_BANK_NAME, BILL_TYPE, "customtype", "datetype"}).sum(AMOUNT).sum(COUNT).finish();
            resultSet = i == 0 ? dataSetTemp : resultSet.union(dataSetTemp);
        }
        resultSet = resultSet.addField("''", TERM);
        return DraftBillUpdateFieldFunction.updateFields((DataSet)resultSet, (DraftBillUpdateFieldFunction[])new DraftBillUpdateFieldFunction[]{DraftBillUpdateFieldFunction.dateTypeUpdateFunction((Date)queryDate, (String)TERM)});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        if ((ds = ds.addField("customtype", TERM_TYPE)).isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta()).addFields(new String[]{"0", "''"}, new String[]{SORT, CLICK});
        }
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), filterParam, (String)TERM_TYPE, (String)TERM);
        String termType = (String)typeLinkValue.getValue0();
        String term = (String)typeLinkValue.getValue1();
        if (EmptyUtil.isNoEmpty((String)termType) && EmptyUtil.isNoEmpty((String)term)) {
            String filter = "termtype = '" + termType + "' and " + TERM + " = '" + term + "'";
            ds = ds.filter(filter);
        }
        DataSet bankTopDs = this.getBankTopOnDraftBill(ds);
        bankTopDs = bankTopDs.addFields(new String[]{"'" + termType + "'", "'" + term + "'"}, new String[]{TERM_TYPE, TERM});
        String rpType = this.getRpType();
        return bankTopDs.addField("concat(termtype,'_',term,'_','" + rpType + "')", CLICK);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList(this.getLinkRptFormId());
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return CLICK;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(CLICK, ids.get(0));
        param.setFormId(this.getLinkRptFormId());
        String rpType = this.getRpType();
        if ("receivebill".equals(rpType)) {
            param.setCaption(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u627f\u5151\u673a\u6784\u53d1\u751f\u989d\u5206\u5e03\u8868", (String)"DraftBillAccepterBankListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        } else {
            param.setCaption(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u627f\u5151\u673a\u6784\u53d1\u751f\u989d\u5206\u5e03\u8868", (String)"DraftBillAccepterBankListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        this.fireLinkageShowForm(view, param);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.setFormId(this.getLinkRptFormId());
        String rpType = this.getRpType();
        JSONArray data = (JSONArray)clickArgs.get((Object)"data");
        param.getCustomParams().put(CLICK, data.get(5));
        if ("receivebill".equals(rpType)) {
            param.setCaption(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u627f\u5151\u673a\u6784\u53d1\u751f\u989d\u5206\u5e03\u8868", (String)"DraftBillAccepterBankListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        } else {
            param.setCaption(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u627f\u5151\u673a\u6784\u53d1\u751f\u989d\u5206\u5e03\u8868", (String)"DraftBillAccepterBankListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
    }

    protected abstract String getRpType();

    protected abstract String getLinkRptFormId();

    private DataSet getBankTopOnDraftBill(DataSet dataSet) {
        DataSet[] dataSets = dataSet.splitByFilter(new String[]{"billtype = '6'", "billtype = '20'"}, true);
        DataSet bankBillDs = dataSets[0];
        DataSet finBillDs = dataSets[1];
        DataSet comBillDs = dataSets[2];
        DataSet topBankDs = bankBillDs.copy().filter("accepterbankcate <> 0L").groupBy(new String[]{ACCEPTER_BANK_NAME}).sum(AMOUNT).sum(COUNT).finish().orderBy(new String[]{"amount DESC"}).top(10);
        Set<String> topBanks = DecisionAnlsHelper.getTopBanks(topBankDs.copy(), ACCEPTER_BANK_NAME);
        topBankDs = topBankDs.select(new String[]{ACCEPTER_BANK_NAME, AMOUNT, COUNT});
        topBankDs = this.dealSortField(topBankDs);
        DataSet noTopBankDs = bankBillDs.select(new String[]{ACCEPTER_BANK_NAME, AMOUNT, COUNT}).filter(DecisionAnlsHelper.buildOtherFilter(topBanks, ACCEPTER_BANK_NAME));
        noTopBankDs = noTopBankDs.updateField(ACCEPTER_BANK_NAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"AbstractDraftBillAccepterBankPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{ACCEPTER_BANK_NAME}).sum(AMOUNT).sum(COUNT).finish();
        topBankDs = topBankDs.union(noTopBankDs.addField("10", SORT));
        finBillDs = finBillDs.updateField(ACCEPTER_BANK_NAME, ResManager.loadKDString((String)"'\u8d22\u52a1\u516c\u53f8'", (String)"AbstractDraftBillAmtBankDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{ACCEPTER_BANK_NAME}).sum(AMOUNT).sum(COUNT).finish();
        topBankDs = topBankDs.union(finBillDs.addField("11", SORT));
        comBillDs = comBillDs.updateField(ACCEPTER_BANK_NAME, ResManager.loadKDString((String)"'\u5546\u4e1a\u7968\u636e'", (String)"AbstractDraftBillAccepterBankPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{ACCEPTER_BANK_NAME}).sum(AMOUNT).sum(COUNT).finish();
        return topBankDs.union(comBillDs.addField("12", SORT));
    }

    private DataSet dealSortField(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        if (dataSet.isEmpty()) {
            DataSet emptyDataSet = DecisionAnlsHelper.createEmptyDataSet(rowMeta.getFieldNames(), rowMeta.getDataTypes());
            return emptyDataSet.addNullField(SORT);
        }
        DataSet topBankSet = dataSet.copy();
        ArrayList<String> topBankList = new ArrayList<String>(10);
        while (topBankSet.hasNext()) {
            Row row = topBankSet.next();
            topBankList.add(row.getString(ACCEPTER_BANK_NAME));
        }
        DataSet[] dataSets = dataSet.splitByFilter((String[])topBankList.stream().map(e -> "accepterbankcatename = '" + e + "'").toArray(String[]::new), false);
        DataSet baseSet = dataSets[0].addField("0", SORT);
        for (int i = 1; i < dataSets.length; ++i) {
            baseSet = baseSet.union(dataSets[i].addField(String.valueOf(i), SORT));
        }
        return baseSet;
    }
}

