/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.qing;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.enums.RecPayBillTypeEnum;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractDraftBillBalanceDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String DATA_RANGE = "datarange";
    private static final String AMOUNT = "amount";
    private static final String COUNT = "count";
    private static final String BILL_TYPE = "billtype";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{BILL_TYPE, ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b", (String)"AbstractDraftBillBalanceDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{DATA_RANGE, ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4", (String)"AbstractDraftBillBalanceDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{COUNT, ResManager.loadKDString((String)"\u7b14\u6570", (String)"AbstractDraftBillBalanceDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"AbstractDraftBillBalanceDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"sort", ResManager.loadKDString((String)"\u6392\u5e8f\u5e8f\u53f7", (String)"AbstractDraftBillAmountDataPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String rptype = this.getRpType();
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet allDs = DraftBillDataHelper.getBillBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgviewId, (String)rptype).filter("billtype in ('5', '6', '20')").select(new String[]{BILL_TYPE, AMOUNT, "draftbillcount as count"});
        DataSet resultDs = allDs.groupBy(new String[]{BILL_TYPE}).sum(COUNT).sum(AMOUNT).finish().addField("'all' datarange", DATA_RANGE);
        resultDs = this.dealEmptyBillTypeRow(resultDs, Arrays.asList("5", "6", "20"));
        String sortExpr = "case when billtype = '6' then 1 when billtype = '20' then 2 else 3 end as sort";
        return resultDs.addField(sortExpr, "sort");
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(this.getLinkRptFormId());
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return BILL_TYPE;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList(this.getLinkRptFormId());
    }

    protected abstract String getRpType();

    protected abstract String getLinkRptFormId();

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    private DataSet dealEmptyBillTypeRow(DataSet resultDs, List<String> billTypes) {
        for (String billType : billTypes) {
            if (!resultDs.copy().filter("billtype = '" + billType + "'").isEmpty()) continue;
            RowMeta rowMeta = resultDs.getRowMeta();
            DataSet bizDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{billType, 0, 0.0, "all"}));
            resultDs = resultDs.union(bizDs);
        }
        return resultDs;
    }

    @Override
    protected Object translateCellDisplay(String field, Object value, Row rs) {
        if (BILL_TYPE.equals(field)) {
            RecPayBillTypeEnum typeEnum = RecPayBillTypeEnum.getByCode((String)((String)value));
            value = typeEnum != null ? typeEnum.getName() : ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AbstractFinDebtDistDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        return super.translateCellDisplay(field, value, rs);
    }
}

