/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.qing;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.DraftBillLetterCreditDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractLetterCreditQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet allDs;
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        if ("accrued".equals(this.getAmountType())) {
            allDs = DraftBillLetterCreditDataHelper.getBillAccruedDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgviewId);
            Map dateMap = DecisionCommonHelper.getDateRangeMap((Date)queryDate);
            allDs = DecisionCommonHelper.getDateRangeDataSets((DataSet)allDs, (Map)dateMap, (String)"bizdate");
            allDs = allDs.removeFields(new String[]{"credittype"});
            allDs = allDs.addFields(new String[]{"case when isforward = false then 'spottype' else 'fartype' end", "dateRange"}, new String[]{"credittype", "param"});
        } else {
            allDs = DraftBillLetterCreditDataHelper.getBillBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgviewId);
            allDs = allDs.updateField("amount", "balance");
            allDs = allDs.removeFields(new String[]{"credittype"});
            allDs = allDs.addFields(new String[]{"case when isforward = false then 'spottype' else 'fartype' end", "'one_month'"}, new String[]{"credittype", "param"});
        }
        return this.tranDataSetRate(allDs, paramMap);
    }

    protected abstract DataSet tranDataSetRate(DataSet var1, Map<String, Object> var2);

    @Override
    protected List<String> getLinkReport() {
        return "accrued".equals(this.getAmountType()) ? Collections.singletonList("tda_lettercredit_amtnum") : Collections.singletonList("tda_lettercreditbalrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "param";
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        if ("accrued".equals(this.getAmountType())) {
            parameter.setFormId("tda_lettercredit_amtnum");
            HashMap<String, String> customParams = new HashMap<String, String>(2);
            customParams.put("dateRange", ids.get(0));
            parameter.setCustomParams(customParams);
            String caption = ((Object)((Object)this)).getClass().getName().contains("LetterCreditOrgDataPlugin") ? ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5f00\u8bc1\u53d1\u751f\u989d\u5355\u4f4d\u5206\u5e03\u8868", (String)"AbstractLetterCreditQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5f00\u8bc1\u53d1\u751f\u989d\u5206\u5e03\u8868", (String)"AbstractLetterCreditQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
            parameter.setCaption(caption);
        } else {
            String caption = ((Object)((Object)this)).getClass().getName().contains("LetterCreditOrgBalanceDataPlugin") ? ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5f00\u8bc1\u4f59\u989d\u5355\u4f4d\u5206\u5e03\u8868", (String)"AbstractLetterCreditQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5f00\u8bc1\u4f59\u989d\u5206\u5e03\u8868", (String)"AbstractLetterCreditQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
            parameter.setCaption(caption);
            parameter.setFormId("tda_lettercreditbalrpt");
        }
        this.fireLinkageShowForm(view, parameter);
    }

    protected String getAmountType() {
        return "accrued";
    }
}

