/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.qing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.note.helper.LetterCreditOpenHelper;
import kd.tmc.tda.report.note.qing.AbstractLetterCreditQingDataPlugin;

public class LetterCreditOrgDataPlugin
extends AbstractLetterCreditQingDataPlugin {
    private static final List<String> ORG_SELECTFIELD = Arrays.asList("rowid", "mixorgname", "pid", "isgroupnode", "level", "orgid", "0  as sumlevel");
    private static final List<String> SUM_FIELD = Arrays.asList("one_monthspotcount", "one_monthfarcount", "three_monthspotcount", "three_monthfarcount", "six_monthspotcount", "six_monthfarcount", "yearspotcount", "yearfarcount");

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"LetterCreditSumaryDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"orgid", ResManager.loadKDString((String)"\u7ec4\u7ec7ID", (String)"LetterCreditSumaryDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"simplename", ResManager.loadKDString((String)"\u7ec4\u7ec7\u7b80\u79f0", (String)"LetterCreditSumaryDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"spotcount", ResManager.loadKDString((String)"\u5373\u671f\u4fe1\u7528\u8bc1", (String)"LetterCreditSumaryDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"farcount", ResManager.loadKDString((String)"\u8fdc\u671f\u4fe1\u7528\u8bc1", (String)"LetterCreditSumaryDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"param", ResManager.loadKDString((String)"\u53c2\u6570", (String)"LetterCreditSumaryDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"paramname", ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"LetterCreditSumaryDataPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"sort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"LetterCreditSumaryDataPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    @Override
    protected DataSet tranDataSetRate(DataSet union, Map<String, Object> paramMap) {
        this.getQueryParam(paramMap);
        DataSet groupDS = union.groupBy(new String[]{"orgid", "param"}).sum("spotcount").sum("farcount").finish();
        DataSet changeDS = DecisionAnlsHelper.ChangeMultRowToColDataSet(groupDS, "param", "orgid", "", Arrays.asList("spotcount", "farcount"));
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List sumFields = Arrays.stream(changeDS.getRowMeta().getFieldNames()).filter(s -> s.contains("spotcount") || s.contains("farcount")).collect(Collectors.toList());
        List<String> reduces = SUM_FIELD.stream().filter(item -> !sumFields.contains(item)).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(reduces)) {
            ArrayList<String> addFields = new ArrayList<String>(10);
            for (int i = 0; i < reduces.size(); ++i) {
                addFields.add("0");
            }
            changeDS = changeDS.addFields(addFields.toArray(new String[0]), reduces.toArray(new String[0]));
        }
        DataSet deal = orgDateSet.leftJoin(changeDS).on("rowid", "orgid").select(ORG_SELECTFIELD.toArray(new String[0]), SUM_FIELD.toArray(new String[0])).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(deal, SUM_FIELD, "orgid, mixorgname").addField(String.join((CharSequence)"+", SUM_FIELD), "stat");
        List filterOrg = EmptyUtil.isNoEmpty((Object)paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)filterOrg)) {
            sumDataSet = sumDataSet.filter("orgid in (" + TmcBusinessBaseHelper.idListToString((List)filterOrg) + ")").filter("stat > 0");
        }
        sumDataSet = sumDataSet.addFields(new String[]{"mixorgname", "mixorgname"}, new String[]{"orgname", "simplename"});
        if ("accrued".equals(this.getAmountType())) {
            DataSet[] sumDataSets = sumDataSet.splitByFilter(new String[]{"true", "true", "true", "true"}, false);
            DataSet oneMonthDS = sumDataSets[0].addFields(new String[]{"'one_month'", LetterCreditOpenHelper.getOneMonthStr(), "one_monthspotcount", "one_monthfarcount", "1"}, new String[]{"param", "paramname", "spotcount", "farcount", "sort"});
            DataSet threeMonthDS = sumDataSets[1].addFields(new String[]{"'three_month'", LetterCreditOpenHelper.getThreeMontStr(), "three_monthspotcount", "three_monthfarcount", "2"}, new String[]{"param", "paramname", "spotcount", "farcount", "sort"});
            DataSet six_monthDS = sumDataSets[2].addFields(new String[]{"'six_month'", LetterCreditOpenHelper.getSixMonthStr(), "six_monthspotcount", "six_monthfarcount", "3"}, new String[]{"param", "paramname", "spotcount", "farcount", "sort"});
            DataSet yearDS = sumDataSets[3].addFields(new String[]{"'year'", LetterCreditOpenHelper.getYearStr(), "yearspotcount", "yearfarcount", "4"}, new String[]{"param", "paramname", "spotcount", "farcount", "sort"});
            return oneMonthDS.union(new DataSet[]{threeMonthDS, six_monthDS, yearDS}).filter("spotcount > 0 or farcount > 0");
        }
        DataSet oneMonthDS = sumDataSet.addFields(new String[]{"'one_month'", LetterCreditOpenHelper.getOneMonthStr(), "one_monthspotcount", "one_monthfarcount", "1"}, new String[]{"param", "paramname", "spotcount", "farcount", "sort"});
        return oneMonthDS.filter("spotcount > 0 or farcount > 0");
    }

    private void getQueryParam(Map<String, Object> paramMap) {
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        paramMap.put("allorgids", allorgids);
        List secondOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
        paramMap.put("suborgids", secondOrgIds);
    }

    @Override
    protected String getAmountType() {
        return "accrued";
    }
}

