/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.qing;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.common.helper.DraftBillUpdateFieldFunction;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class ReceiveBillDiscountBankQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String RECBODYBANKCATEID = "recbodybankcateid";
    private static final String RECBODYBANKCATENAME = "recbodybankcatename";
    private static final String AMOUNT = "amount";
    private static final String CUSTOMTYPE = "customtype";
    private static final String TERM = "term";
    private static final String BILLTYPE = "billtype";
    private static final String CLICK = "click";
    private static final int TOP_NUM = 10;
    private static final String DISCOUNT_DAYS = "discountdays";
    private static final String DISCOUNT_RATE = "discountrate";
    private static final String DISCOUNT_INTEREST = "discountinterest";
    private static final String MOLECULE = "molecule";
    private static final String DENOMINATOR = "denominator";
    private static final String AVG_RATE = "avgrate";

    protected List<Object[]> getColumnItems() {
        ArrayList<Object[]> field = new ArrayList<Object[]>(3);
        field.add(new Object[]{RECBODYBANKCATENAME, ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"ReceiveBillDiscountBankQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u8d34\u73b0\u91d1\u989d", (String)"ReceiveBillDiscountBankQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{DISCOUNT_INTEREST, ResManager.loadKDString((String)"\u8d34\u73b0\u5229\u606f", (String)"ReceiveBillDiscountBankQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{AVG_RATE, ResManager.loadKDString((String)"\u8d34\u73b0\u5229\u7387", (String)"ReceiveBillDiscountBankQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{CLICK, ResManager.loadKDString((String)"\u7a7f\u900f\u5b57\u6bb5", (String)"InvestBankAmtQingAnlsPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f\u5217", (String)"ReceiveBillDiscountBankQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        return field;
    }

    protected String otherRowName() {
        return ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"ReceiveBillDiscountBankQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private List<Pair<String, String>> getSplitFilter() {
        return Arrays.asList(new Pair((Object)"billtype = '6'", (Object)""), new Pair((Object)"billtype = '20'", (Object)ResManager.loadKDString((String)"'\u8d22\u52a1\u516c\u53f8'", (String)"ReceiveBillDiscountBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0])), new Pair((Object)"billtype = '5'", (Object)ResManager.loadKDString((String)"'\u5546\u4e1a\u7968\u636e'", (String)"ReceiveBillDiscountBankQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0])));
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet detaiData = DraftBillDataHelper.getRecBillDiscountDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgviewId);
        DataSet[] detaiDatas = DraftBillDataHelper.getDateRangeDataSet((DataSet)detaiData, (Date)queryDate, null, (boolean)true);
        DataSet termTypeGroupDS = detaiDatas[0].addField("''", TERM);
        termTypeGroupDS = DraftBillUpdateFieldFunction.updateFields((DataSet)termTypeGroupDS, (DraftBillUpdateFieldFunction[])new DraftBillUpdateFieldFunction[]{DraftBillUpdateFieldFunction.dateTypeUpdateFunction((Date)queryDate, (String)TERM)});
        List<Pair<String, String>> splitDataFilter = this.getSplitFilter();
        DataSet[] splitData = termTypeGroupDS.select(new String[]{RECBODYBANKCATEID, RECBODYBANKCATENAME, AMOUNT, CUSTOMTYPE, TERM, BILLTYPE, DISCOUNT_DAYS, DISCOUNT_RATE, DISCOUNT_INTEREST}).addFields(new String[]{"amount*discountdays*discountrate", "amount*discountdays"}, new String[]{MOLECULE, DENOMINATOR}).splitByFilter((String[])splitDataFilter.stream().map(p -> (String)p.getValue0()).toArray(String[]::new), false);
        for (int i = 1; i < splitDataFilter.size(); ++i) {
            splitData[i] = splitData[i].updateField(RECBODYBANKCATENAME, (String)splitDataFilter.get(i).getValue1());
            splitData[i] = splitData[i].updateField(RECBODYBANKCATEID, "0");
        }
        DataSet unionData = splitData[0].union(new DataSet[]{splitData[1], splitData[2]});
        unionData = unionData.select(new String[]{RECBODYBANKCATEID, RECBODYBANKCATENAME, AMOUNT, CUSTOMTYPE, TERM, BILLTYPE, DISCOUNT_INTEREST, MOLECULE, DENOMINATOR}).groupBy(new String[]{RECBODYBANKCATEID, RECBODYBANKCATENAME, CUSTOMTYPE, TERM, BILLTYPE}).sum(AMOUNT).sum(DISCOUNT_INTEREST).sum(MOLECULE).sum(DENOMINATOR).finish().addField("concat(customtype,'_',term)", CLICK);
        return unionData;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), filterParam, (String)"termtype", (String)TERM);
        String termType = (String)typeLinkValue.getValue0();
        String term = (String)typeLinkValue.getValue1();
        if (EmptyUtil.isNoEmpty((String)termType) && EmptyUtil.isNoEmpty((String)term)) {
            String filter = "customtype = '" + termType + "' and " + TERM + " = '" + term + "'";
            ds = ds.filter(filter);
        }
        List<Pair<String, String>> splitDataFilter = this.getSplitFilter();
        DataSet[] splitData = ds.select(new String[]{RECBODYBANKCATEID, RECBODYBANKCATENAME, AMOUNT, CUSTOMTYPE, TERM, BILLTYPE, CLICK, DISCOUNT_INTEREST, MOLECULE, DENOMINATOR}).splitByFilter((String[])splitDataFilter.stream().map(p -> (String)p.getValue0()).toArray(String[]::new), false);
        DataSet rankData = splitData[0].orderBy(new String[]{"amount desc", "recbodybankcateid desc"});
        rankData = rankData.removeFields(new String[]{RECBODYBANKCATEID});
        DataSetBuilder builder = Algo.create((String)"AbstractRankAnlsQingDataPlugin.rebuildRankData").createDataSetBuilder(rankData.getRowMeta());
        int i = 0;
        BigDecimal otherSum = new BigDecimal(0);
        BigDecimal otherInterest = new BigDecimal(0);
        BigDecimal otherMolecule = new BigDecimal(0);
        BigDecimal otherDenominator = new BigDecimal(0);
        for (Row row : rankData) {
            if (EmptyUtil.isEmpty((String)row.getString(RECBODYBANKCATENAME))) {
                otherSum = otherSum.add(row.getBigDecimal(AMOUNT));
                otherInterest = otherInterest.add(row.getBigDecimal(DISCOUNT_INTEREST));
                otherMolecule = otherMolecule.add(row.getBigDecimal(MOLECULE));
                otherDenominator = otherDenominator.add(row.getBigDecimal(DENOMINATOR));
                continue;
            }
            if (i < 10) {
                builder.append(row);
                ++i;
                continue;
            }
            otherSum = otherSum.add(row.getBigDecimal(AMOUNT));
            otherInterest = otherInterest.add(row.getBigDecimal(DISCOUNT_INTEREST));
            otherMolecule = otherMolecule.add(row.getBigDecimal(MOLECULE));
            otherDenominator = otherDenominator.add(row.getBigDecimal(DENOMINATOR));
        }
        if (BigDecimal.ZERO.compareTo(otherSum) < 0) {
            builder.append(new Object[]{this.otherRowName(), otherSum, termType, term, "6", termType + "_" + term, otherInterest, otherMolecule, otherDenominator});
        }
        if (splitData.length > 1) {
            for (int j = 1; j < splitData.length; ++j) {
                DataSet tempData = splitData[j].removeFields(new String[]{RECBODYBANKCATEID});
                for (Row tempDatum : tempData) {
                    builder.append(tempDatum);
                }
            }
        }
        DataSet resultSet = builder.build();
        return resultSet.addField("case when molecule is null or molecule = 0.0 or denominator is null or denominator = 0.0 then 0.0 else molecule / denominator end", AVG_RATE);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add(AMOUNT);
        fields.add(DISCOUNT_INTEREST);
        return fields;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_recdiscountorgrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return CLICK;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put("dateRange", ids.get(0));
        param.setFormId(formId);
        this.fireLinkageShowForm(view, param);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        JSONArray data = clickArgs.getJSONArray("data");
        if (data != null && data.size() > 4) {
            param.getCustomParams().put("dateRange", data.get(4));
        }
    }
}

