/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BigAmountFlowSumDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ORG_ID = "orgid";
    private static final String ROW_ID = "rowid";
    private static final String BIZ_DATE = "bizdate";
    private static final String INFLOW_NUM = "bigamtnuminflowsum";
    private static final String INFLOW_AMT = "bigamtcurinflowsum";
    private static final String OUTFLOW_NUM = "bigamtnumoutflowsum";
    private static final String OUTFLOW_AMT = "bigamtcuroutflowsum";
    private static final String SOURCE_INFLOW = "creditamount";
    private static final String SOURCE_OUTFLOW = "debitamount";
    private static final List<String> SUM_FIELD = Arrays.asList("bigamtnuminflowsum", "bigamtcurinflowsum", "bigamtnumoutflowsum", "bigamtcuroutflowsum");
    private static final List<String> TOTAL_SUM_FIELD = Arrays.asList("bigamtnuminflowsum", "bigamtcurinflowsum", "bigamtnumoutflowsum", "bigamtcuroutflowsum");
    private static final List<String> ORG_SELECTFIELD = Arrays.asList("orgid", "rowid", "mixorgname", "pid", "isgroupnode", "level", "0  as sumlevel", "sortcode");

    @Override
    protected DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        Date queryDate = DateUtils.getDataFormat((Date)DecisionAnlsHelper.getQueryDate(paramMap), (boolean)false);
        String dateRange = (String)paramMap.get("dateRange");
        HashMap dateParamsMap = new HashMap(2);
        String filterDateStr = SettleDataHelper.getFilterDateStr((Date)queryDate, (String)dateRange, dateParamsMap);
        DataSet bigAmtBillSet = SettleDataHelper.queryBigAmtSet((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (List)((List)paramMap.get("allorgids")), (Date)queryDate).filter(filterDateStr, dateParamsMap).select(new String[]{ORG_ID, ROW_ID, SOURCE_INFLOW, SOURCE_OUTFLOW, BIZ_DATE, "currency", "entityname"});
        DynamicObject bigAmountSet = BusinessDataServiceHelper.loadSingle((String)"tda_bigamountset", (String)"bigamountgetterway", (QFilter[])new QFilter[0]);
        String sourceType = bigAmountSet.getString("bigamountgetterway");
        bigAmtBillSet = bigAmtBillSet.addField("case entityname when 'cas_paybill' then '0' when 'cas_recbill' then '0' when 'bei_transdetail' then '1' end", "sourcetype");
        bigAmtBillSet = bigAmtBillSet.filter("sourcetype = '" + sourceType + "'");
        DataSet exchangeSet = AmountTransHelper.tranDataSetRate((DataSet)bigAmtBillSet, (Long)orgViewId, (Long)currencyId, (String)"currency", this.getTransAmountFields(), (Date)queryDate);
        DataSet[] flowNumSets = exchangeSet.copy().splitByFilter(new String[]{"debitamount = 0", "creditamount = 0"}, false);
        DataSet inFlowNumSet = flowNumSets[0].select(new String[]{ORG_ID, BIZ_DATE, "'bigamtnuminflowsum' distribute"}).groupBy(new String[]{ORG_ID, "distribute", BIZ_DATE}).count().finish();
        DataSet outFlowNumSet = flowNumSets[1].select(new String[]{ORG_ID, BIZ_DATE, "'bigamtnumoutflowsum' distribute"}).groupBy(new String[]{ORG_ID, "distribute", BIZ_DATE}).count().finish();
        DataSet numUnion = inFlowNumSet.union(outFlowNumSet);
        numUnion = this.changeRowToColDataSet(numUnion, "distribute", "orgid,bizdate", "");
        numUnion = this.updateCols(numUnion).select(new String[]{ORG_ID, INFLOW_NUM, OUTFLOW_NUM, BIZ_DATE});
        DataSet[] flowAmtSets = exchangeSet.splitByFilter(new String[]{"debitamount = 0", "creditamount = 0"}, false);
        DataSet inFlowAmtSet = flowAmtSets[0].filter("debitamount = 0").groupBy(new String[]{ORG_ID, ROW_ID, BIZ_DATE}).sum(SOURCE_INFLOW, INFLOW_AMT).finish();
        DataSet outFlowAmtSet = flowAmtSets[1].filter("creditamount = 0").groupBy(new String[]{ORG_ID, ROW_ID, BIZ_DATE}).sum(SOURCE_OUTFLOW, OUTFLOW_AMT).finish();
        DataSet dataUnion = numUnion.leftJoin(inFlowAmtSet).on(ORG_ID, ORG_ID).on(BIZ_DATE, BIZ_DATE).select(new String[]{ORG_ID, ROW_ID, INFLOW_NUM, INFLOW_AMT, OUTFLOW_NUM, BIZ_DATE}).finish();
        dataUnion = dataUnion.leftJoin(outFlowAmtSet).on(ORG_ID, ORG_ID).on(BIZ_DATE, BIZ_DATE).select(new String[]{ORG_ID, ROW_ID, INFLOW_NUM, INFLOW_AMT, OUTFLOW_NUM, OUTFLOW_AMT, BIZ_DATE}).finish();
        return dataUnion;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet bigAmtBillSet, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        String dateRange = (String)paramMap.get("dateRange");
        HashMap dateParamsMap = new HashMap(2);
        Date queryDate = DateUtils.getDataFormat((Date)DecisionAnlsHelper.getQueryDate(paramMap), (boolean)false);
        String filterDateStr = SettleDataHelper.getFilterDateStr((Date)queryDate, (String)dateRange, dateParamsMap);
        bigAmtBillSet = bigAmtBillSet.filter(filterDateStr, dateParamsMap);
        bigAmtBillSet = bigAmtBillSet.groupBy(new String[]{ORG_ID}).sum(INFLOW_NUM).sum(INFLOW_AMT).sum(OUTFLOW_NUM).sum(OUTFLOW_AMT).finish();
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        DataSet orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet resultSet = orgDataSet.leftJoin(bigAmtBillSet).on(ORG_ID, ORG_ID).select(ORG_SELECTFIELD.toArray(new String[0]), SUM_FIELD.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(resultSet, SUM_FIELD, "mixorgname,sortcode").addFields(new String[]{String.valueOf(currencyId), String.join((CharSequence)"+", SUM_FIELD)}, new String[]{"listcurrency", "stat"});
        sumDataSet = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? sumDataSet.filter("rowid in orgFilter", Collections.singletonMap("orgFilter", paramMap.get("suborgids"))) : sumDataSet.filter("rowid in orgFilter", Collections.singletonMap("orgFilter", paramMap.get("allorgids")));
        DataSet totalSet = this.addAllTotalDataSet(sumDataSet, TOTAL_SUM_FIELD, Collections.singletonList("listcurrency"), "mixorgname");
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        return sumDataSet.union(totalSet).addFields(new String[]{"mixorgname", ROW_ID}, new String[]{"orgname", ORG_ID});
    }

    private Set<String> getTransAmountFields() {
        HashSet<String> fields = new HashSet<String>(2);
        fields.add(SOURCE_INFLOW);
        fields.add(SOURCE_OUTFLOW);
        return fields;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(2);
        fields.add(INFLOW_AMT);
        fields.add(OUTFLOW_AMT);
        return fields;
    }

    private DataSet updateCols(DataSet dataSet) {
        Object[] fieldNames = dataSet.getRowMeta().getFieldNames();
        if (!ArrayUtils.contains((Object[])fieldNames, (Object)INFLOW_NUM)) {
            dataSet = dataSet.addField("0", INFLOW_NUM);
        }
        if (!ArrayUtils.contains((Object[])fieldNames, (Object)OUTFLOW_NUM)) {
            dataSet = dataSet.addField("0", OUTFLOW_NUM);
        }
        return dataSet;
    }

    /*
     * WARNING - void declaration
     */
    private DataSet changeRowToColDataSet(DataSet ds, String changeField, String groupFieldName, String beginChangeField) {
        DataSet tempDs = ds.copy();
        HashSet<DataSet> dsSet = new HashSet<DataSet>(10);
        HashMap<String, String> dsFieldName = new HashMap<String, String>(10);
        while (tempDs.hasNext()) {
            void var12_12;
            Row row = tempDs.next();
            DataType dateType = tempDs.getRowMeta().getField(changeField).getDataType();
            String fieldValue = row.getString(changeField);
            String fieldName = beginChangeField + fieldValue;
            String string = changeField + " = '" + fieldValue + "'";
            if (!dateType.equals((Object)DataType.StringType)) {
                String string2 = changeField + " = " + fieldValue;
            }
            if (dsFieldName.get(fieldValue) != null) continue;
            DataSet ds1 = ds.copy().filter((String)var12_12).groupBy(groupFieldName.split(",")).sum("count", fieldName).finish();
            dsSet.add(ds1);
            dsFieldName.put(fieldValue, "");
        }
        DataSet result = ds.copy().select(groupFieldName).groupBy(groupFieldName.split(",")).finish();
        for (DataSet dsTemp : dsSet) {
            void var12_18;
            if (result == null) {
                result = dsTemp;
                continue;
            }
            ArrayList<String> fieldNameList = new ArrayList<String>();
            Collections.addAll(fieldNameList, dsTemp.getRowMeta().getFieldNames());
            for (String fieldName : result.getRowMeta().getFieldNames()) {
                if (fieldNameList.contains(fieldName)) continue;
                fieldNameList.add(fieldName);
            }
            JoinDataSet joinDataSet = result.join(dsTemp, JoinType.LEFT);
            for (String groupField : groupFieldName.split(",")) {
                JoinDataSet joinDataSet2 = var12_18.on(groupField.trim(), groupField.trim());
            }
            result = var12_18.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
        }
        return result;
    }
}

