/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.settle.common.SettleMgHelper;

public class SettleAmtFlowDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final Log logger = LogFactory.getLog(SettleAmtFlowDataListPlugin.class);
    private List<String> COUNT_FIELDS = Arrays.asList("intflow_currday", "intflow_currmonth", "intflow_curryear", "outflow_currday", "outflow_currmonth", "outflow_curryear", "currdaynetamt", "currmonthnetamt", "curryearnetamt");

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        HashMap<String, Object> dateMap = new HashMap<String, Object>(2);
        String currDaySic = "company, areaRange, creditamount as intflow_currday, debitamount as outflow_currday, creditamount-debitamount as currdaynetamt, 0 as intflow_currmonth, 0 as outflow_currmonth, 0 as currmonthnetamt, 0 as intflow_curryear, 0 as outflow_curryear, 0 as curryearnetamt";
        DataSet currDayDs = SettleDataHelper.queryTransDetail((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (Long)baseCurrency, (Date)queryDate, (List)((List)paramMap.get("allorgids")), (String)"queryCurrDayAmt").filter("(creditamount <> 0 and debitamount = 0) or (debitamount <> 0 and creditamount = 0)").select(currDaySic);
        String currMonthSic = "org as company, areaRange, 0 as intflow_currday, 0 as outflow_currday, 0 as currdaynetamt, creditamount as intflow_currmonth, debitamount as outflow_currmonth, creditamount-debitamount as currmonthnetamt, 0 as intflow_curryear, 0 as outflow_curryear, 0 as curryearnetamt";
        DataSet transDetails = SettleDataHelper.queryTransDetailsSummary((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (Long)baseCurrency, (List)((List)paramMap.get("allorgids")), (Date)queryDate);
        DataSet currMonthDs = transDetails.copy().filter(SettleMgHelper.getDateFilterStr("currmonth", queryDate, dateMap), dateMap).select(currMonthSic);
        DataSet currYearDs = transDetails.filter(SettleMgHelper.getDateFilterStr("curryear", queryDate, dateMap), dateMap).select(currMonthSic);
        DataSet currYearGroupDs = currYearDs.groupBy(new String[]{"company", "areaRange"}).sum("intflow_currmonth", "intflow_curryear").sum("outflow_currmonth", "outflow_curryear").sum("currmonthnetamt", "curryearnetamt").finish();
        currYearGroupDs = currYearGroupDs.select("company, areaRange, 0 as intflow_currday, 0 as outflow_currday, 0 as currdaynetamt, 0 as intflow_currmonth, 0 as outflow_currmonth, 0 as currmonthnetamt, intflow_curryear, outflow_curryear, curryearnetamt");
        DataSet allSet = currDayDs.union(currMonthDs).union(currYearGroupDs);
        return allSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        String type = SettleMgHelper.getAreaRange(paramMap);
        logger.info("SettleAmtFlowDataListPlugin filterResultDataSet areaRange: " + type);
        if (!"all".equals(type)) {
            ds = ds.filter("areaRange = '" + type + "'");
        }
        ds = ds.groupBy(new String[]{"company"}).sum(this.COUNT_FIELDS.get(0)).sum(this.COUNT_FIELDS.get(1)).sum(this.COUNT_FIELDS.get(2)).sum(this.COUNT_FIELDS.get(3)).sum(this.COUNT_FIELDS.get(4)).sum(this.COUNT_FIELDS.get(5)).sum(this.COUNT_FIELDS.get(6)).sum(this.COUNT_FIELDS.get(7)).sum(this.COUNT_FIELDS.get(8)).finish();
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet leftJoinDs = orgDateSet.leftJoin(ds).on("org", "company").select(new String[]{"org", "orgid", "rowid", "pid", "isgroupnode", "level", "mixorgname org_name", "sortcode", "intflow_currday", "outflow_currday", "currdaynetamt", "intflow_currmonth", "outflow_currmonth", "currmonthnetamt", "intflow_curryear", "outflow_curryear", "curryearnetamt"}).finish().addField("0", "sumlevel");
        DataSet sumResultSet = this.getSumDataSetByLevel(leftJoinDs, this.COUNT_FIELDS, "orgid,org_name,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        sumResultSet = EmptyUtil.isNoEmpty((Object)subOrgIds) ? sumResultSet.where("rowid in ids", Collections.singletonMap("ids", subOrgIds)) : sumResultSet.where("rowid in ids", Collections.singletonMap("ids", paramMap.get("allorgids")));
        sumResultSet = sumResultSet.addField("'groupcol'", "groupcol");
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        DataSet totalSet = this.addSubTotalDataSet(sumResultSet.copy(), Collections.singletonList("groupcol"), this.COUNT_FIELDS, "org_name").updateField("org_name", "'" + ((DynamicObject)parentOrgs.get(0)).getString("name") + "\uff08" + SettleAmtFlowDataListPlugin.getLoadKDString() + "\uff09'");
        sumResultSet = sumResultSet.orderBy(new String[]{"sortcode"});
        return sumResultSet.union(totalSet);
    }

    private static String getLoadKDString() {
        return ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SettleAmtFlowDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(10);
        fields.addAll(this.getSumFieldNames());
        return fields;
    }

    private List<String> getSumFieldNames() {
        ArrayList<String> fields = new ArrayList<String>(10);
        fields.add("intflow_currday");
        fields.add("intflow_currmonth");
        fields.add("intflow_curryear");
        fields.add("outflow_currday");
        fields.add("outflow_currmonth");
        fields.add("outflow_curryear");
        fields.add("currdaynetamt");
        fields.add("currmonthnetamt");
        fields.add("curryearnetamt");
        return fields;
    }
}

