/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.settle.qing.data.AbstractBigAmountFlowDetailPlugin;

public class BigAmountFlowDetailHelper {
    private static final String LONG_NUMBER = "longnumber";
    private static final String ORGLONG_NUMBER = "orglongnumber";
    private static final String SORGLONG_NUMBER = "sorglongnumber";

    public static DataSet getSecondOrgDs(Long orgViewId, Long orgId, DataSet dataSet) {
        String selectFields = "org.id orgid,org.name orgname,org.simplename simplename,org.number number,parent.id pid,longnumber,level,case when org.simplename = NULL OR TRIM(org.simplename) = '' then org.name else org.simplename end as mixorgname,sortcode";
        DataSet allOrgDs = QueryServiceHelper.queryDataSet((String)"tree-org", (String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("view.treetype", "=", (Object)"08"), new QFilter("view", "=", (Object)orgViewId)}, (String)"sortcode");
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        List<String> fieldList = Arrays.stream(fieldNames).collect(Collectors.toList());
        fieldList.add(LONG_NUMBER);
        fieldList.add("sortcode");
        dataSet = dataSet.leftJoin(allOrgDs).on("orgid", "orgid").select(fieldList.toArray(new String[0])).finish().filter("longnumber is not null");
        DataSet secondOrgDs = allOrgDs.filter("pid = orgid", Collections.singletonMap("orgid", orgId));
        DataSet[] secondOrgDsCopy = DataSetHelper.copy((DataSet)secondOrgDs);
        HashSet secondNumberSet = new HashSet(16);
        secondOrgDsCopy[0].forEach(e -> secondNumberSet.add(e.getString(LONG_NUMBER)));
        ArrayList<Object[]> numberCollection = new ArrayList<Object[]>(10);
        HashSet numberSet = new HashSet(16);
        DataSet[] dataSetCopy = DataSetHelper.copy((DataSet)dataSet);
        DataSet numberDs = dataSetCopy[0].groupBy(new String[]{LONG_NUMBER}).finish();
        numberDs.forEach(e -> numberSet.add(e.getString(LONG_NUMBER)));
        for (String longNumber : numberSet) {
            if (longNumber == null) continue;
            secondNumberSet.forEach(e -> {
                if (longNumber.startsWith((String)e)) {
                    numberCollection.add(new Object[]{longNumber, e});
                }
            });
        }
        DataSet longNumberDs = DecisionAnlsHelper.createRow(AbstractBigAmountFlowDetailPlugin.class.getName(), new String[]{ORGLONG_NUMBER, SORGLONG_NUMBER}, new DataType[]{DataType.StringType, DataType.StringType}, numberCollection);
        fieldList.add(SORGLONG_NUMBER);
        dataSet = dataSetCopy[1].leftJoin(longNumberDs).on(LONG_NUMBER, ORGLONG_NUMBER).select(fieldList.toArray(new String[0])).finish();
        fieldList.add("mixorgname");
        fieldList.remove("secondorg");
        fieldList.add("case when mixorgname != null then mixorgname else orgname end as secondorg");
        dataSet = dataSet.leftJoin(secondOrgDsCopy[1]).on(SORGLONG_NUMBER, LONG_NUMBER).select(fieldList.toArray(new String[0])).finish();
        return dataSet.orderBy(new String[]{"sortcode", "bizdate desc"});
    }
}

