/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.qing.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.settle.helper.BigAmountFlowDetailHelper;

public abstract class AbstractBigAmountFlowDetailPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String DATE_RANGE = "dateRange";
    protected static final String IN_FLOW = "InFlow";
    protected static final String OUT_FLOW = "OutFlow";

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DateUtils.getDataFormat((Date)DecisionAnlsHelper.getQueryDate(paramMap), (boolean)false);
        DataSet dataSet = SettleDataHelper.queryBigAmtSet((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, this.getOrgIds(paramMap), (Date)queryDate).filter(this.getFilter()).select(this.getSelectInfo());
        DynamicObject bigAmountSet = BusinessDataServiceHelper.loadSingle((String)"tda_bigamountset", (String)"bigamountgetterway", (QFilter[])new QFilter[0]);
        String sourceType = bigAmountSet.getString("bigamountgetterway");
        dataSet = dataSet.addField("case entityname when 'cas_paybill' then '0' when 'cas_recbill' then '0' when 'bei_transdetail' then '1' end", "sourcetype");
        dataSet = dataSet.filter("sourcetype = source", Collections.singletonMap("source", sourceType));
        String regionStr = "case region when 'domestic' then '%1$s' when 'overseas' then '%2$s' end";
        String regionExpr = String.format(regionStr, ResManager.loadKDString((String)"\u5883\u5185", (String)"AbstractBigAmountFlowDetailPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5883\u5916", (String)"AbstractBigAmountFlowDetailPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        dataSet = dataSet.updateField("region", regionExpr);
        Long currentOrgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        dataSet = BigAmountFlowDetailHelper.getSecondOrgDs(orgViewId, currentOrgId, dataSet);
        Set<String> amountFields = Collections.singleton("reportamount");
        dataSet = AmountTransHelper.tranDataSetRate((DataSet)dataSet, (Long)orgViewId, (Long)((Long)paramMap.get("basecurrency")), (String)"currency", amountFields, (Date)DecisionAnlsHelper.getQueryDate(paramMap));
        Date last7Day = DateUtils.getLastDay((Date)queryDate, (int)7);
        Date lastMonth = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)0);
        Date last2Month = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-1);
        Date last6Month = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-5);
        HashMap<String, Date> dateParamsMap = new HashMap<String, Date>(16);
        dateParamsMap.put("queryDate", queryDate);
        dateParamsMap.put("last7Day", last7Day);
        dateParamsMap.put("lastMonth", lastMonth);
        dateParamsMap.put("last2Month", last2Month);
        dateParamsMap.put("last6Month", last6Month);
        DataSet[] dataSets = DataSetHelper.splitByFilter((DataSet)dataSet, (String[])SettleDataHelper.FILTER_EXPRS, dateParamsMap, (boolean)false);
        DataSet sevenDayDataSet = dataSets[0].updateField(DATE_RANGE, "'seven_day' as dateRange");
        DataSet lastMonthDataSet = dataSets[1].updateField(DATE_RANGE, "'one_month' as dateRange");
        DataSet last2MonthDataSet = dataSets[2].updateField(DATE_RANGE, "'two_month' as dateRange");
        DataSet last6MonthDataSet = dataSets[3].updateField(DATE_RANGE, "'six_month' as dateRange");
        DataSet unionDs = sevenDayDataSet.union(new DataSet[]{lastMonthDataSet, last2MonthDataSet, last6MonthDataSet});
        DataSet resultSet = unionDs.addField(String.format("case when creditamount>0 then '%1$s' else '%2$s' end", ResManager.loadKDString((String)"\u6d41\u5165", (String)"AbstractBigAmountFlowDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6d41\u51fa", (String)"AbstractBigAmountFlowDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0])), "direction");
        resultSet = AmountTransHelper.dealAmountConvert((DataSet)resultSet, paramMap, amountFields);
        HashSet<String> amountUnitSet = new HashSet<String>(Arrays.asList(OUT_FLOW.equals(this.getRptType()) ? "debitamount" : "creditamount", "reportamount"));
        resultSet = AmountTransHelper.dealAmountUnit((DataSet)resultSet, paramMap, amountUnitSet);
        return resultSet;
    }

    protected abstract String getFilter();

    protected abstract String getSelectInfo();

    protected String getRptType() {
        return "";
    }
}

