/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.qing.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundFlowTrendDataPulgin
extends AbstractDecisionAnlsQingDataPlugin {
    private String MONTH_DATE = "monthdate";
    private String CLICK = "click";
    private Date starDate = null;
    private Date endDate = null;
    private int dateOffset = 12;
    private String COMPANY = "org";
    private String CURRENCY = "currency";
    private String CREDIT_AMOUNT = "creditamount";
    private String DEBIT_AMOUNT = "debitamount";
    private String NET_INFLOW = "net_inflow";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{this.CREDIT_AMOUNT, ResManager.loadKDString((String)"\u6536\u5165", (String)"FundFlowTrendDataPulgin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{this.DEBIT_AMOUNT, ResManager.loadKDString((String)"\u652f\u51fa", (String)"FundFlowTrendDataPulgin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{this.NET_INFLOW, ResManager.loadKDString((String)"\u51c0\u6d41\u5165", (String)"FundFlowTrendDataPulgin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{this.MONTH_DATE, ResManager.loadKDString((String)"\u6708\u4efd", (String)"FundFlowTrendDataPulgin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Date.toNumber(), false});
        fields.add(new Object[]{this.CLICK, ResManager.loadKDString((String)"\u70b9\u51fb\u7a7f\u900f\u5b57\u6bb5", (String)"FundFlowTrendDataPulgin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrencyId = (Long)paramMap.get("basecurrency");
        HashMap<String, Object> dateMap = new HashMap<String, Object>(2);
        String dateFilterStr = this.getDateFilterStr(queryDate, dateMap);
        DataSet transDetail = SettleDataHelper.queryTransDetailsSummary((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (Long)baseCurrencyId, this.getOrgIds(paramMap), (Date)queryDate).filter(dateFilterStr, dateMap).select(new String[]{this.COMPANY, this.MONTH_DATE, this.CURRENCY, this.CREDIT_AMOUNT, this.DEBIT_AMOUNT});
        RowMeta rowMeta = transDetail.getRowMeta();
        if (transDetail.isEmpty()) {
            List<String> fieldNames = Stream.of(rowMeta.getFieldNames()).collect(Collectors.toList());
            fieldNames.add(this.NET_INFLOW);
            List<DataType> dataTypes = Stream.of(rowMeta.getDataTypes()).collect(Collectors.toList());
            dataTypes.add((DataType)DataType.BigDecimalType);
            return DecisionAnlsHelper.createEmptyDataSet(fieldNames.toArray(new String[0]), dataTypes.toArray(new DataType[0]));
        }
        DataSet resultDataSet = transDetail.groupBy(new String[]{this.MONTH_DATE}).sum(this.CREDIT_AMOUNT).sum(this.DEBIT_AMOUNT).finish().addField(this.CREDIT_AMOUNT + "-" + this.DEBIT_AMOUNT, this.NET_INFLOW);
        resultDataSet = this.addAbsentMonthRow(resultDataSet);
        resultDataSet = resultDataSet.addField("'click'", this.CLICK);
        return resultDataSet;
    }

    private DataSet addAbsentMonthRow(DataSet dataSet) {
        ArrayList<Object[]> collection = new ArrayList<Object[]>();
        for (int i = 0; i < this.dateOffset; ++i) {
            Date month = DateUtils.getFirstDateOfAnyMonth((Date)this.starDate, (int)i);
            String monthStr = DateUtils.formatString((Date)month, (String)"yyyy-MM-dd");
            boolean exist = dataSet.copy().filter("TO_CHAR(" + this.MONTH_DATE + ",'yyyy-MM-dd')='" + monthStr + "'").hasNext();
            if (exist) continue;
            collection.add(new Object[]{DataType.convertValue((DataType)DataType.TimestampType, (Object)month), "0.00", "0.00", "0.00"});
        }
        DataSet createDataSet = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), dataSet.getRowMeta().getFieldNames(), dataSet.getRowMeta().getDataTypes(), collection);
        dataSet = dataSet.union(createDataSet);
        return dataSet;
    }

    private String getDateFilterStr(Date currentDate, Map<String, Object> dateMap) {
        this.starDate = DateUtils.getFirstDateOfAnyMonth((Date)currentDate, (int)(-this.dateOffset));
        this.endDate = DateUtils.getLastDateOfAnyMonth((Date)currentDate, (int)-1);
        dateMap.put("starDate", this.starDate);
        dateMap.put("endDate", this.endDate);
        String dateFilterStr = this.MONTH_DATE + ">=" + "starDate and " + this.MONTH_DATE + "<=" + "endDate";
        return dateFilterStr;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_fundflowtrendrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return this.CLICK;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_fundflowtrendrpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u91d1\u6d41\u5165\u6d41\u51fa\u8d8b\u52bf\u5206\u6790\u8868", (String)"FundFlowTrendDataPulgin_5", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(){
            {
                this.add(FundFlowTrendDataPulgin.this.CREDIT_AMOUNT);
                this.add(FundFlowTrendDataPulgin.this.DEBIT_AMOUNT);
                this.add(FundFlowTrendDataPulgin.this.NET_INFLOW);
            }
        };
    }
}

