/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.synthesis.helper;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.synthesis.helper.SynthesisRptDataHelper;

public class SynthesisChartDataHelper {
    private static final Log logger = LogFactory.getLog(SynthesisChartDataHelper.class);
    private static final int DEFAULT_PERIOD = 12;
    private static final int DEFAULT_COUNT_YEAR = 5;
    private static final String TMC_TDA_REPORT = "tmc-tda-report";
    public static final String FORMAT_YM = "yyyy-MM";

    public static DataSet queryChartData(String algoKey, Map<String, Object> paramMap) {
        if (EmptyUtil.isEmpty((Object)paramMap.get("orgview")) || EmptyUtil.isEmpty((Object)paramMap.get("org"))) {
            return DecisionAnlsHelper.createEmptyDataSet(new String[]{"empty"}, new DataType[]{DataType.StringType});
        }
        String cacheKey = SynthesisChartDataHelper.getCacheKey(paramMap);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (isQueryDataCache && !isNoCache) {
            DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
            List allOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgView.getLong("id"));
            return CacheManager.getCacheOrElseGet((Long)orgViewId, (String)algoKey, (String)cacheKey, () -> SynthesisChartDataHelper.doQueryChartData(algoKey, paramMap, orgViewId, allOrgIds)).filter("orgid = " + orgId);
        }
        return SynthesisChartDataHelper.doQueryChartData(algoKey, paramMap, orgViewId, Collections.singletonList(orgId));
    }

    private static DataSet doQueryChartData(String algoKey, Map<String, Object> paramMap, Long orgViewId, List<Long> orgIds) {
        long start = System.currentTimeMillis();
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        QFilter orgViewFilter = new QFilter("orgview.id", "=", (Object)orgViewId);
        QFilter orgFilter = new QFilter("org.id", "in", orgIds);
        queryDate = DecisionCommonHelper.fixQueryDate((Date)queryDate);
        Object[] paramsObjs = new Object[8];
        QFilter dateFilterBeforeThreeMonth = SynthesisRptDataHelper.getLiquidityQFilter(queryDate, paramsObjs);
        QFilter[] qFilters = new QFilter[]{orgViewFilter, orgFilter, dateFilterBeforeThreeMonth};
        String selStr = "assetsdebtrate" + ",accountyear,accountperiod";
        Object[] currMonthDs = TmcDataServiceHelper.load((String)"tda_liquiditybill", (String)selStr, (QFilter[])qFilters, (String)"accountyear desc,accountperiod desc");
        if (EmptyUtil.isNoEmpty((Object[])currMonthDs)) {
            int year = currMonthDs[0].getInt("accountyear");
            int period = currMonthDs[0].getInt("accountperiod");
            queryDate = DateUtils.getFirstDateOfAnyMonth((Date)DateUtils.stringToDate((String)(year + "-" + period), (String)FORMAT_YM), (int)1);
            block0: for (int i = 1; i <= 4; ++i) {
                int accountyear = (Integer)paramsObjs[2 * (i - 1)];
                int accountperiod = (Integer)paramsObjs[2 * i - 1];
                for (Object currMonth : currMonthDs) {
                    if (accountyear != currMonth.getInt("accountyear") || accountperiod != currMonth.getInt("accountperiod") || currMonth.getBigDecimal("assetsdebtrate").compareTo(BigDecimal.ZERO) == 0) continue;
                    queryDate = DateUtils.getFirstDateOfAnyMonth((Date)DateUtils.stringToDate((String)(accountyear + "-" + accountperiod), (String)FORMAT_YM), (int)1);
                    break block0;
                }
            }
        }
        QFilter dateFilter = SynthesisChartDataHelper.getLastFiveYearsFilter(queryDate);
        String queryProps = "org.id as orgid,accountyear as dateCol,intdebtamt, equityamt, assetsdebtrate, intdebtrate, intdebtequityrate, 0.6 as assetscordon, 0.4 as intdebtcordon";
        DataSet lastFiveYearDs = QueryServiceHelper.queryDataSet((String)(algoKey + "queryLastFiveYearDs"), (String)"tda_liquiditybill", (String)queryProps, (QFilter[])new QFilter[]{orgViewFilter, orgFilter, dateFilter}, null);
        lastFiveYearDs = lastFiveYearDs.updateField("dateCol", "cast(dateCol as String)");
        dateFilter = SynthesisChartDataHelper.getLastTwoMonthFilter(queryDate);
        queryProps = "org.id as orgid,accountyear,accountperiod,intdebtamt, equityamt, assetsdebtrate, intdebtrate, intdebtequityrate, 0.6 as assetscordon, 0.4 as intdebtcordon";
        DataSet lastTwoMonthDs = QueryServiceHelper.queryDataSet((String)(algoKey + "queryLastTwoMonthDs"), (String)"tda_liquiditybill", (String)queryProps, (QFilter[])new QFilter[]{orgViewFilter, orgFilter, dateFilter}, (String)"accountperiod");
        lastTwoMonthDs = lastTwoMonthDs.select("orgid,CONCAT(cast(accountyear as String),'-',case when len(cast(accountperiod as String)) = 1 then CONCAT('0',cast(accountperiod as String)) else cast(accountperiod as String) end) as dateCol,intdebtamt, equityamt, assetsdebtrate, intdebtrate, intdebtequityrate, assetscordon, intdebtcordon").orderBy(new String[]{"dateCol"});
        dateFilter = SynthesisChartDataHelper.getBudgetYearFilter(queryDate);
        String budgetStr = ResManager.loadKDString((String)"\u5e74\u5e95\u9884\u7b97", (String)"SynthesisQingDataPlugin_0", (String)TMC_TDA_REPORT, (Object[])new Object[0]);
        queryProps = "org.id as orgid,'" + budgetStr + "' as dateCol,intdebtamt, equityamt,assetsdebtrate,intdebtrate,intdebtequityrate, 0.6 as assetscordon, 0.4 as intdebtcordon";
        DataSet budgetYearDs = QueryServiceHelper.queryDataSet((String)(algoKey + "queryBuggetYearDs"), (String)"tda_budgetbill", (String)queryProps, (QFilter[])new QFilter[]{orgViewFilter, orgFilter, dateFilter}, null);
        DataSet resultDs = lastFiveYearDs.union(new DataSet[]{lastTwoMonthDs, budgetYearDs});
        logger.info("\u3010\u7efc\u5408\u5206\u6790\u56fe\u5f62\u3011\u53d6\u6570\uff1a" + algoKey + "cost:" + (System.currentTimeMillis() - start));
        resultDs = resultDs.updateFields(new String[]{"assetsdebtrate", "intdebtrate", "intdebtequityrate", "assetscordon", "intdebtcordon"}, new String[]{"assetsdebtrate * 100", "intdebtrate * 100", "intdebtequityrate * 100", "assetscordon * 100", "intdebtcordon * 100"});
        return resultDs;
    }

    public static String getCacheKey(Map<String, Object> paramMap) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        return "SynthesisChartDataHelper-cachekey-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }

    private static QFilter getBudgetYearFilter(Date queryDate) {
        int year = DateUtils.getYear((Date)queryDate);
        QFilter budgetYearQFilter = new QFilter("budgetyear", "=", (Object)year);
        return budgetYearQFilter;
    }

    private static QFilter getLastTwoMonthFilter(Date queryDate) {
        int yearOfLastTwoMonth;
        Date lastOneMonth = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-1);
        Date lastTwoMonth = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-2);
        int yearOfLastOneMonth = DateUtils.getYear((Date)lastOneMonth);
        if (yearOfLastOneMonth != (yearOfLastTwoMonth = DateUtils.getYear((Date)lastTwoMonth))) {
            QFilter lastOneMonthQFilter = new QFilter("accountyear", "=", (Object)yearOfLastOneMonth);
            lastOneMonthQFilter.and("accountperiod", "=", (Object)DateUtils.getMonth((Date)lastOneMonth));
            QFilter lastTwoMonthQFilter = new QFilter("accountyear", "=", (Object)yearOfLastTwoMonth);
            lastTwoMonthQFilter.and("accountperiod", "=", (Object)DateUtils.getMonth((Date)lastTwoMonth));
            return lastOneMonthQFilter.or(lastTwoMonthQFilter);
        }
        QFilter lastTwoMonthQFilter = new QFilter("accountyear", "=", (Object)yearOfLastOneMonth);
        lastTwoMonthQFilter.and("accountperiod", ">=", (Object)DateUtils.getMonth((Date)lastTwoMonth));
        lastTwoMonthQFilter.and("accountperiod", "<=", (Object)DateUtils.getMonth((Date)lastOneMonth));
        return lastTwoMonthQFilter;
    }

    private static QFilter getLastFiveYearsFilter(Date queryDate) {
        Date lastOneMonth = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-1);
        int year = DateUtils.getYear((Date)lastOneMonth);
        int month = DateUtils.getMonth((Date)queryDate);
        QFilter lastFiveYearQFilter = new QFilter("accountyear", ">=", (Object)(year - 5));
        if (2 == month) {
            lastFiveYearQFilter.and("accountyear", "<=", (Object)(year - 2));
        } else {
            lastFiveYearQFilter.and("accountyear", "<=", (Object)(year - 1));
        }
        lastFiveYearQFilter.and("accountperiod", "=", (Object)12);
        return lastFiveYearQFilter;
    }
}

