/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.common;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.helper.HomeOverviewHelper;
import kd.tmc.tda.common.helper.TdaLicenseCheckHelper;

public class DecisionAnlsCommonListPlugin
extends AbstractReportFormPlugin
implements SearchListener {
    public static final String ORGID = "orgid";
    public static final String FILTER = "filter";
    public static final String REPORTFILTERAP = "reportfilterap";
    public static final String FILTER_COMPANY = "filter_company";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportFilter filter = (ReportFilter)this.getControl(REPORTFILTERAP);
        filter.addSearchListener((SearchListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        TdaLicenseCheckHelper.checkTdaLicense((PreOpenFormEventArgs)e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String entityId = this.getView().getEntityId();
        Set pluginKeys = MetaToDetailPluginMap.getPluginMap().keySet();
        Set samePluginKeys = MetaToDetailPluginMap.getSamePluginMap().keySet();
        if (pluginKeys.contains(entityId) || samePluginKeys.stream().anyMatch(key -> key.contains(entityId))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_showdetail"});
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        this.getView().setVisible(Boolean.FALSE, new String[]{REPORTFILTERAP});
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.containsKey("next")) {
            this.initNextQueryParam(queryParam);
        } else if (customParams.containsKey("home")) {
            Map paramMap = HomeOverviewHelper.getParamMap();
            DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
            DynamicObject org = (DynamicObject)paramMap.get("org");
            DynamicObject currency = (DynamicObject)paramMap.get("currency");
            Date queryDate = (Date)paramMap.get("querydate");
            String amountUnit = (String)paramMap.get("amountunit");
            customParams.put("homePageQueryParamOrgViewId", orgView.getString("id"));
            customParams.put("homePageQueryParamQueryDate", DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd"));
            this.getView().cacheFormShowParameter();
            DynamicObject set = SnapDataHelper.getSnapVersion((long)orgView.getLong("id"), (Date)queryDate);
            if (EmptyUtil.isNoEmpty((DynamicObject)set)) {
                String snapItem = set.getString("number");
                queryParam.getCustomParam().put("snapItem", snapItem);
                this.getPageCache().put("snapItem", snapItem);
            }
            this.initDefaultQueryParam(orgView, org, queryDate, currency.getLong("id"), amountUnit);
        } else {
            IFormView parentView = SnapDataHelper.getParantView((IPageCache)this.getPageCache());
            if (parentView != null) {
                DynamicObject orgView = (DynamicObject)parentView.getModel().getValue("orgview");
                DynamicObject org = (DynamicObject)parentView.getModel().getValue("org");
                DynamicObject currency = (DynamicObject)parentView.getModel().getValue("currency");
                Date queryDate = (Date)parentView.getModel().getValue("querydate");
                String amountUnit = (String)parentView.getModel().getValue("amountunit");
                DynamicObject set = SnapDataHelper.getSnapVersion((IFormView)parentView, (boolean)false);
                if (EmptyUtil.isNoEmpty((DynamicObject)set)) {
                    String snapItem = set.getString("number");
                    queryParam.getCustomParam().put("snapItem", snapItem);
                    this.getPageCache().put("snapItem", snapItem);
                }
                this.initDefaultQueryParam(orgView, org, queryDate, currency.getLong("id"), amountUnit);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6253\u5f00\u3010\u51b3\u7b56\u5206\u6790\u3011-> [\u8d44\u6e90\u53ef\u89c6\u4e3b\u9898]\u540e\u91cd\u8bd5\u3002", (String)"DecisionAnlsCommonListPlugin_1", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void initDefaultQueryParam(DynamicObject orgView, DynamicObject org, Date querydate, Long currencyId, String amountunit) {
        this.getModel().setValue("orgview", (Object)orgView);
        DynamicObjectCollection orgs = new DynamicObjectCollection();
        orgs.add((Object)org);
        this.getModel().setValue(FILTER_COMPANY, (Object)orgs);
        this.getModel().setValue("querydate", (Object)querydate);
        this.getModel().setValue("currency", (Object)currencyId);
        this.getModel().setValue("amountunit", (Object)amountunit);
        ReportFilter rptFilter = (ReportFilter)this.getControl(REPORTFILTERAP);
        rptFilter.search();
    }

    protected void initNextQueryParam(ReportQueryParam queryParam) {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (!EmptyUtil.isEmpty(customParams.get(FILTER))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{REPORTFILTERAP});
            FilterInfo filter = (FilterInfo)SerializationUtils.deSerializeFromBase64((String)((String)customParams.get(FILTER)));
            if (customParams.get(ORGID) != null) {
                this.getModel().setValue(FILTER_COMPANY, (Object)new Object[]{Long.valueOf(customParams.get(ORGID).toString())});
            } else {
                this.getModel().setValue(FILTER_COMPANY, ((FilterItemInfo)filter.getFilterItems(FILTER_COMPANY).get(0)).getValue());
            }
            this.getModel().setValue("orgview", filter.getFilterItems("orgview") != null ? ((FilterItemInfo)filter.getFilterItems("orgview").get(0)).getValue() : null);
            this.getModel().setValue("currency", filter.getFilterItems("currency") != null ? ((FilterItemInfo)filter.getFilterItems("currency").get(0)).getValue() : null);
            this.getModel().setValue("querydate", filter.getFilterItems("querydate") != null ? ((FilterItemInfo)filter.getFilterItems("querydate").get(0)).getValue() : null);
            this.getModel().setValue("amountunit", filter.getFilterItems("amountunit") != null ? ((FilterItemInfo)filter.getFilterItems("amountunit").get(0)).getValue() : null);
            if (customParams.containsKey("home")) {
                DynamicObject set;
                String orgViewId = (String)customParams.get("homePageQueryParamOrgViewId");
                String queryDate = (String)customParams.get("homePageQueryParamQueryDate");
                if (orgViewId != null && queryDate != null && EmptyUtil.isNoEmpty((DynamicObject)(set = SnapDataHelper.getSnapVersion((long)Long.parseLong(orgViewId), (Date)DateUtils.stringToDate((String)queryDate, (String)"yyyy-MM-dd"))))) {
                    String snapItem = set.getString("number");
                    queryParam.getCustomParam().put("snapItem", snapItem);
                    this.getPageCache().put("snapItem", snapItem);
                }
            } else {
                DynamicObject set;
                IFormView parentView = SnapDataHelper.getParantView((IPageCache)this.getPageCache());
                if (parentView != null && EmptyUtil.isNoEmpty((DynamicObject)(set = SnapDataHelper.getSnapVersion((IFormView)parentView, (boolean)false)))) {
                    String snapItem = set.getString("number");
                    queryParam.getCustomParam().put("snapItem", snapItem);
                    this.getPageCache().put("snapItem", snapItem);
                }
            }
            ReportFilter rptFilter = (ReportFilter)this.getControl(REPORTFILTERAP);
            rptFilter.search();
        }
    }

    public boolean verifyQuery(ReportQueryParam param) {
        boolean isSuccess = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{FILTER_COMPANY, "querydate"});
        if (!isSuccess) {
            return false;
        }
        MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue(FILTER_COMPANY);
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
        List orgIdSet = orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        List orgIdList = TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIdSet, (boolean)true, (boolean)false);
        if (orgIdList.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u3002", (String)"DecisionAnlsCommonListPlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            return false;
        }
        param.getFilter().addFilterItem("allorgids", (Object)orgIdList);
        List subOrgIds = TmcOrgDataHelper.getSecondOrgIds((Long)orgView.getLong("id"), (Long)((Long)((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid").getPkValue()), (boolean)true, (boolean)false);
        if (subOrgIds != null) {
            param.getFilter().addFilterItem("suborgids", (Object)subOrgIds);
        }
        param.getFilter().addFilterItem("basecurrency", (Object)AmountTransHelper.getBaseCurrency((Long)orgView.getLong("id")));
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        param.getFilter().addFilterItem("pageid", (Object)showParameter.getPageId());
        if (this.getPageCache().getAll().containsKey("snapItem") && !"null".equalsIgnoreCase(this.getPageCache().get("snapItem"))) {
            param.getFilter().addFilterItem("snapItem", (Object)this.getPageCache().get("snapItem"));
        }
        param.getFilter().addFilterItem("formid", (Object)showParameter.getFormId());
        if (!param.getFilter().containProp("org")) {
            param.getFilter().addFilterItem("org", (Object)((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid"));
        }
        param.getFilter().addFilterItem("orgview", (Object)orgView);
        return true;
    }

    public void search(SearchEvent evt) {
        ReportQueryParam param = evt.getRepotParam();
        param.getCustomParam().put("search", "hand");
    }
}

