/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class DecisionAnlsPenetrateCommonListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String ORGID = "orgid";
    private static final String FILTER = "filter";
    private static final String ISGROUPNODE = "isgroupnode";
    private static final String GROUPNODEVALUE = "1";
    private static final String IS_MORTGAGE_TYPE = "ismortgagetype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        if (!EmptyUtil.isEmpty((Object)customParams)) {
            queryParam.getCustomParam().putAll(customParams);
        }
        return super.verifyQuery(queryParam);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_showdetail".equals(key)) {
            Map pluginInfo;
            ReportShowParameter param = new ReportShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter.getCustomParam("next") != null) {
                ReportQueryParam queryParam = this.getQueryParam();
                FilterInfo filter = queryParam.getFilter();
                Long orgId = Long.valueOf((String)formShowParameter.getCustomParam(ORGID));
                param.getCustomParams().put(ORGID, orgId);
                param.getCustomParams().put("next", true);
                String formId = this.getView().getFormShowParameter().getFormId();
                this.dealQueryParam(formId, filter, param);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            } else if (formShowParameter.getCustomParam("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            } else {
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)this.getQueryParam().getFilter()));
            }
            String entity = this.getView().getEntityId();
            entity = this.transmitQueryParam(entity, formShowParameter, param);
            if (MetaToDetailPluginMap.getSamePluginMap().get(entity) != null) {
                entity = (String)MetaToDetailPluginMap.getSamePluginMap().get(entity);
            }
            if ((pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity)).get("plugin") != null) {
                Pair pluginPair = (Pair)pluginInfo.get("plugin");
                param.setCaption((String)pluginPair.getValue1());
            }
            param.getCustomParams().put("entity", entity);
            param.setFormId("tda_treedetailcommonrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        if (event.getFieldName().startsWith("bankcate")) {
            return;
        }
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        String isGroupNode = row.getString(ISGROUPNODE);
        long orgId = row.getLong(ORGID);
        if (orgId == 0L || !GROUPNODEVALUE.equals(isGroupNode)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(ORGID, Long.toString(orgId));
        String formId = this.getView().getFormShowParameter().getFormId();
        this.dealQueryParam(formId, filter, param);
        param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
        param.getCustomParams().put("next", Boolean.TRUE);
        param.setFormId(formId);
        String caption = (String)param.getCustomParams().get("caption");
        if (StringUtils.isEmpty((String)caption)) {
            caption = this.getView().getFormShowParameter().getCaption();
        }
        if (StringUtils.isNotEmpty((String)caption)) {
            param.setCaption(caption);
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }

    private void dealQueryParam(String formId, FilterInfo filter, ReportShowParameter param) {
        switch (formId) {
            case "tda_lettercredit_amtnum": 
            case "tda_collfunddistbyorgrpt": 
            case "tda_bigamountflowsumrpt": {
                param.getCustomParams().put("dateRange", filter.getFilterItems("dateRange") != null ? ((FilterItemInfo)filter.getFilterItems("dateRange").get(0)).getValue() : null);
                break;
            }
            case "tda_extartopcustrpt": 
            case "tda_extaptopsupprpt": 
            case "tda_ap_sumrpt": 
            case "tda_ar_sumrpt": 
            case "tda_aragingsumrpt": 
            case "tda_apagingsumrpt": {
                param.getCustomParams().put("paymentDay", filter.getFilterItems("paymentDay") != null ? ((FilterItemInfo)filter.getFilterItems("paymentDay").get(0)).getValue() : null);
                param.getCustomParams().put("custsupptype", filter.getFilterItems("custsupptype") != null ? ((FilterItemInfo)filter.getFilterItems("custsupptype").get(0)).getValue() : null);
                break;
            }
            case "tda_settleamtflowrpt": 
            case "tda_settlecountflowrpt": {
                param.getCustomParams().put("areaRange", filter.getFilterItems("areaRange") != null ? ((FilterItemInfo)filter.getFilterItems("areaRange").get(0)).getValue() : null);
                break;
            }
            case "tda_gmcontractamtsumrpt": {
                param.getCustomParams().put(IS_MORTGAGE_TYPE, filter.getFilterItems(IS_MORTGAGE_TYPE) != null ? ((FilterItemInfo)filter.getFilterItems(IS_MORTGAGE_TYPE).get(0)).getValue() : null);
                break;
            }
            case "tda_guaranteedwayrpt": 
            case "tda_gmguaranteedrpt": 
            case "tda_exceedstocksumrpt": {
                param.getCustomParams().put("exceedstocktype", filter.getFilterItems("exceedstocktype") != null ? ((FilterItemInfo)filter.getFilterItems("exceedstocktype").get(0)).getValue() : null);
                break;
            }
            case "tda_gmoriginaltermrpt": 
            case "tda_gmresidualtermrpt": {
                param.getCustomParams().put("termType", filter.getFilterItems("termType") != null ? ((FilterItemInfo)filter.getFilterItems("termType").get(0)).getValue() : null);
                param.getCustomParams().put(IS_MORTGAGE_TYPE, filter.getFilterItems(IS_MORTGAGE_TYPE) != null ? ((FilterItemInfo)filter.getFilterItems(IS_MORTGAGE_TYPE).get(0)).getValue() : null);
                break;
            }
            case "tda_findebtsumrpt": 
            case "tda_intbearliadeadlinerpt": 
            case "tda_fintermdaterpt": {
                param.getCustomParams().put("statisticsType", filter.getFilterItems("statisticsType") != null ? ((FilterItemInfo)filter.getFilterItems("statisticsType").get(0)).getValue() : null);
                break;
            }
            case "tda_acctbankchangerpt": 
            case "tda_fincostbytermrpt": 
            case "tda_fincostcryprdrpt": 
            case "tda_fincostbybankrpt": {
                param.getCustomParams().put("dateRange", this.getQueryParam().getCustomParam().get("dateRange"));
                break;
            }
            case "tda_investamtbankrpt": {
                param.getCustomParams().put("customtype", filter.getFilterItems("customtype") != null ? ((FilterItemInfo)filter.getFilterItems("customtype").get(0)).getValue() : null);
                param.getCustomParams().put("datetype", filter.getFilterItems("datetype") != null ? ((FilterItemInfo)filter.getFilterItems("datetype").get(0)).getValue() : null);
                break;
            }
            case "tda_recbillbalcustrpt": {
                param.getCustomParams().put("displayType", filter.getFilterItems("displayType") != null ? ((FilterItemInfo)filter.getFilterItems("displayType").get(0)).getValue() : null);
                param.getCustomParams().put("rptype", filter.getFilterItems("rptype") != null ? ((FilterItemInfo)filter.getFilterItems("rptype").get(0)).getValue() : null);
                param.getCustomParams().put("caption", filter.getFilterItems("caption") != null ? ((FilterItemInfo)filter.getFilterItems("caption").get(0)).getValue() : null);
                break;
            }
            case "tda_recbillamtcustrankrpt": {
                param.getCustomParams().put("displayType", filter.getFilterItems("displayType") != null ? ((FilterItemInfo)filter.getFilterItems("displayType").get(0)).getValue() : null);
                param.getCustomParams().put("rptype", filter.getFilterItems("rptype") != null ? ((FilterItemInfo)filter.getFilterItems("rptype").get(0)).getValue() : null);
                param.getCustomParams().put("termtype", filter.getFilterItems("termtype") != null ? ((FilterItemInfo)filter.getFilterItems("termtype").get(0)).getValue() : null);
                param.getCustomParams().put("term", filter.getFilterItems("term") != null ? ((FilterItemInfo)filter.getFilterItems("term").get(0)).getValue() : null);
                param.getCustomParams().put("caption", filter.getFilterItems("caption") != null ? ((FilterItemInfo)filter.getFilterItems("caption").get(0)).getValue() : null);
                break;
            }
            case "tda_recdiscountorgrpt": {
                param.getCustomParams().put("dateRange", this.getView().getFormShowParameter().getCustomParams().get("dateRange"));
                break;
            }
            case "tda_fincostbankrpt": {
                param.getCustomParams().put("param", this.getView().getFormShowParameter().getCustomParams().get("param"));
                param.getCustomParams().put("splitBankCate", Boolean.TRUE);
                break;
            }
            case "tda_collfundtotalamtrpt": {
                param.getCustomParams().put("isdomestic", filter.getFilterItems("isdomestic") != null ? ((FilterItemInfo)filter.getFilterItems("isdomestic").get(0)).getValue() : null);
                param.getCustomParams().put("ccrdate", filter.getFilterItems("ccrdate") != null ? ((FilterItemInfo)filter.getFilterItems("ccrdate").get(0)).getValue() : null);
                break;
            }
            case "tda_collfunddistbyarearpt": {
                param.getCustomParams().put("areatype", filter.getFilterItems("areatype") != null ? ((FilterItemInfo)filter.getFilterItems("areatype").get(0)).getValue() : null);
                break;
            }
            case "tda_collfundbyareaprpt": {
                param.getCustomParams().put("click", filter.getFilterItems("click") != null ? ((FilterItemInfo)filter.getFilterItems("click").get(0)).getValue() : null);
                break;
            }
            case "tda_interloanbycurrpt": {
                param.getCustomParams().put("lendType", this.getView().getFormShowParameter().getCustomParams().get("lendType"));
                param.getCustomParams().put("comloanrange", this.getView().getFormShowParameter().getCustomParams().get("comloanrange"));
                break;
            }
            case "tda_bortermrpt": {
                param.getCustomParams().put("isDebit", this.getView().getFormShowParameter().getCustomParams().get("isDebit"));
                param.getCustomParams().put("comloanrange", this.getView().getFormShowParameter().getCustomParams().get("comloanrange"));
                break;
            }
            case "tda_borrowbalancerpt": {
                param.getCustomParams().put("comloanrange", this.getView().getFormShowParameter().getCustomParams().get("comloanrange"));
                break;
            }
            case "tda_loanbalancerpt": {
                param.getCustomParams().put("comloanrange", this.getView().getFormShowParameter().getCustomParams().get("comloanrange"));
                break;
            }
        }
    }

    private String transmitQueryParam(String entity, FormShowParameter formShowParameter, ReportShowParameter param) {
        switch (entity) {
            case "tda_fincostbytermrpt": 
            case "tda_fincostcryprdrpt": {
                param.getCustomParams().put("dateRange", formShowParameter.getCustomParam("dateRange"));
                param.getCustomParams().put("splitBankCate", Boolean.FALSE);
                break;
            }
            case "tda_fincostbybankrpt": {
                param.getCustomParams().put("dateRange", formShowParameter.getCustomParam("dateRange"));
                param.getCustomParams().put("splitBankCate", Boolean.TRUE);
                break;
            }
            case "tda_fincostbankrpt": {
                param.getCustomParams().put("splitBankCate", Boolean.TRUE);
                break;
            }
            case "tda_investamtbankrpt": {
                String[] stringArray;
                String clickField = (String)formShowParameter.getCustomParam("click");
                if (StringUtils.isNotEmpty((String)clickField)) {
                    stringArray = StringUtils.split((String)clickField, (boolean)true, (char[])new char[]{'_'});
                } else {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "month";
                    stringArray = stringArray2;
                    stringArray2[1] = "41";
                }
                String[] fields = stringArray;
                param.getCustomParams().put("customtype", fields[0]);
                param.getCustomParams().put("datetype", fields[1]);
                break;
            }
            case "tda_acctbankusagerpt": {
                param.getCustomParams().put("acctUsage", "true");
                break;
            }
            case "tda_acctbankinterface_rpt": {
                param.getCustomParams().put("bankInterface", "true");
                break;
            }
            case "tda_acctbankchangerpt": 
            case "tda_lettercredit_amtnum": 
            case "tda_bigamountflowsumrpt": {
                param.getCustomParams().put("dateRange", formShowParameter.getCustomParam("dateRange"));
                break;
            }
            case "tda_collfundtotalamtrpt": {
                param.getCustomParams().put("ccrdate", formShowParameter.getCustomParam("ccrdate"));
                break;
            }
            case "tda_collfundbyareaprpt": {
                param.getCustomParams().put("click", formShowParameter.getCustomParam("click"));
                break;
            }
            case "tda_recbillbalcustrpt": {
                String displayType = (String)formShowParameter.getCustomParam("displayType");
                param.getCustomParams().put("displayType", displayType);
                entity = entity + "_" + this.getRptType();
                break;
            }
            case "tda_recbillamtcustrankrpt": {
                entity = entity + "_" + this.getRptType();
                String displayType = (String)formShowParameter.getCustomParam("displayType");
                param.getCustomParams().put("displayType", displayType);
                String termType = (String)formShowParameter.getCustomParam("termtype");
                String term = (String)formShowParameter.getCustomParam("term");
                param.getCustomParams().put("customtype", StringUtils.isNotEmpty((String)termType) ? termType : "month");
                param.getCustomParams().put("datetype", StringUtils.isNotEmpty((String)term) ? term : "41");
                break;
            }
            case "tda_recdiscountorgrpt": {
                String dateRange = (String)this.getView().getFormShowParameter().getCustomParams().get("dateRange");
                String[] splitDateRange = dateRange.split("_");
                String customType = splitDateRange[0];
                String dateType = splitDateRange[1];
                param.getCustomParams().put("customtype", StringUtils.isNotEmpty((String)customType) ? customType : "month");
                param.getCustomParams().put("datetype", StringUtils.isNotEmpty((String)dateType) ? dateType : "41");
                break;
            }
            case "tda_cashcatefinrpt": {
                param.getCustomParams().put("finance", "finance");
                break;
            }
            case "tda_finformbydirrpt": {
                param.getCustomParams().put("financemode", GROUPNODEVALUE);
                break;
            }
            case "tda_finformbyindirrpt": {
                param.getCustomParams().put("financemode", "0");
                break;
            }
            case "tda_borrowbalancerpt": {
                param.getCustomParams().put("isDebt", Boolean.TRUE);
                param.getCustomParams().put("isTerm", Boolean.FALSE);
                param.getCustomParams().put("comloanrange", this.getView().getFormShowParameter().getCustomParams().get("comloanrange"));
                break;
            }
            case "tda_loanbalancerpt": {
                param.getCustomParams().put("isDebt", Boolean.FALSE);
                param.getCustomParams().put("isTerm", Boolean.FALSE);
                param.getCustomParams().put("comloanrange", this.getView().getFormShowParameter().getCustomParams().get("comloanrange"));
                break;
            }
            case "tda_interloanbycurrpt": {
                Boolean isDebt = "org".equals(this.getView().getFormShowParameter().getCustomParams().get("lendType"));
                entity = isDebt != false ? entity + "_debt" : entity + "_credit";
                param.getCustomParams().put("isDebt", isDebt);
                param.getCustomParams().put("isTerm", Boolean.FALSE);
                param.getCustomParams().put("comloanrange", this.getView().getFormShowParameter().getCustomParams().get("comloanrange"));
                break;
            }
            case "tda_bortermrpt": {
                Boolean isTermDebt = (Boolean)this.getView().getFormShowParameter().getCustomParams().get("isDebit");
                entity = isTermDebt != false ? entity + "_debt" : entity + "_credit";
                param.getCustomParams().put("isDebt", isTermDebt);
                param.getCustomParams().put("isTerm", Boolean.TRUE);
                param.getCustomParams().put("comloanrange", this.getView().getFormShowParameter().getCustomParams().get("comloanrange"));
                break;
            }
        }
        return entity;
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject row = packageDataEvent.getRowData();
        String isGroupNode = row.getString(ISGROUPNODE);
        Object formatValue = packageDataEvent.getFormatValue();
        String fieldKey = ((ReportColumn)packageDataEvent.getSource()).getFieldKey();
        if (formatValue != null && !fieldKey.startsWith("bankcate") && !GROUPNODEVALUE.equals(isGroupNode)) {
            packageDataEvent.getNoLinkKey().add(fieldKey);
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        Boolean isEmpty;
        super.afterQuery(queryParam);
        if (EmptyUtil.isNoEmpty(queryParam.getCustomParam().get("isEmpty")) && Boolean.TRUE.equals(isEmpty = (Boolean)queryParam.getCustomParam().get("isEmpty"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u4e0b\u7ea7\u7ec4\u7ec7\u6570\u636e\u3002", (String)"DecisionAnlsPenetrateCommonListPlugin_1", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
        }
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        ReportView reportView = (ReportView)this.getView();
        ReportListModel reportModel = (ReportListModel)reportView.getReportList().getReportModel();
        List reportColumnList = reportModel.getReportTaskResult().getReportColumnList();
        Set<String> columns = reportColumnList.stream().map(ReportColumn::getFieldKey).collect(Collectors.toSet());
        String mergeName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"DecisionAnlsPenetrateCommonListPlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]);
        ArrayList<String> ruleNames = new ArrayList<String>(Arrays.asList("org_name", "mixorgname", "orgname"));
        ruleNames.retainAll(columns);
        if (ruleNames.size() == 0) {
            return;
        }
        StringBuilder conditionBuilder = new StringBuilder((String)ruleNames.get(0)).append(" = '").append(mergeName).append("'");
        if (CollectionUtils.isNotEmpty(columns) && CollectionUtils.isNotEmpty(ruleNames)) {
            columns.forEach(fieldKey -> {
                CellStyleRule cellStyleRule = this.createCellStyleRule("red", (String)fieldKey, conditionBuilder.toString());
                cellStyleRules.add(cellStyleRule);
            });
            columns.forEach(fieldKey -> {
                String s = String.format(" and (%1$s ='0.00' or %1$s ='0.00 %%' or %1$s ='0.00%%')", fieldKey);
                CellStyleRule cellStyleRule = this.createCellStyleRule("white", (String)fieldKey, conditionBuilder + s);
                cellStyleRules.add(cellStyleRule);
            });
        }
        super.setCellStyleRules(cellStyleRules);
    }

    private CellStyleRule createCellStyleRule(String color, String fieldKey, String condition) {
        CellStyleRule cellStyleRule = new CellStyleRule();
        cellStyleRule.setFieldKey(fieldKey);
        cellStyleRule.setForeColor(color);
        cellStyleRule.setBackgroundColor("white");
        cellStyleRule.setDegree(100);
        cellStyleRule.setCondition(condition);
        return cellStyleRule;
    }

    private String getRptType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String type = (String)customParams.get("rptype");
        if (type == null || type.isEmpty()) {
            type = "receivebill";
        }
        return type;
    }
}

