/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.designer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.snap.IDataSnapExecute;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CustomControlUtil;
import kd.tmc.tda.common.helper.HomeOverviewHelper;
import kd.tmc.tda.common.helper.ReportDesignControlHelper;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.common.helper.TdaLicenseCheckHelper;
import kd.tmc.tda.common.propertys.PeportDesignerVOProp;
import kd.tmc.tda.mservice.design.ReportDesignScheduleService;

public class ReportDesignerControlPlugin
extends AbstractFormPlugin {
    private static final List<String> waitList = new ArrayList<String>(){
        {
            this.add("tda_anls_home");
            this.add("tda_conf_fundccr");
            this.add("tda_anls_synthesis");
            this.add("tda_anls_synthesis_blue");
            this.add("tda_anls_cashanls");
            this.add("tda_anls_cashanls_blue");
            this.add("tda_anls_liquidity");
            this.add("tda_anls_liquidity_blue");
        }
    };
    private static final Log logger = LogFactory.getLog(ReportDesignerControlPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        TdaLicenseCheckHelper.checkTdaLicense((PreOpenFormEventArgs)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String args = e.getEventArgs();
        String eventName = this.substringEventName(e.getEventName());
        CustomControl customControl = (CustomControl)this.getView().getControl(key);
        String configtag = null;
        switch (eventName) {
            case "init": {
                if (EmptyUtil.isNoEmpty((String)args)) {
                    configtag = this.getCustomControlConfigItem(JSON.parseArray((String)args), "configtag");
                }
                if (EmptyUtil.isEmpty(configtag)) {
                    configtag = ReportDesignerControlPlugin.getConfigtagFromUrl(e);
                }
                ReportDesignerControlPlugin.waitLoadFrontScheme(configtag);
                if (!EmptyUtil.isNoEmpty((String)configtag)) break;
                JSONObject jsonObject = ReportDesignControlHelper.buildDesignAllData((String)configtag, (String)"selectconfig");
                customControl.setData((Object)jsonObject);
                break;
            }
            case "selectconfig": {
                if (EmptyUtil.isEmpty((String)args)) break;
                JSONObject jsonObject = ReportDesignControlHelper.buildDesignAllData((String)args, (String)"selectconfig");
                if (EmptyUtil.isEmpty((Object)jsonObject)) {
                    JSONObject object = new JSONObject();
                    object.put("data", null);
                    customControl.setData((Object)object);
                    this.getView().showErrorNotification(this.showConfirmForSelectConfigMsg());
                    break;
                }
                customControl.setData((Object)jsonObject);
                break;
            }
            case "selectoption": {
                boolean isSuccess;
                JSONObject optionSetData;
                if (EmptyUtil.isEmpty((String)args)) break;
                JSONObject jsonStrPulgin = JSON.parseObject((String)args);
                IFormView parentView = SnapDataHelper.getParantView((IPageCache)this.getPageCache());
                if (EmptyUtil.isEmpty((Object)parentView)) {
                    parentView = this.getView();
                }
                Map paramMap = CustomControlUtil.getParamMap((IFormView)parentView);
                configtag = ReportDesignerControlPlugin.getConfigtagFromUrl(e);
                if (EmptyUtil.isNoEmpty((String)configtag) && "tda_anls_home".equals(configtag)) {
                    HomeOverviewHelper.getParamMap((Map)paramMap);
                }
                if (!EmptyUtil.isNoEmpty((Object)(optionSetData = this.getOptionSetData(jsonStrPulgin, "selectoption", true, paramMap))) || !(isSuccess = MutexServiceHelper.request((String)optionSetData.get((Object)"invokeKey").toString(), (String)"tda_diagram", (String)"selectoption"))) break;
                try {
                    customControl.setData((Object)optionSetData);
                    break;
                }
                catch (Exception exception) {
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)exception));
                    break;
                }
                finally {
                    MutexServiceHelper.release((String)optionSetData.get((Object)"invokeKey").toString(), (String)"tda_diagram", (String)"selectoption");
                }
            }
            case "saveconfig": {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ReportDesignControlHelper.editDesignConfigData((JSONObject)JSONObject.parseObject((String)args))});
                break;
            }
            case "saveoption": {
                JSONObject jsonOptionObject = JSONObject.parseObject((String)args);
                QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)((Long)jsonOptionObject.get((Object)"id"))), new QFilter("enable", "=", (Object)"1")};
                DynamicObject dynamicOptionObject = BusinessDataServiceHelper.loadSingle((String)"tda_diagram", (String)"id, billno, name, configtext_tag, optiontext_tag, positiontext_tag, type, pluginname, version, versiondescribe, ispublish", (QFilter[])qFilters);
                PeportDesignerVOProp designerVO = ReportDesignControlHelper.buildJSONObjectForOption((JSONObject)jsonOptionObject);
                if (!EmptyUtil.isNoEmpty((DynamicObject)dynamicOptionObject)) break;
                if (designerVO.getVersion().equals(dynamicOptionObject.getString("version"))) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ReportDesignControlHelper.editBuildOptionData((DynamicObject)dynamicOptionObject, (PeportDesignerVOProp)designerVO)});
                    this.getView().showErrorNotification(this.showConfirmForSucessMsg());
                    break;
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ReportDesignControlHelper.createBuildOptionJSONObect((DynamicObject)dynamicOptionObject, (PeportDesignerVOProp)designerVO, null)});
                this.getView().showErrorNotification(this.showConfirmForSucessEditOptionMsg());
                break;
            }
            case "save": {
                JSONObject jsonData = JSONObject.parseObject((String)args);
                JSONArray jsonArray = (JSONArray)jsonData.get((Object)"itemList");
                JSONObject pageConfig = (JSONObject)jsonData.get((Object)"pageConfig");
                JSONArray jsonDelArray = (JSONArray)jsonData.get((Object)"deleteList");
                if (EmptyUtil.isEmpty((Object)pageConfig.get((Object)"configtag"))) {
                    this.getView().showErrorNotification(this.showConfirmForConfigWarnMsg());
                    break;
                }
                DynamicObject dynamicConfigObject = ReportDesignControlHelper.buildDesignConfigData((JSONObject)jsonData);
                DynamicObjectCollection dynamicObjectOption = ReportDesignControlHelper.buildDesignOptionData((JSONArray)jsonArray, (DynamicObject)dynamicConfigObject);
                if (!EmptyUtil.isNoEmpty((DynamicObject)dynamicConfigObject) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicObjectOption)) break;
                ReportDesignControlHelper.saveAndEditDesignerData((DynamicObject)dynamicConfigObject, (DynamicObjectCollection)dynamicObjectOption, (JSONArray)jsonDelArray);
                this.getView().showSuccessNotification(this.showConfirmForSucessMsg());
                break;
            }
            case "clickcharts": {
                if (EmptyUtil.isEmpty((String)args)) {
                    return;
                }
                Map tempParamMap = CustomControlUtil.getParamMap((IFormView)this.getView());
                JSONObject argsObject = JSONObject.parseObject((String)args);
                String pluginName = argsObject.getString("pluginname");
                try {
                    IDataSnapExecute pluginInstance = (IDataSnapExecute)Class.forName(pluginName).newInstance();
                    ReportShowParameter showParameter = new ReportShowParameter();
                    showParameter.setFormId((String)TdaCommonHelper.invokeMethod((IDataSnapExecute)pluginInstance, (String)"getShowFormId", (Object[])new Object[0]));
                    TdaCommonHelper.invokeMethod((IDataSnapExecute)pluginInstance, (String)"updateShowParam", (Object[])new Object[]{showParameter, argsObject, this.getPageCache(), tempParamMap});
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                }
            }
            case "invokeCustomEvent": {
                try {
                    if (EmptyUtil.isEmpty((String)args)) {
                        return;
                    }
                    Map fromHomeParamMap = CustomControlUtil.getParamMap((IFormView)this.getView());
                    JSONObject fromHomeArgsObject = JSONObject.parseObject((String)args).getJSONObject("content").getJSONObject("param");
                    String homepluginName = fromHomeArgsObject.getString("pluginname");
                    try {
                        IDataSnapExecute pluginInstance = (IDataSnapExecute)Class.forName(homepluginName).newInstance();
                        ReportShowParameter showParameter = new ReportShowParameter();
                        showParameter.setFormId((String)TdaCommonHelper.invokeMethod((IDataSnapExecute)pluginInstance, (String)"getShowFormId", (Object[])new Object[0]));
                        Object refreshFromHome = TdaCommonHelper.invokeMethod((IDataSnapExecute)pluginInstance, (String)"refreshFromHome", (Object[])new Object[0]);
                        if (refreshFromHome != null && ((Boolean)refreshFromHome).booleanValue()) {
                            showParameter.getCustomParams().put("home", Boolean.TRUE);
                        }
                        TdaCommonHelper.invokeMethod((IDataSnapExecute)pluginInstance, (String)"updateShowParam", (Object[])new Object[]{showParameter, fromHomeArgsObject, this.getPageCache(), fromHomeParamMap});
                        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        this.getView().showForm((FormShowParameter)showParameter);
                    }
                    catch (Exception ex) {
                        logger.error((Throwable)ex);
                    }
                    break;
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                }
            }
        }
    }

    private static void waitLoadFrontScheme(String configtag) {
        if (waitList.contains(configtag)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static String getConfigtagFromUrl(CustomEventArgs e) {
        IFormView showFormView = (IFormView)e.getSource();
        FormShowParameter formShowParameter = showFormView.getFormShowParameter();
        return (String)formShowParameter.getCustomParams().get("configtag");
    }

    private String getCustomControlConfigItem(JSONArray configItems, String itemKey) {
        if (EmptyUtil.isEmpty((String)itemKey)) {
            return "";
        }
        String result = "";
        for (Object obj : configItems) {
            JSONObject jsonObject;
            String key;
            if (obj == null || !itemKey.equals(key = (jsonObject = (JSONObject)obj).getString("key"))) continue;
            result = jsonObject.getString("value");
            break;
        }
        return result;
    }

    private JSONObject getOptionSetData(JSONObject jsonArgs, String invokeKey, Boolean userConfigFlag, Map<String, Object> paramMap) {
        JSONObject jsonObject = new JSONObject();
        JSONArray idArray = (JSONArray)jsonArgs.get((Object)"ids");
        String pulginName = jsonArgs.get((Object)"pluginname").toString();
        List idList = JSON.parseArray((String)idArray.toJSONString(), String.class);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", idList.stream().map(Long::parseLong).collect(Collectors.toList())), new QFilter("ispublish", "=", (Object)1), new QFilter("enable", "=", (Object)"1")};
        JSONObject jsonOption = ReportDesignControlHelper.buildDesignForOption((JSONObject)jsonObject, (QFilter[])qFilters, (String)invokeKey, (Boolean)userConfigFlag);
        ReportDesignScheduleService service = new ReportDesignScheduleService();
        String[] pulgins = pulginName.split(",");
        ArrayList<String> pulginList = new ArrayList<String>(Arrays.asList(pulgins));
        return service.batchRunDesignSchedule(pulginList, paramMap, jsonOption);
    }

    private String substringEventName(String eventName) {
        return EmptyUtil.isNoEmpty((String)eventName) && eventName.contains("/") ? eventName.substring(0, eventName.indexOf("/")) : eventName;
    }

    private String showConfirmForSelectConfigMsg() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5927\u5c4f\u6807\u8bc6,\u8bf7\u68c0\u67e5\u8f93\u5165\u5185\u5bb9\u3002", (String)"TdaParamSettingPlugin_13", (String)"tmc-tda-formplugin", (Object[])new Object[0]);
    }

    private String showConfirmForSucessMsg() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TdaParamSettingPlugin_11", (String)"tmc-tda-formplugin", (Object[])new Object[0]);
    }

    private String showConfirmForSucessEditOptionMsg() {
        return ResManager.loadKDString((String)"\u56fe\u8868\u7248\u672c\u65b0\u589e\u6210\u529f\u3002", (String)"TdaParamSettingPlugin_14", (String)"tmc-tda-formplugin", (Object[])new Object[0]);
    }

    private String showConfirmForConfigWarnMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5927\u5c4f\u6807\u8bc6\u3002", (String)"TdaParamSettingPlugin_15", (String)"tmc-tda-formplugin", (Object[])new Object[0]);
    }

    private String showConfirmForConfigUpdateWarnMsg() {
        return ResManager.loadKDString((String)"\u9884\u5236\u7248\u672c\u53ea\u5141\u8bb8\u521b\u5efa\u4eba\u4fee\u6539\u3002", (String)"TdaParamSettingPlugin_16", (String)"tmc-tda-formplugin", (Object[])new Object[0]);
    }
}

