/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.finance;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PeriodDimSetPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String METRICS = "metrics";
    private static final String SHOWTYPE = "showtype";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private static final String TDA_PREFIX = "tda_";
    private static final int MAX_MONTH = 12;
    private static final int MAX_YEAR = 12;
    private static final int MIN = 0;
    public static final int MIN_MONTH = 6;
    public static final int MIN_YEAR = 5;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit metricsEdit = (BasedataEdit)this.getView().getControl(METRICS);
        metricsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterBindData(EventObject e) {
        if ("ADDNEW".equals(((BaseView)e.getSource()).getStatus().name())) {
            this.getModel().setValue(METRICS, null);
        }
        String showType = (String)this.getModel().getValue(SHOWTYPE);
        this.showTypeControl(showType);
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (property) {
            case "metrics": {
                DynamicObject[] periodDimSets;
                HashSet<Long> idSet = new HashSet<Long>();
                for (DynamicObject dynamicObject : periodDimSets = TmcDataServiceHelper.load((String)"tda_perioddimset", (String)METRICS, null)) {
                    DynamicObjectCollection metrics = dynamicObject.getDynamicObjectCollection(METRICS);
                    for (DynamicObject scheduleJob : metrics) {
                        idSet.add(scheduleJob.getLong("fbasedataid_id"));
                    }
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", idSet).and("number", "ftlike", (Object)TDA_PREFIX));
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        this.saveValidator(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "showtype": {
                String showType = (String)this.getModel().getValue(SHOWTYPE);
                this.getModel().setValue(MONTH, (Object)0);
                this.getModel().setValue(YEAR, (Object)0);
                this.showTypeControl(showType);
                break;
            }
        }
    }

    private void showTypeControl(String showType) {
        if (showType.equals(MONTH)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MONTH});
            ((DecimalEdit)this.getView().getControl(MONTH)).setMustInput(Boolean.TRUE.booleanValue());
            this.getView().setVisible(Boolean.FALSE, new String[]{YEAR});
            ((DecimalEdit)this.getView().getControl(YEAR)).setMustInput(Boolean.FALSE.booleanValue());
            return;
        }
        if (showType.equals(YEAR)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{YEAR});
            ((DecimalEdit)this.getView().getControl(YEAR)).setMustInput(Boolean.TRUE.booleanValue());
            this.getView().setVisible(Boolean.FALSE, new String[]{MONTH});
            ((DecimalEdit)this.getView().getControl(MONTH)).setMustInput(Boolean.FALSE.booleanValue());
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{MONTH, YEAR});
        ((DecimalEdit)this.getView().getControl(MONTH)).setMustInput(Boolean.TRUE.booleanValue());
        ((DecimalEdit)this.getView().getControl(YEAR)).setMustInput(Boolean.TRUE.booleanValue());
    }

    private void saveValidator(BeforeClickEvent evt) {
        Integer month = (Integer)this.getModel().getValue(MONTH);
        Integer year = (Integer)this.getModel().getValue(YEAR);
        String showType = (String)this.getModel().getValue(SHOWTYPE);
        String number = (String)this.getModel().getValue("number");
        String name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
        Long id = (Long)this.getModel().getValue("id");
        if (EmptyUtil.isNoEmpty((String)number) && id == 0L) {
            QFilter filter = new QFilter("number", "=", (Object)number);
            filter.or("name", "=", (Object)name);
            boolean exists = QueryServiceHelper.exists((String)"tda_perioddimset", (QFilter[])filter.toArray());
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f16\u7801\u6216\u8005\u540d\u79f0\u76f8\u540c\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u5f55\u5165\u3002", (String)"PeriodDimSetPlugin_5", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
        }
        if (MONTH.equals(showType)) {
            if (month > 12) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u6570\u6700\u5927\u4e3a12\u3002", (String)"PeriodDimSetPlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (month < 6) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u6570\u9700\u5927\u4e8e\u7b49\u4e8e6\u3002", (String)"PeriodDimSetPlugin_1", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
        }
        if (YEAR.equals(showType)) {
            if (year > 12) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e74\u6570\u6700\u5927\u4e3a12\u3002", (String)"PeriodDimSetPlugin_2", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (year < 5) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e74\u6570\u9700\u5927\u4e8e\u7b49\u4e8e5\u3002", (String)"PeriodDimSetPlugin_3", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
        }
        if (month > 12) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u6570\u6700\u5927\u4e3a12\u3002", (String)"PeriodDimSetPlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        if (year > 12) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e74\u6570\u6700\u5927\u4e3a12\u3002", (String)"PeriodDimSetPlugin_2", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        if (year < 0 || month < 0 || year == 0 && month == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u6570\u548c\u5e74\u6570\u9700\u5927\u4e8e0\u3002", (String)"PeriodDimSetPlugin_4", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
    }
}

