/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.home;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.qing.plugin.actionhandler.QingActionDispatcher;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DecisionAnlsVisualEnum;
import kd.tmc.tda.common.helper.TdaCommonHelper;

public abstract class AbstractDecisionAnlsHomePlugin
extends AbstractFormPlugin
implements ListRowClickListener,
TabSelectListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AbstractDecisionAnlsHomePlugin.class);
    public static final String SET_CALL_BACK = "setCallBack";
    public static final String QUERY_CALL_BACK = "queryCallBack";
    private static final String BTN_SET = "btnset";
    private static final String LABEL_ORGVIEW = "labelorgview";
    private static final String LABEL_ORG = "labelorg";
    private static final String LABEL_QUERYDATE = "labelquerydate";
    private static final String LABEL_CURRENCY = "labelcurrency";
    private static final String LABEL_AMOUNTUNIT = "labelamountunit";
    private static final String BLUE_SUFFIX = "_bl";
    private static final String topBackgroundImg = "/kingdee/tmc/images/pc/tda/bg/tda_blue_hometop_new.png";
    private static final String CURRENT_LABEL_CLICKED = "labelClicked";

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if ("linkageJump".equals(e.getEventName())) {
            QingActionDispatcher.dispatch((CustomEventArgs)e, (IFormView)this.getView());
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        DynamicObject defaultSet = TdaCommonHelper.getCurrentUserDefaultSet();
        String formId = e.getFormShowParameter().getFormId();
        if (EmptyUtil.isNoEmpty((DynamicObject)defaultSet) && "blue".equals(defaultSet.getString("theme")) && !formId.endsWith(BLUE_SUFFIX)) {
            String blueFormId = "tda_resvisual_new".equals(formId) ? "tda_declsviewblue_new_bl" : ("tda_configtheme_new".equals(formId) ? "tda_configtheme_new_bl" : formId + BLUE_SUFFIX);
            e.getFormShowParameter().setFormId(blueFormId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SET, "btnrefresh", LABEL_ORGVIEW, LABEL_ORG, LABEL_QUERYDATE, LABEL_CURRENCY, LABEL_AMOUNTUNIT});
        this.addItemClickListeners(new String[]{BTN_SET, "btnrefresh", LABEL_ORGVIEW, LABEL_ORG, LABEL_QUERYDATE, LABEL_CURRENCY, LABEL_AMOUNTUNIT});
        Tab mianTab = (Tab)this.getView().getControl("tabap");
        mianTab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit orgview = (BasedataEdit)this.getView().getControl("orgview");
        orgview.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tabController = (Tab)this.getView().getControl("tabcontroller");
        if (tabController != null) {
            tabController.addTabSelectListener(tabSelectEvent -> {
                String tabKey = tabSelectEvent.getTabKey();
                this.configContainerLabel(tabKey);
            });
        }
    }

    public void createNewData(BizDataEventArgs e) {
        if (!this.getPageCache().getAll().containsKey("coderefresh")) {
            long orgViewId;
            DynamicObject set = TdaCommonHelper.getCurrentUserDefaultSet();
            String amountUnit = "100000000";
            Date date = new Date();
            long userId = RequestContext.get().getCurrUserId();
            boolean isEnableDefaultOrgView = AbstractDecisionAnlsHomePlugin.isEnableDefaultOrgView();
            if (set == null) {
                DynamicObject userSetDy = TmcDataServiceHelper.newDynamicObject((String)"tda_userdefaultset");
                userSetDy.set("user", (Object)userId);
                orgViewId = this.getDefaultOrgViewId(userId, isEnableDefaultOrgView);
                if (orgViewId == 0L) {
                    this.showSetPage();
                    return;
                }
                userSetDy.set("orgview", (Object)orgViewId);
                userSetDy.set("amountunit", (Object)amountUnit);
                userSetDy.set("creator", (Object)userId);
                userSetDy.set("modifier", (Object)userId);
                userSetDy.set("createdate", (Object)date);
                userSetDy.set("modifydate", (Object)date);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{userSetDy});
            } else {
                orgViewId = set.getLong("orgview.id");
                amountUnit = set.getString("amountunit");
                if (!isEnableDefaultOrgView && orgViewId == TdaCommonHelper.DEFAULT_FUN_ORG_VIEW_ID) {
                    orgViewId = this.getDefaultOrgViewId(userId, isEnableDefaultOrgView);
                    if (0L == orgViewId) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\uff0c\u8bf7\u914d\u7f6e\u7ec4\u7ec7\u89c6\u56fe\u6743\u9650\u6216\u542f\u7528\u9ed8\u8ba4\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"DecisionAnlsVisualResHomePlugin_1", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                    }
                    set.set("modifydate", (Object)date);
                    set.set("orgview", (Object)orgViewId);
                    set.set("amountunit", (Object)"100000000");
                    TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{set});
                }
            }
            this.getPageCache().put("orgview", String.valueOf(orgViewId));
            this.getPageCache().put("amountunit", amountUnit);
            this.appCache();
        }
        this.getPageCache().remove("coderefresh");
        if ("tda_declsviewblue_new_bl".equals(this.getView().getFormShowParameter().getFormId()) || "tda_configtheme_new_bl".equals(this.getView().getFormShowParameter().getFormId())) {
            Container containerTop = (Container)this.getControl("hometop");
            containerTop.setBackgroundImg(topBackgroundImg);
            this.getPageCache().put(CURRENT_LABEL_CLICKED, DecisionAnlsVisualEnum.LABEL_SYNTHESIS_NEW_BL.getName());
        }
    }

    public void afterCreateNewData(EventObject e) {
        String orgViewId = this.getPageCache().get("orgview");
        String amountUnit = this.getPageCache().get("amountunit");
        amountUnit = EmptyUtil.isEmpty((String)amountUnit) ? "100000000" : amountUnit;
        Long orgView = EmptyUtil.isEmpty((String)orgViewId) ? Long.valueOf(0L) : Long.valueOf(orgViewId);
        this.getModel().setValue("orgview", (Object)orgView);
        this.getModel().setValue("amountunit", (Object)amountUnit);
        Long orgId = TdaCommonHelper.getRootPermOrgIdByOrgView((Long)orgView);
        if (EmptyUtil.isEmpty((Long)orgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u89c6\u56fe\u4e0b\u65e0\u53ef\u7528\u7ec4\u7ec7\uff0c\u8bf7\u5206\u914d\u7ec4\u7ec7\u6743\u9650\u3002", (String)"DecisionAnlsVisualResHomePlugin_2", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("org", (Object)orgId);
        if (EmptyUtil.isNoEmpty((Long)orgId)) {
            this.getPageCache().put("org", String.valueOf(orgId));
        } else {
            this.getPageCache().put("org", null);
        }
        this.initThemesComboItem(orgView);
        if (this.getView().getFormShowParameter().getFormId().endsWith(BLUE_SUFFIX)) {
            this.setBlueTopLabel();
        }
        this.initQingBroadSrc();
    }

    protected abstract void initThemesComboItem(Long var1);

    private void initQingBroadSrc() {
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        if (this.getView().getFormShowParameter().getFormId().endsWith(BLUE_SUFFIX)) {
            filter.and("theme", "=", (Object)"blue");
        } else {
            filter.and("theme", "=", (Object)"white");
        }
        filter.and("language", "=", (Object)"zh_CN");
        Map broads = TmcDataServiceHelper.loadFromCache((String)"tda_qingboard", (String)"control,src", (QFilter[])filter.toArray());
        for (DynamicObject broad : broads.values()) {
            IFrame iFrame = (IFrame)this.getControl(broad.getString("control"));
            if (!EmptyUtil.isNoEmpty((Object)iFrame)) continue;
            iFrame.setSrc(broad.getString("src") + "&randomStr=" + UUID.randomUUID());
        }
    }

    public static boolean isEnableDefaultOrgView() {
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.TDA.getId(), (long)RequestContext.get().getOrgId(), (String)"isenabledefaultorgview");
    }

    private long getDefaultOrgViewId(long userId, boolean isEnableDefaultOrgView) {
        long orgViewId = 0L;
        DataSet orgViewDataSet = TmcOrgDataHelper.getAuthorizedBankOrgViewDataSet((Long)userId);
        if (!isEnableDefaultOrgView) {
            orgViewDataSet = orgViewDataSet.filter("id != " + TdaCommonHelper.DEFAULT_FUN_ORG_VIEW_ID);
        }
        if (orgViewDataSet.hasNext()) {
            Row row = orgViewDataSet.next();
            orgViewId = row.getLong("id");
        }
        return orgViewId;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "refresh": {
                this.appCache();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property;
        switch (property = e.getProperty().getName()) {
            case "orgview": {
                this.serOrgInfo();
                break;
            }
            case "org": {
                if ("tda_decisanlsresvisual_bl".equals(this.getView().getFormShowParameter().getFormId())) {
                    this.setLabelTopName();
                } else if ("tda_declsviewblue_new_bl".equals(this.getView().getFormShowParameter().getFormId())) {
                    String labelClicked = this.getPageCache().get(CURRENT_LABEL_CLICKED);
                    this.setLabelTopName(labelClicked);
                }
                this.reFresh(true);
                break;
            }
            case "querydate": 
            case "currency": 
            case "amountunit": {
                this.reFresh(true);
                break;
            }
        }
    }

    private void serOrgInfo() {
        DynamicObject orgview = (DynamicObject)this.getModel().getValue("orgview");
        if (EmptyUtil.isNoEmpty((DynamicObject)orgview)) {
            Long orgViewId = orgview.getLong("id");
            Long orgId = TdaCommonHelper.getRootPermOrgIdByOrgView((Long)orgViewId);
            if (!EmptyUtil.isNoEmpty((Long)orgId)) {
                this.getPageCache().put("org", null);
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u89c6\u56fe\u4e0b\u65e0\u53ef\u7528\u7ec4\u7ec7\uff0c\u8bf7\u5206\u914d\u7ec4\u7ec7\u6743\u9650\u3002", (String)"DecisionAnlsVisualResHomePlugin_2", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put("org", String.valueOf(orgId));
            this.getModel().setValue("org", (Object)orgId);
        }
    }

    public void click(EventObject evt) {
        String proKey;
        Control source = (Control)evt.getSource();
        switch (proKey = source.getKey()) {
            case "btnrefresh": {
                this.reFresh(true);
                break;
            }
            case "btnset": {
                this.showSetPage();
                break;
            }
            case "labelorgview": 
            case "labelorg": 
            case "labelquerydate": 
            case "labelcurrency": 
            case "labelamountunit": {
                this.showQueryPage();
                break;
            }
        }
    }

    private void configContainerLabel(String proKey) {
        String tabapName = proKey.substring(0, proKey.lastIndexOf(BLUE_SUFFIX));
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab(tabapName);
        String titleName = DecisionAnlsVisualEnum.getName((String)proKey);
        this.getPageCache().put(CURRENT_LABEL_CLICKED, titleName);
        if ("tda_declsviewblue_new_bl".equals(this.getView().getFormShowParameter().getFormId())) {
            this.setLabelTopName(titleName);
        }
    }

    protected void reFresh(boolean needInitRPComItem) {
        DynamicObject orgview = (DynamicObject)this.getModel().getValue("orgview");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date queryDate = (Date)this.getModel().getValue("querydate");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        String amountUnit = (String)this.getModel().getValue("amountunit");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{orgview, org, queryDate, currency, amountUnit})) {
            return;
        }
        this.appCache();
        this.getPageCache().put("coderefresh", "true");
        if (needInitRPComItem) {
            this.initThemesComboItem(orgview.getLong("id"));
        }
        this.initQingBroadSrc();
    }

    protected void typeLinkEvent(String propertyChanged, String typeTag, String linkTag, String methodName) {
        try {
            if (propertyChanged.equals(typeTag)) {
                String type = (String)this.getModel().getValue(typeTag);
                if (EmptyUtil.isNoEmpty((String)type)) {
                    Method method = ((Object)((Object)this)).getClass().getDeclaredMethod(methodName, Boolean.TYPE);
                    method.invoke((Object)this, Boolean.FALSE);
                } else {
                    this.getModel().setValue(linkTag, (Object)"");
                    ComboEdit comboEdit = (ComboEdit)this.getView().getControl(linkTag);
                    comboEdit.setComboItems(null);
                }
            } else if (propertyChanged.equals(linkTag)) {
                String date = (String)this.getModel().getValue(linkTag);
                if (EmptyUtil.isEmpty((String)date)) {
                    Method method = ((Object)((Object)this)).getClass().getDeclaredMethod(methodName, Boolean.TYPE);
                    method.invoke((Object)this, Boolean.FALSE);
                } else {
                    this.reFresh(false);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04\u6839\u636e\u7c7b\u578b\u8bbe\u7f6e\u4e0b\u62c9\u6846\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (property) {
            case "orgview": {
                DataSet ds = TmcOrgDataHelper.getAuthorizedBankOrgViewDataSet((Long)RequestContext.get().getCurrUserId());
                if (!AbstractDecisionAnlsHomePlugin.isEnableDefaultOrgView()) {
                    ds = ds.filter("id != " + TdaCommonHelper.DEFAULT_FUN_ORG_VIEW_ID);
                }
                HashSet<Long> ids = new HashSet<Long>(16);
                while (ds.hasNext()) {
                    ids.add(ds.next().getLong("id"));
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
                break;
            }
            case "org": {
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
                if (orgView != null) {
                    showParameter.setCustomParam("orgViewSchemeNumber", (Object)orgView.getString("number"));
                    break;
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)-1));
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.appCache();
    }

    private void appCache() {
        AppCache.get((String)"tda").put(RequestContext.get().getCurrUserId() + "mainpageid", (Object)this.getView().getPageId(), 60000);
    }

    private void showSetPage() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tda_userdefaultset");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SET_CALL_BACK));
        DynamicObject currentFilter = TdaCommonHelper.getCurrentUserDefaultSet();
        if (EmptyUtil.isNoEmpty((DynamicObject)currentFilter)) {
            Object id = currentFilter.getPkValue();
            showParameter.setPkId(id);
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showQueryPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tda_userqueryset");
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("tda_declsviewblue_new_bl".equals(formId)) {
            formId = "tda_resvisual_new";
        } else if ("tda_configtheme_new_bl".equals(formId)) {
            formId = "tda_configtheme_new";
        } else if ("tda_decisanlsresvisual_bl".equals(formId)) {
            formId = "tda_decisanlsresvisual";
        } else if ("tda_configtheme_bl".equals(formId)) {
            formId = "tda_configtheme";
        }
        showParameter.setCustomParam("parentFormId", (Object)formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, QUERY_CALL_BACK));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        if (SET_CALL_BACK.equals(evt.getActionId())) {
            Object returnData2 = evt.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)returnData2)) {
                Map returnMap = (Map)returnData2;
                if (returnMap.get("orgview") != null) {
                    DynamicObject dynamicObject = (DynamicObject)returnMap.get("orgview");
                    Long orgViewId = dynamicObject.getLong("id");
                    this.getModel().setValue("orgview", (Object)orgViewId);
                    Long defaultOrgId = TdaCommonHelper.getRootPermOrgIdByOrgView((Long)orgViewId);
                    this.getModel().setValue("org", (Object)defaultOrgId);
                    this.getModel().setValue("currency", (Object)TdaCommonHelper.getDefaultCurrencyByOrg((Long)defaultOrgId));
                }
                if (returnMap.get("amountunit") != null) {
                    this.getModel().setValue("amountunit", returnMap.get("amountunit"));
                }
                if ("tda_decisanlsresvisual_bl".equals(this.getView().getFormShowParameter().getFormId()) || "tda_declsviewblue_new_bl".equals(this.getView().getFormShowParameter().getFormId()) || "tda_configtheme_new_bl".equals(this.getView().getFormShowParameter().getFormId())) {
                    this.setBlueTopLabel();
                }
                if (EmptyUtil.isNoEmpty(returnMap.get("changeTheme"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u9898\u8272\u5207\u6362\u540e\uff0c\u4e3a\u786e\u4fdd\u65b0\u7684\u4e3b\u9898\u989c\u8272\u51c6\u786e\u5448\u73b0\uff0c\u8bf7\u9000\u51fa\u5f53\u524d\u9875\u9762\u540e\u91cd\u65b0\u8fdb\u5165\u3002", (String)"DecisionAnlsVisualResHomePlugin_3", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                }
                this.appCache();
            }
        } else if (QUERY_CALL_BACK.equals(evt.getActionId()) && EmptyUtil.isNoEmpty((Object)(returnData = evt.getReturnData()))) {
            Map returnMap = (Map)returnData;
            if (returnMap.get("orgview") != null) {
                this.getModel().setValue("orgview", returnMap.get("orgview"));
            }
            if (returnMap.get("org") != null) {
                this.getModel().setValue("org", returnMap.get("org"));
            }
            this.getModel().setValue("querydate", returnMap.get("querydate"));
            this.getModel().setValue("currency", returnMap.get("currency"));
            this.getModel().setValue("amountunit", returnMap.get("amountunit"));
            this.setBlueTopLabel();
            this.appCache();
        }
    }

    protected void setLabelTopName() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String simpleName = org.getString("simplename");
        List<ValueMapItem> typeProperty = this.getEnumItemsByProperty("type");
        String typeName = "";
        if (!typeProperty.isEmpty()) {
            for (ValueMapItem valueMapItem : typeProperty) {
                if (!valueMapItem.getValue().equals(this.getModel().getValue("type"))) continue;
                typeName = String.valueOf(valueMapItem.getName());
                break;
            }
        }
        Label labelTopName = (Label)this.getView().getControl("labeltopname");
        if (StringUtils.isBlank((String)simpleName)) {
            labelTopName.setText(typeName);
        } else {
            labelTopName.setText(simpleName + " - " + typeName);
        }
    }

    protected void setLabelTopName(String typeName) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String simpleName = org.getString("simplename");
        Label labelTopName = (Label)this.getView().getControl("labeltopname");
        if (StringUtils.isBlank((String)simpleName)) {
            labelTopName.setText(typeName);
        } else {
            labelTopName.setText(simpleName + " - " + typeName);
        }
    }

    private void setBlueTopLabel() {
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Label labelOrgView = (Label)this.getView().getControl(LABEL_ORGVIEW);
        labelOrgView.setText(orgView.getString("name"));
        Label labelOrg = (Label)this.getView().getControl(LABEL_ORG);
        labelOrg.setText(org.getString("name"));
        if ("tda_declsviewblue_new_bl".equals(this.getView().getFormShowParameter().getFormId())) {
            String labelClicked = this.getPageCache().get(CURRENT_LABEL_CLICKED);
            if (labelClicked != null && !"".equals(labelClicked)) {
                this.setLabelTopName(labelClicked);
            } else {
                this.setLabelTopName(DecisionAnlsVisualEnum.LABEL_SYNTHESIS_NEW_BL.getName());
            }
        } else {
            this.setLabelTopName();
        }
        Label labelBizDate = (Label)this.getView().getControl(LABEL_QUERYDATE);
        labelBizDate.setText(DateUtils.formatString((Date)((Date)this.getModel().getValue("querydate")), (String)"yyyy-MM-dd"));
        Label labelCurrency = (Label)this.getView().getControl(LABEL_CURRENCY);
        labelCurrency.setText(currency.getString("name"));
        Label labelAmountUnit = (Label)this.getView().getControl(LABEL_AMOUNTUNIT);
        List<ValueMapItem> unitProperty = this.getEnumItemsByProperty("amountunit");
        if (!unitProperty.isEmpty()) {
            for (ValueMapItem valueMapItem : unitProperty) {
                if (!valueMapItem.getValue().equals(this.getModel().getValue("amountunit"))) continue;
                labelAmountUnit.setText(String.valueOf(valueMapItem.getName()));
                break;
            }
        } else {
            labelAmountUnit.setText(ResManager.loadKDString((String)"\u4ebf\u5143", (String)"DecisionAnlsVisualResHomePlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
        }
    }

    public List<ValueMapItem> getEnumItemsByProperty(String property) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getBlueEntityName());
        DynamicProperty propertyObj = dataEntityType.getProperty(property);
        if (propertyObj == null) {
            return Collections.emptyList();
        }
        return ((ComboProp)propertyObj).getComboItems();
    }

    protected abstract String getBlueEntityName();
}

