/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.home;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.formplugin.anls.home.AbstractDecisionAnlsHomePlugin;

public class DecisionAnlsUserQueryEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String NEXT = "next";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgview = (BasedataEdit)this.getView().getControl("orgview");
        orgview.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("orgview", this.getView().getParentView().getModel().getValue("orgview"));
        this.getModel().setValue("org", this.getView().getParentView().getModel().getValue("org"));
        this.getModel().setValue("querydate", this.getView().getParentView().getModel().getValue("querydate"));
        this.getModel().setValue("currency", this.getView().getParentView().getModel().getValue("currency"));
        this.getModel().setValue("amountunit", this.getView().getParentView().getModel().getValue("amountunit"));
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String propName = args.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)args.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"orgview", (CharSequence)propName)) {
            DynamicObjectCollection dyCollection;
            List authOrgViewList = null;
            DataSet orgViewDataSet = TmcOrgDataHelper.getAuthorizedBankOrgViewDataSet((Long)RequestContext.get().getCurrUserId());
            if (!orgViewDataSet.isEmpty() && (dyCollection = ORM.create().toPlainDynamicObjectCollection(orgViewDataSet)) != null) {
                authOrgViewList = dyCollection.stream().map(r -> r.getLong("id")).filter(r -> AbstractDecisionAnlsHomePlugin.isEnableDefaultOrgView() || !TdaCommonHelper.DEFAULT_FUN_ORG_VIEW_ID.equals(r)).collect(Collectors.toList());
            }
            QFilter qFilter = new QFilter("id", "in", authOrgViewList);
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        } else if (StringUtils.equals((CharSequence)"org", (CharSequence)propName)) {
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
            if (EmptyUtil.isEmpty((DynamicObject)orgView)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"DecisionAnlsUserQueryEditPlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                listShowParameter.setCustomParam("orgViewSchemeNumber", (Object)orgView.getString("number"));
                String appId = this.getView().getFormShowParameter().getAppId();
                String parentFormId = (String)this.getView().getFormShowParameter().getCustomParam("parentFormId");
                List authorizedOrgId = TmcOrgDataHelper.getCacheUserPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)parentFormId, (String)"47150e89000000ac");
                if (EmptyUtil.isNoEmpty((Object)authorizedOrgId)) {
                    QFilter qFilter = new QFilter("id", "in", (Object)authorizedOrgId);
                    listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("orgview".equals(property)) {
            DynamicObject orgview = (DynamicObject)this.getModel().getValue("orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgview)) {
                Long orgViewId = orgview.getLong("id");
                Long orgId = TdaCommonHelper.getRootPermOrgIdByOrgView((Long)orgViewId);
                this.getModel().setValue("org", (Object)orgId);
                if (EmptyUtil.isNoEmpty((Long)orgId)) {
                    this.getPageCache().put("org", String.valueOf(orgId));
                } else {
                    this.getPageCache().put("org", null);
                }
            }
        } else if ("org".equals(property) && EmptyUtil.isNoEmpty((Object)this.getModel().getValue("org"))) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.getModel().setValue("currency", (Object)this.getDefaultCurrencyByOrg(org.getLong("id")));
            this.getView().updateView("currency");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (NEXT.equals(operateKey) && args.getOperationResult().isSuccess()) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            returnData.put("orgview", this.getModel().getValue("orgview"));
            returnData.put("org", this.getModel().getValue("org"));
            returnData.put("querydate", this.getModel().getValue("querydate"));
            returnData.put("currency", this.getModel().getValue("currency"));
            returnData.put("amountunit", this.getModel().getValue("amountunit"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private Long getDefaultCurrencyByOrg(Long orgId) {
        DynamicObject standardCurrency;
        DynamicObject baseCurrency;
        long currency = 0L;
        if (orgId != null && (baseCurrency = (standardCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)orgId)) == null ? TmcBusinessBaseHelper.getBaseCurrency((long)orgId) : standardCurrency) != null) {
            currency = baseCurrency.getLong("id");
        }
        return currency;
    }
}

