/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.home;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.AmountUnitEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.HomeOverviewHelper;
import kd.tmc.tda.common.helper.TdaLicenseCheckHelper;

public class HomeOverviewPlugin
extends AbstractFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        TdaLicenseCheckHelper.checkTdaLicense((PreOpenFormEventArgs)e);
    }

    public void afterCreateNewData(EventObject e) {
        IFrame iFrame;
        Map paramMap = HomeOverviewHelper.getParamMap();
        String queryParams = this.buildQueryParams(paramMap);
        this.getView().getModel().setValue("label", (Object)ResManager.loadKDString((String)"\u8d44\u91d1\u6982\u89c8", (String)"HomeOverviewPlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]));
        this.getView().getModel().setValue("value", (Object)queryParams);
        if ("tda_newhome".equals(this.getView().getFormShowParameter().getFormId()) && EmptyUtil.isNoEmpty((Object)(iFrame = (IFrame)this.getControl("iframeap")))) {
            iFrame.setSrc(".?formId=tda_rp_design_show&configtag=tda_anls_home&randomStr=" + UUID.randomUUID());
        }
    }

    private void initQingBroadSrc() {
        Lang lang = RequestContext.get().getLang();
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filter.and("theme", "=", (Object)"white").and("control", "=", (Object)"iframehomepage");
        switch (lang.name()) {
            case "zh_TW": {
                filter.and("language", "=", (Object)"zh_TW");
                break;
            }
            case "en_US": {
                filter.and("language", "=", (Object)"en_US");
                break;
            }
            default: {
                filter.and("language", "=", (Object)"zh_CN");
            }
        }
        Map broads = TmcDataServiceHelper.loadFromCache((String)"tda_qingboard", (String)"control,src", (QFilter[])filter.toArray());
        for (DynamicObject broad : broads.values()) {
            IFrame iFrame = (IFrame)this.getControl(broad.getString("control"));
            if (!EmptyUtil.isNoEmpty((Object)iFrame)) continue;
            iFrame.setSrc(broad.getString("src") + "&randomStr=" + UUID.randomUUID());
        }
    }

    private String buildQueryParams(Map<String, Object> paramMap) {
        String org = ((DynamicObject)paramMap.get("org")).getString("name");
        Date queryDate = this.getQueryDate(paramMap);
        String currency = ((DynamicObject)paramMap.get("currency")).getString("name");
        String amountUnit = (String)paramMap.get("amountunit");
        amountUnit = AmountUnitEnum.getName((String)amountUnit);
        StringBuilder sb = new StringBuilder("\uff08").append(org).append(" | ").append(DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd")).append(" | ").append(currency).append(" | ").append(amountUnit).append("\uff09");
        return sb.toString();
    }

    private Date getQueryDate(Map<String, Object> paramMap) {
        Object date = paramMap.get("querydate");
        Date queryDate = date == null ? DateUtils.getCurrentDate() : (date instanceof String ? DateUtils.stringToDate((String)((String)date), (String)"yyyy-MM-dd HH:mm:ss") : (Date)date);
        return DateUtils.truncateDate((Date)queryDate);
    }
}

