/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.liquidity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.snap.IDataSnapExecute;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.LiquidityDataCheckHelper;

public class LiquidityIndicatorDetailPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(LiquidityIndicatorDetailPlugin.class);
    private static final String OP_IND_DETAIL = "inddetail";
    private static final String COLOR_THEMECOLOR = "rgba(255, 0, 0, 1)";
    private static final String ROW_BACK_COLOR = "rgba(210, 234, 241, .2)";
    private static final String ROW_BACK_COLOR_BL = "rgba(0, 59, 97, .9)";
    private Map<String, BigDecimal> rateCache = new HashMap<String, BigDecimal>(16);
    private static final String LIQUIDITY_INDICATOR_CLASS = "kd.tmc.tda.report.liquidity.qing.LiquidityIndicatorDetailQingDataListPlugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OP_IND_DETAIL, "btnrefresh"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property;
        switch (property = e.getProperty().getName()) {
            case "org": 
            case "querydate": 
            case "currency": 
            case "amountunit": {
                this.loadDataAndFillEntry();
                break;
            }
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.loadDataAndFillEntry();
    }

    public void click(EventObject evt) {
        String proKey;
        Control source = (Control)evt.getSource();
        switch (proKey = source.getKey()) {
            case "inddetail": {
                this.LiquidityIndicatorDetailView();
                break;
            }
            case "btnrefresh": {
                this.loadDataAndFillEntry();
                break;
            }
        }
    }

    private void LiquidityIndicatorDetailView() {
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("tda_liquidity_inddet");
        HashMap paramMap = new HashMap(4);
        parameter.setCustomParams(paramMap);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void loadDataAndFillEntry() {
        String amountUnit;
        DynamicObject currency;
        DynamicObject org;
        Date queryDate = (Date)this.getModel().getValue("querydate");
        DynamicObject orgview = (DynamicObject)this.getModel().getValue("orgview");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{orgview, org = (DynamicObject)this.getModel().getValue("org"), queryDate, currency = (DynamicObject)this.getModel().getValue("currency"), amountUnit = (String)this.getModel().getValue("amountunit")})) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("liquityentity");
        String formId = this.getView().getFormShowParameter().getFormId();
        if (null != entryGrid && !formId.endsWith("_new")) {
            QFilter orgViewFilter = new QFilter("orgview", "=", (Object)orgview);
            QFilter orgFilter = new QFilter("org", "=", (Object)org);
            QFilter currency_Filter = new QFilter("currency", "=", (Object)currency);
            QFilter queryDate_Filter = new QFilter("querydate", "=", (Object)queryDate);
            QFilter amountUnit_Filter = new QFilter("amountunit", "=", this.getModel().getValue("amountunit"));
            QFilter[] qFilters = new QFilter[]{orgViewFilter, orgFilter, queryDate_Filter, currency_Filter, amountUnit_Filter};
            ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>(10);
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
            ArrayList<Integer> changeBackColorIndexs = new ArrayList<Integer>(10);
            try {
                IDataSnapExecute service = (IDataSnapExecute)Class.forName(LIQUIDITY_INDICATOR_CLASS).newInstance();
                DataSet ds = service.data("tda_liquidity_inddet_qing", "", qFilters);
                Iterator iterator = ds.iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    if (LiquidityDataCheckHelper.isEmptyRow((Row)row)) continue;
                    changeBackColorIndexs.add(index);
                    cellStyles.add(this.createCellStyle(row, index));
                    entryList.add(this.createLiquidityEntry(row));
                    ++index;
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u6d41\u52a8\u6027\u6307\u6807\u660e\u7ec6\u6570\u636e\u9519\u8bef\uff0c", (Throwable)e);
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            boolean dataChanged = this.getModel().getDataChanged();
            model.beginInit();
            TmcViewInputHelper.batchFillEntity((String)"liquityentity", (AbstractFormDataModel)model, entryList);
            model.endInit();
            this.getView().updateView("liquityentity");
            this.getModel().setDataChanged(dataChanged);
            entryGrid.setCellStyle(cellStyles);
            if (formId.endsWith("_bl")) {
                entryGrid.setRowBackcolor(ROW_BACK_COLOR_BL, changeBackColorIndexs.stream().mapToInt(Integer::intValue).toArray());
            } else {
                entryGrid.setRowBackcolor(ROW_BACK_COLOR, changeBackColorIndexs.stream().mapToInt(Integer::intValue).toArray());
            }
        }
        Label realdatetext = (Label)this.getView().getControl("realdatetext");
        HashMap<String, Date> paramMap = new HashMap<String, Date>(8);
        paramMap.put("querydate", queryDate);
        paramMap.put("orgview", (Date)orgview);
        paramMap.put("org", (Date)org);
        Date realQueryDate = LiquidityDataCheckHelper.getRealQueryDate(paramMap);
        realdatetext.setText(String.format(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\uff1a%s", (String)"LiquidityIndicatorDetailPlugin_0", (String)"tmc-tda-formplugin", (Object[])new Object[0]), DateUtils.formatString((Date)DateUtils.getLastDateOfAnyMonth((Date)realQueryDate, (int)-1), (String)"yyyy-MM")));
    }

    private CellStyle createCellStyle(Row row, int index) {
        BigDecimal fundDueThreeMthRatioMonth;
        BigDecimal flowRatioMonth;
        BigDecimal quickRatioMonth;
        CellStyle cellStyle = new CellStyle();
        BigDecimal intCoverRatioMonth = row.getBigDecimal("intcoverratiomonth");
        if (intCoverRatioMonth.compareTo(BigDecimal.ZERO) > 0) {
            cellStyle.setFieldKey("intcoverratio");
            cellStyle.setRow(index);
            cellStyle.setForeColor(COLOR_THEMECOLOR);
        }
        if ((quickRatioMonth = row.getBigDecimal("quickratiomonth")).compareTo(BigDecimal.ZERO) > 0) {
            cellStyle.setFieldKey("quickratio");
            cellStyle.setRow(index);
            cellStyle.setForeColor(COLOR_THEMECOLOR);
        }
        if ((flowRatioMonth = row.getBigDecimal("flowratiomonth")).compareTo(BigDecimal.ZERO) > 0) {
            cellStyle.setFieldKey("flowratio");
            cellStyle.setRow(index);
            cellStyle.setForeColor(COLOR_THEMECOLOR);
        }
        if ((fundDueThreeMthRatioMonth = row.getBigDecimal("fundduethreemthratiomonth")).compareTo(BigDecimal.ZERO) > 0) {
            cellStyle.setFieldKey("fundduethreemthratio");
            cellStyle.setRow(index);
            cellStyle.setForeColor(COLOR_THEMECOLOR);
        }
        return cellStyle;
    }

    private Map<String, Object> createLiquidityEntry(Row row) {
        HashMap<String, Object> liquidityMap = new HashMap<String, Object>(16);
        liquidityMap.put("orgname", row.getString("orgname"));
        liquidityMap.put("assetsdebtrate", row.getBigDecimal("assetsdebtrate").setScale(2, RoundingMode.HALF_UP) + "%");
        liquidityMap.put("intdebtrate", row.getBigDecimal("intdebtrate").setScale(2, RoundingMode.HALF_UP) + "%");
        liquidityMap.put("quickratio", row.getBigDecimal("quickratio").setScale(2, RoundingMode.HALF_UP));
        liquidityMap.put("flowratio", row.getBigDecimal("flowratio").setScale(2, RoundingMode.HALF_UP));
        liquidityMap.put("intcoverratio", row.getBigDecimal("intcoverratio").setScale(2, RoundingMode.HALF_UP));
        liquidityMap.put("duethreemonthamt", this.tranRate(row.getBigDecimal("duethreemonthamt")).setScale(2, RoundingMode.HALF_UP));
        liquidityMap.put("fundduethreemthratio", row.getBigDecimal("fundduethreemthratio").setScale(2, RoundingMode.HALF_UP));
        liquidityMap.put("duethreemonthratio", row.getBigDecimal("duethreemonthratio").setScale(2, RoundingMode.HALF_UP) + "%");
        return liquidityMap;
    }

    private BigDecimal tranRate(BigDecimal amt) {
        Long orgViewId = ((DynamicObject)this.getModel().getValue("orgview")).getLong("id");
        Long fromCurrencyId = AmountTransHelper.getBaseCurrency((Long)orgViewId);
        BigDecimal rate = this.getRate(fromCurrencyId, orgViewId);
        BigDecimal tranRateAmt = amt.multiply(rate);
        BigDecimal amountUnit = new BigDecimal((String)this.getModel().getValue("amountunit"));
        BigDecimal tranUnitAmt = tranRateAmt.divide(amountUnit);
        return tranUnitAmt;
    }

    private BigDecimal getRate(Long fromCurrencyId, Long orgViewId) {
        Date queryDate = (Date)this.getModel().getValue("querydate");
        String key = fromCurrencyId + orgViewId + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
        if (this.rateCache.containsKey(key)) {
            return this.rateCache.get(key);
        }
        String orgRootId = TmcOrgDataHelper.getOrgRootId((Long)orgViewId);
        BigDecimal rate = BigDecimal.ONE;
        if (EmptyUtil.isNoEmpty((String)orgRootId)) {
            long rootOrgId = Long.parseLong(orgRootId);
            Long tarCurrencyId = ((DynamicObject)this.getModel().getValue("currency")).getLong("id");
            if (fromCurrencyId.equals(tarCurrencyId)) {
                rate = BigDecimal.ONE;
            } else {
                rate = TmcBusinessBaseHelper.getExchangeRate((long)fromCurrencyId, (long)tarCurrencyId, (long)rootOrgId, (Date)queryDate);
                if (rate == null) {
                    rate = BigDecimal.ONE;
                }
            }
        }
        this.rateCache.put(key, rate);
        return rate;
    }
}

