/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.synthesis;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.sdk.tmc.tda.extpoint.synthesis.ISynthesisLoadDataInterface;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.SynthesisProjectEnum;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.SynthsisSumDataHelper;

public class SynthesisSumDataFormHelper {
    private static final Log logger = LogFactory.getLog(SynthesisSumDataFormHelper.class);
    private static final int[] defaultColIndexs = new int[]{1, 3, 5, 7, 9};
    private static final int[] otherColIndexs = new int[]{0, 2, 4, 6, 8};
    private static final String ROW_BACK_COLOR = "rgba(210, 234, 241, .2)";
    private static final String OTHER_BACK_COLOR = "rgba(255, 255, 255, .2)";
    private static final String ROW_BACK_COLOR_BL = "rgba(0, 59, 97, .9)";
    private static final String OTHER_BACK_COLOR_BL = "rgba(13, 38, 73, 0.9)";
    public static final String FORMAT_YM = "yyyy-MM";
    private DynamicObject orgView;
    private DynamicObject org;
    private DynamicObject currency;
    private Date queryDate;
    private BigDecimal amountUnit;
    private Date bizDate;
    private Map<String, BigDecimal> rateCache = new HashMap<String, BigDecimal>(16);

    public void reloadSynthesis(IDataModel dataModel, IFormView formView) {
        this.orgView = (DynamicObject)dataModel.getValue("orgview");
        this.org = (DynamicObject)dataModel.getValue("org");
        this.queryDate = (Date)dataModel.getValue("querydate");
        this.currency = (DynamicObject)dataModel.getValue("currency");
        this.amountUnit = new BigDecimal((String)dataModel.getValue("amountunit"));
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.orgView, this.org, this.queryDate, this.currency, this.amountUnit})) {
            return;
        }
        this.queryDate = DecisionCommonHelper.fixQueryDate((Date)this.queryDate);
        if (EmptyUtil.isEmpty((Object)this.bizDate)) {
            this.bizDate = this.queryDate;
        }
        this.fillEntryEntity(dataModel, formView);
        this.changeFormTitle(formView, this.bizDate);
        this.fillBackGroundColor(formView);
    }

    private void changeFormTitle(IFormView formView, Date bizDate) {
        Date currentMonth = DateUtils.getLastDateOfAnyMonth((Date)bizDate, (int)-1);
        String currentMonthStr = new SimpleDateFormat(FORMAT_YM).format(currentMonth);
        Date lastMonth = DateUtils.getLastDateOfAnyMonth((Date)bizDate, (int)-2);
        String lastMonthStr = new SimpleDateFormat(FORMAT_YM).format(lastMonth);
        EntryGrid entryGrid = (EntryGrid)formView.getControl("synthesisentry");
        List controls = entryGrid.getControls();
        if (EmptyUtil.isEmpty((Collection)controls)) {
            return;
        }
        for (Control control : controls) {
            if (!(control instanceof TextEdit)) continue;
            TextEdit textEdit = (TextEdit)control;
            switch (textEdit.getFieldKey()) {
                case "currmonthtotal": 
                case "currmonthdomestic": 
                case "currmonthforeign": {
                    textEdit.setCaption(new LocaleString(currentMonthStr));
                    break;
                }
                case "lastmonthtotal": 
                case "lastmonthdomestic": 
                case "lastmonthforeign": {
                    textEdit.setCaption(new LocaleString(lastMonthStr));
                    break;
                }
            }
        }
    }

    private void fillBackGroundColor(IFormView formView) {
        String formId = formView.getFormShowParameter().getFormId();
        EntryGrid entryGrid = (EntryGrid)formView.getControl("synthesisentry");
        if (formId.endsWith("_bl")) {
            entryGrid.setRowBackcolor(ROW_BACK_COLOR_BL, defaultColIndexs);
            entryGrid.setRowBackcolor(OTHER_BACK_COLOR_BL, otherColIndexs);
        } else {
            entryGrid.setRowBackcolor(ROW_BACK_COLOR, defaultColIndexs);
            entryGrid.setRowBackcolor(OTHER_BACK_COLOR, otherColIndexs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillEntryEntity(IDataModel dataModel, IFormView formView) {
        List<Map<String, Object>> list = Collections.EMPTY_LIST;
        if (EmptyUtil.isEmpty((DynamicObject)this.orgView) || EmptyUtil.isEmpty((DynamicObject)this.org)) {
            logger.info("\u3010\u7efc\u5408\u5206\u6790\u3011\u586b\u5145\u5206\u5f55\u6570\u636e\u65f6\uff0c\u7ec4\u7ec7\u89c6\u56fe\u6216\u7ec4\u7ec7\u4e3a\u7a7a\u3002");
            this.bizDate = this.queryDate;
            return;
        }
        String lockKey = this.getLockKey();
        DLock dLock = DLock.create((String)lockKey);
        if (dLock.tryLock(60000L)) {
            logger.info("\u3010\u7efc\u5408\u5206\u6790\u3011\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f lock key :" + lockKey);
            try {
                Object[] existSumData = this.getExistSumData();
                Date curyyMM = DateUtils.getFirstDateOfAnyMonth((Date)this.queryDate, (int)0);
                if (EmptyUtil.isNoEmpty((Object[])existSumData)) {
                    Date bizDate = existSumData[0].getDate("bizdate");
                    if (curyyMM.equals(bizDate)) {
                        list = this.loadRptSumDataFromDB((DynamicObject[])existSumData);
                    }
                    list = this.loadRptSumDataFromPlugin(curyyMM);
                }
                list = this.loadRptSumDataFromPlugin(curyyMM);
            }
            catch (Exception e) {
                logger.error("\u3010\u7efc\u5408\u5206\u6790\u3011\u53d6\u6570\u65f6\u9519\u8bef lock key: " + lockKey + " \u9519\u8bef\u4fe1\u606f\uff1a" + e);
            }
            finally {
                dLock.unlock();
            }
        } else {
            logger.info("\u3010\u7efc\u5408\u5206\u6790\u3011\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25 lock key :" + lockKey);
            list = Collections.EMPTY_LIST;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        boolean dataChanged = dataModel.getDataChanged();
        model.beginInit();
        TmcViewInputHelper.batchFillEntity((String)"synthesisentry", (AbstractFormDataModel)model, (List)list);
        model.endInit();
        formView.updateView("synthesisentry");
        dataModel.setDataChanged(dataChanged);
    }

    private String getLockKey() {
        return this.orgView.getLong("id") + "-" + this.org.getLong("id") + "-" + DateUtils.formatString((Date)DateUtils.getFirstDayOfMonth((Date)this.queryDate), (String)"yyyy-MM-dd");
    }

    private DynamicObject[] getExistSumData() {
        QFilter orgViewFilter = new QFilter("orgview.id", "=", this.orgView.getPkValue());
        QFilter orgFilter = new QFilter("org.id", "=", this.org.getPkValue());
        Long baseCurrencyId = AmountTransHelper.getBaseCurrency((Long)this.orgView.getLong("id"));
        QFilter currencyFilter = new QFilter("currency.id", "=", (Object)baseCurrencyId);
        List<Date> firstDayOfMonthList = this.getfirstDayOfMonthsByQueryDate(this.queryDate);
        QFilter dateFilter = new QFilter("bizdate", "in", firstDayOfMonthList);
        DynamicObject[] existSumData = TmcDataServiceHelper.load((String)"tda_synthesissumdata", (String)"bizdate,currency,project,currmonthtotal,lastmonthtotal,currmonthdomestic,lastmonthdomestic,currmonthforeign,lastmonthforeign,budget,relbudget,changeamt,changerate,sort", (QFilter[])new QFilter[]{orgViewFilter, orgFilter, currencyFilter, dateFilter}, (String)"sort,bizdate desc");
        return existSumData;
    }

    private List<Date> getfirstDayOfMonthsByQueryDate(Date queryDate) {
        ArrayList<Date> firstDayOfMonthList = new ArrayList<Date>(4);
        for (int i = 0; i <= 3; ++i) {
            firstDayOfMonthList.add(DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)(-i)));
        }
        return firstDayOfMonthList;
    }

    private List<Map<String, Object>> loadRptSumDataFromPlugin(Date curyyMM) {
        if (curyyMM.before(new Date())) {
            SynthsisSumDataHelper sumDataHelper = new SynthsisSumDataHelper(this.orgView, this.org, this.currency, this.queryDate);
            sumDataHelper.refreshSumData();
        }
        DynamicObject[] existSumData = this.getExistSumData();
        return this.loadRptSumDataFromDB(existSumData);
    }

    private List<Map<String, Object>> loadRptSumDataFromDB(DynamicObject[] existSumData) {
        for (DynamicObject sumData : existSumData) {
            String project = sumData.getString("project");
            SynthesisProjectEnum projectEnum = SynthesisProjectEnum.getEnumByValue((String)project);
            if (SynthesisProjectEnum.ADR != projectEnum) continue;
            BigDecimal adrBigDecimal = sumData.getBigDecimal("currmonthtotal").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP);
            if (adrBigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                this.bizDate = sumData.getDate("bizdate");
                break;
            }
            this.bizDate = null;
        }
        ArrayList<Map<String, Object>> synthesisEntryList = new ArrayList<Map<String, Object>>(10);
        block8: for (DynamicObject sumData : existSumData) {
            if (this.bizDate == null) {
                this.bizDate = sumData.getDate("bizdate");
            }
            if (this.bizDate.compareTo(sumData.getDate("bizdate")) != 0) continue;
            String project = sumData.getString("project");
            Long sumCurrencyId = sumData.getDynamicObject("currency").getLong("id");
            SynthesisProjectEnum projectEnum = SynthesisProjectEnum.getEnumByValue((String)project);
            switch (projectEnum) {
                case FD: {
                    synthesisEntryList.add(this.createFundEntry(sumData, sumCurrencyId, false));
                    continue block8;
                }
                case PR: 
                case FC: {
                    synthesisEntryList.add(this.createProfitRateEntry(sumData));
                    continue block8;
                }
                case IDA: {
                    synthesisEntryList.add(this.createFundEntry(sumData, sumCurrencyId, true));
                    continue block8;
                }
                case NA: 
                case EA: {
                    synthesisEntryList.add(this.createNetAssetsEntry(sumData, sumCurrencyId));
                    continue block8;
                }
                case ADR: 
                case IDR: 
                case IDER: {
                    synthesisEntryList.add(this.createAssetsDebtRateEntry(sumData));
                    continue block8;
                }
            }
        }
        return synthesisEntryList;
    }

    private Map<String, Object> createFundEntry(DynamicObject sumData, Long sumCurrencyId, boolean containsBudget) {
        HashMap<String, Object> fundEntry = new HashMap<String, Object>(16);
        String project = this.getExtendProjectName(sumData.getString("project"));
        fundEntry.put("project", project);
        if (containsBudget) {
            fundEntry.put("budget", this.tranRate(sumData.getBigDecimal("budget"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
            fundEntry.put("relbudget", this.tranRate(sumData.getBigDecimal("relbudget"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        } else {
            fundEntry.put("budget", "--");
            fundEntry.put("relbudget", "--");
        }
        fundEntry.put("changerate", sumData.getBigDecimal("changerate").setScale(2, RoundingMode.HALF_UP) + "%");
        fundEntry.put("currmonthtotal", this.tranRate(sumData.getBigDecimal("currmonthtotal"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("lastmonthtotal", this.tranRate(sumData.getBigDecimal("lastmonthtotal"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("currmonthdomestic", this.tranRate(sumData.getBigDecimal("currmonthdomestic"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("lastmonthdomestic", this.tranRate(sumData.getBigDecimal("lastmonthdomestic"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("currmonthforeign", this.tranRate(sumData.getBigDecimal("currmonthforeign"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("lastmonthforeign", this.tranRate(sumData.getBigDecimal("lastmonthforeign"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("changeamt", this.tranRate(sumData.getBigDecimal("changeamt"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        return fundEntry;
    }

    private Map<String, Object> createProfitRateEntry(DynamicObject sumData) {
        HashMap<String, Object> profitRateEntry = new HashMap<String, Object>(16);
        String project = this.getExtendProjectName(sumData.getString("project"));
        profitRateEntry.put("project", project);
        profitRateEntry.put("budget", "--");
        profitRateEntry.put("relbudget", "--");
        profitRateEntry.put("changerate", sumData.getBigDecimal("changerate").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("currmonthtotal", sumData.getBigDecimal("currmonthtotal").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("lastmonthtotal", sumData.getBigDecimal("lastmonthtotal").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("currmonthdomestic", sumData.getBigDecimal("currmonthdomestic").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("lastmonthdomestic", sumData.getBigDecimal("lastmonthdomestic").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("currmonthforeign", sumData.getBigDecimal("currmonthforeign").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("lastmonthforeign", sumData.getBigDecimal("lastmonthforeign").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("changeamt", sumData.getBigDecimal("changeamt").setScale(2, RoundingMode.HALF_UP) + "%");
        return profitRateEntry;
    }

    private Map<String, Object> createNetAssetsEntry(DynamicObject sumData, Long sumCurrencyId) {
        HashMap<String, Object> entry = new HashMap<String, Object>(16);
        String project = this.getExtendProjectName(sumData.getString("project"));
        entry.put("project", project);
        entry.put("currmonthdomestic", "--");
        entry.put("lastmonthdomestic", "--");
        entry.put("currmonthforeign", "--");
        entry.put("lastmonthforeign", "--");
        entry.put("budget", this.tranRate(sumData.getBigDecimal("budget"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        entry.put("relbudget", this.tranRate(sumData.getBigDecimal("relbudget"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        entry.put("changerate", sumData.getBigDecimal("changerate").setScale(2, RoundingMode.HALF_UP) + "%");
        entry.put("currmonthtotal", this.tranRate(sumData.getBigDecimal("currmonthtotal"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        entry.put("lastmonthtotal", this.tranRate(sumData.getBigDecimal("lastmonthtotal"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        entry.put("changeamt", this.tranRate(sumData.getBigDecimal("changeamt"), sumCurrencyId).setScale(2, RoundingMode.HALF_UP));
        return entry;
    }

    private Map<String, Object> createAssetsDebtRateEntry(DynamicObject sumData) {
        HashMap<String, Object> profitRateEntry = new HashMap<String, Object>(16);
        String project = this.getExtendProjectName(sumData.getString("project"));
        profitRateEntry.put("project", project);
        profitRateEntry.put("currmonthdomestic", "--");
        profitRateEntry.put("lastmonthdomestic", "--");
        profitRateEntry.put("currmonthforeign", "--");
        profitRateEntry.put("lastmonthforeign", "--");
        profitRateEntry.put("changerate", sumData.getBigDecimal("changerate").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("currmonthtotal", sumData.getBigDecimal("currmonthtotal").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("lastmonthtotal", sumData.getBigDecimal("lastmonthtotal").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("budget", sumData.getBigDecimal("budget").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("relbudget", sumData.getBigDecimal("relbudget").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("changeamt", sumData.getBigDecimal("changeamt").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        return profitRateEntry;
    }

    private String getExtendProjectName(String projectValue) {
        PluginProxy pluginProxy = PluginProxy.create(ISynthesisLoadDataInterface.class, (String)"kd.sdk.tmc.tda.extpoint.synthesis.ISynthesisLoadDataInterface");
        List lists = pluginProxy.callReplace(p -> p.getExtendProjectName(projectValue));
        if (EmptyUtil.isNoEmpty((Object)lists) && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (String)lists.get(0);
        }
        return SynthesisProjectEnum.getName((String)projectValue);
    }

    private BigDecimal tranRate(BigDecimal amt, Long fromCurrencyId) {
        BigDecimal rate = this.getRate(fromCurrencyId);
        BigDecimal tranRateAmt = amt.multiply(rate);
        BigDecimal tranUnitAmt = tranRateAmt.divide(this.amountUnit);
        return tranUnitAmt;
    }

    private BigDecimal getRate(Long fromCurrencyId) {
        Long orgViewId = this.orgView.getLong("id");
        String key = fromCurrencyId + orgViewId + DateUtils.formatString((Date)this.queryDate, (String)"yyyy-MM-dd");
        if (this.rateCache.containsKey(key)) {
            return this.rateCache.get(key);
        }
        String orgRootId = TmcOrgDataHelper.getOrgRootId((Long)orgViewId);
        BigDecimal rate = BigDecimal.ONE;
        if (EmptyUtil.isNoEmpty((String)orgRootId)) {
            long rootOrgId = Long.parseLong(orgRootId);
            Long tarCurrencyId = this.currency.getLong("id");
            if (fromCurrencyId.equals(tarCurrencyId)) {
                rate = BigDecimal.ONE;
            } else {
                rate = TmcBusinessBaseHelper.getExchangeRate((long)fromCurrencyId, (long)tarCurrencyId, (long)rootOrgId, (Date)this.queryDate);
                if (rate == null) {
                    rate = BigDecimal.ONE;
                }
            }
        }
        this.rateCache.put(key, rate);
        return rate;
    }
}

