/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.formplugin.anls.tool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.IntPrincipleRuleEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.model.interest.RepayPlanRequest;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;
import kd.tmc.fbp.service.inst.plan.IntPlanCallStragety;
import kd.tmc.fbp.service.inst.plan.RepayPlanCallStragety;

public class IntCallToolPlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("rate".equals(key)) {
            this.initRate();
        }
        if ("repay".equals(key)) {
            this.callRepayPlan();
        }
        if ("int".equals(key)) {
            this.callInt();
        }
    }

    private void initRate() {
        Date beginDate = (Date)this.getModel().getValue("intdate");
        Date endDate = (Date)this.getModel().getValue("expiredate");
        DynamicObject referRate = (DynamicObject)this.getModel().getValue("refer");
        Map rateDatas = MarketDataServiceHelper.referRate((String)referRate.getString("number"), (Date)beginDate, (Date)endDate);
        this.getModel().deleteEntryData("ratelist");
        rateDatas.forEach((bizdate, rate) -> {
            int index = this.getModel().createNewEntryRow("ratelist");
            this.getModel().setValue("effectdate", bizdate, index);
            this.getModel().setValue("referrate", rate, index);
        });
    }

    private void callRepayPlan() {
        RepayPlanRequest repayPlanRequest = this.genRepayPlanRequest();
        List repayPlanList = new RepayPlanCallStragety().callPlan(repayPlanRequest);
        this.fillRepayPlanList(repayPlanList);
        Date beginDate = (Date)this.getModel().getValue("intdate");
        Date endDate = (Date)this.getModel().getValue("expiredate");
        this.getModel().deleteEntryData("entrys");
        for (BasisEnum basis : BasisEnum.values()) {
            int index = this.getModel().createNewEntryRow("entrys");
            this.getModel().setValue("basis_t", (Object)basis.getName(), index);
            this.getModel().setValue("bdate", (Object)beginDate, index);
            this.getModel().setValue("edate", (Object)endDate, index);
            this.getModel().setValue("basis_tv", (Object)TermHelper.getBaseBasis((Date)beginDate, (Date)endDate, (BasisEnum)basis, null), index);
        }
    }

    private RepayPlanRequest genRepayPlanRequest() {
        RepayPlanRequest request = new RepayPlanRequest();
        request.setLoanAmount((BigDecimal)this.getModel().getValue("amount"));
        request.setLoanDate((Date)this.getModel().getValue("loandate"));
        request.setExpiredate((Date)this.getModel().getValue("expiredate"));
        request.setRepayScheme((DynamicObject)this.getModel().getValue("repayscheme"));
        request.setRepayWay(RepaymentWayEnum.valueOf((String)((String)this.getModel().getValue("repayway"))));
        request.setRound(RoundRuleEnum.valueOf((String)((String)this.getModel().getValue("round"))));
        request.setCurrency((DynamicObject)this.getModel().getValue("currency"));
        return request;
    }

    private void fillRepayPlanList(List<PlanCallResult> repayPlanList) {
        this.getModel().deleteEntryData("repaybill");
        for (PlanCallResult repayPlan : repayPlanList) {
            int index = this.getModel().createNewEntryRow("repaybill");
            this.getModel().setValue("repaydate", (Object)repayPlan.getBizDate(), index);
            this.getModel().setValue("repayamt", (Object)repayPlan.getPrinciple(), index);
        }
    }

    private List<PlanCallResult> callIntPlan() {
        Set<RateInfo> rateList = this.getRateList();
        Date beginDate = (Date)this.getModel().getValue("intdate");
        Date endDate = (Date)this.getModel().getValue("expiredate");
        BigDecimal balance = (BigDecimal)this.getModel().getValue("amount");
        List<PlanCallResult> repayPlanList = this.getAllRepayPlanList();
        IntCalRequest request = new IntCalRequest();
        request.setRepayList(repayPlanList);
        request.setBizBill(this.getBizBill(balance, beginDate, beginDate, endDate, 0));
        request.setRateList(rateList);
        return new IntPlanCallStragety().callPlan(request);
    }

    private void callInt() {
        Set<RateInfo> rateList = this.getRateList();
        Date intDate = (Date)this.getModel().getValue("intdate");
        Date beginDate = (Date)this.getModel().getValue("intdate");
        BigDecimal balance = (BigDecimal)this.getModel().getValue("amount");
        List<PlanCallResult> repayPlanList = this.getAllRepayPlanList();
        List<PlanCallResult> intPlanList = this.callIntPlan();
        ArrayList<IntBillInfo> list = new ArrayList<IntBillInfo>(10);
        RepaymentWayEnum repayWay = RepaymentWayEnum.valueOf((String)((String)this.getModel().getValue("repayway")));
        for (int period = 1; period <= intPlanList.size(); ++period) {
            PlanCallResult plan = intPlanList.get(period - 1);
            Date endDate = plan.getBizDate();
            IntCalRequest request = new IntCalRequest();
            request.setRepayList(repayPlanList);
            BizBillInfo bizBill = this.getBizBill(balance, intDate, beginDate, endDate, period);
            request.setBizBill(bizBill);
            request.setRateList(rateList);
            IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
            IntBillInfo intBill = stragety.callInt(request);
            if (EmptyUtil.isNoEmpty((Object)intBill) && EmptyUtil.isNoEmpty((Object)intBill.getDetails())) {
                BigDecimal principle = ((IntBillDetailInfo)intBill.getDetails().get(0)).getPrinciple();
                plan.setPrinciple(principle);
                if (RepaymentWayEnum.debx == repayWay) {
                    repayPlanList.get(period - 1).setPrinciple(principle);
                    this.getModel().setValue("repayamt", (Object)principle, period - 1);
                }
            }
            if (intBill != null) {
                list.add(intBill);
            }
            beginDate = endDate;
        }
        this.fillIntPlanList(list, repayWay);
    }

    private Set<RateInfo> getRateList() {
        HashSet<RateInfo> rateList = new HashSet<RateInfo>();
        DynamicObjectCollection rates = this.getModel().getEntryEntity("ratelist");
        for (DynamicObject rate : rates) {
            RateInfo info = new RateInfo();
            info.setEffectiveDate(rate.getDate("effectdate"));
            info.setRate(rate.getBigDecimal("referrate"));
            rateList.add(info);
        }
        return rateList;
    }

    private List<PlanCallResult> getAllRepayPlanList() {
        ArrayList<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>();
        DynamicObjectCollection colls = this.getModel().getEntryEntity("repaybill");
        for (DynamicObject repayPlan : colls) {
            PlanCallResult info = new PlanCallResult();
            info.setBizDate(repayPlan.getDate("repaydate"));
            info.setPrinciple(repayPlan.getBigDecimal("repayamt"));
            info.setPayInt(repayPlan.getBoolean("payint"));
            repayPlanList.add(info);
        }
        return repayPlanList;
    }

    private BizBillInfo getBizBill(BigDecimal balance, Date intDate, Date lastIntDate, Date endDate, int period) {
        BizBillInfo bizBill = new BizBillInfo();
        bizBill.setLoanAmount(balance);
        bizBill.setBeginDate(lastIntDate);
        bizBill.setEndDate(endDate);
        bizBill.setRepayWay(RepaymentWayEnum.valueOf((String)((String)this.getModel().getValue("repayway"))));
        bizBill.setBasis(BasisEnum.valueOf((String)((String)this.getModel().getValue("basis"))));
        bizBill.setPrincipleRule(IntPrincipleRuleEnum.valueOf((String)((String)this.getModel().getValue("principlerule"))));
        bizBill.setHtRule(IntHTRuleEnum.valueOf((String)((String)this.getModel().getValue("htrule"))));
        bizBill.setIntSchemeId(((DynamicObject)this.getModel().getValue("intscheme")).getLong("id"));
        bizBill.setRepaySchemeId(((DynamicObject)this.getModel().getValue("repayscheme")).getLong("id"));
        bizBill.setRound(RoundRuleEnum.valueOf((String)((String)this.getModel().getValue("round"))));
        bizBill.setIntCalMethod(IntCalMethodEnum.valueOf((String)((String)this.getModel().getValue("intcalmethod"))));
        bizBill.setCurrencyId(((DynamicObject)this.getModel().getValue("currency")).getLong("id"));
        bizBill.setPeriod(period);
        return bizBill;
    }

    private void fillIntPlanList(List<IntBillInfo> intBills, RepaymentWayEnum repayWay) {
        this.getModel().deleteEntryData("intbill");
        this.getModel().deleteEntryData("detail");
        DynamicObjectCollection colls = this.getModel().getEntryEntity("intbill");
        for (int index = 0; index < intBills.size(); ++index) {
            IntBillInfo intBill = intBills.get(index);
            if (intBill == null) continue;
            DynamicObject info = colls.addNew();
            info.set("id", (Object)DBServiceHelper.genGlobalLongId());
            info.set("payintdate", (Object)intBill.getBizDate());
            info.set("totalamt", (Object)intBill.getAmount());
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("detail");
            for (IntBillDetailInfo detail : intBill.getDetails()) {
                DynamicObject entry = entrys.addNew();
                entry.set("begindate", (Object)detail.getBeginDate());
                entry.set("enddate", (Object)detail.getEndDate());
                entry.set("days", (Object)detail.getDays());
                entry.set("principle", (Object)detail.getPrinciple());
                entry.set("intrate", (Object)detail.getRate());
                entry.set("intdays", (Object)detail.getDays());
                entry.set("intamount", (Object)detail.getAmount());
                BasisEnum basis = BasisEnum.valueOf((String)((String)this.getModel().getValue("basis")));
                entry.set("basis_v", (Object)TermHelper.getBaseBasis((Date)detail.getBeginDate(), (Date)detail.getEndDate(), (BasisEnum)basis, null));
                if (RepaymentWayEnum.debx != repayWay && RepaymentWayEnum.debj != repayWay && RepaymentWayEnum.dbdx != repayWay) continue;
                entry.set("allamt", (Object)detail.getAmount().add((BigDecimal)this.getModel().getValue("repayamt", index)));
            }
        }
        for (int i = 0; i < colls.size(); ++i) {
            this.getModel().createNewEntryRow("intbill", (DynamicObject)colls.get(i));
            this.getModel().setValue("totalamt", (Object)intBills.get(i).getAmount(), i);
        }
        this.getView().updateView("intbill");
    }
}

