/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.detail;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.SysParamHelper;

public class DataSetFileStorageHelper {
    private static final Log logger = LogFactory.getLog(DataSetFileStorageHelper.class);
    private static Map fileToVersionMap = new ConcurrentHashMap(16);
    private static final int BUFFER_SIZE = 1024;
    private static final String ENCODING = "UTF-8";
    private long serialTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSetToFile(DataSet ds, String key, Date queryDate, String algoKey) {
        block9: {
            logger.info("\u8c03\u7528dataSetToFile\u4fdd\u5b58\u4e3a\u660e\u7ec6\u5feb\u7167" + key + "algoKey:" + algoKey);
            DLock dLock = DLock.create((String)(key + "-toDataSet"));
            if (dLock.tryLock(10000L)) {
                try {
                    String version;
                    String orgViewId;
                    block10: {
                        logger.info("\u8c03\u7528dataSet\u4fdd\u5b58\u4e3a\u660e\u7ec6\u5feb\u7167" + key + "algoKey:" + algoKey);
                        if (!ThreadCache.exists((Object)"orgViewId") || !ThreadCache.exists((Object)"bathno")) break block9;
                        orgViewId = ThreadCache.get((Object)"orgViewId").toString();
                        version = (String)ThreadCache.get((Object)"bathno");
                        if (!EmptyUtil.isNoEmpty((String)key) || !fileToVersionMap.containsKey(key) || !fileToVersionMap.get(key).equals(version)) break block10;
                        logger.info("\u5df2\u7ecf\u751f\u6210\u660e\u7ec6\u5feb\u7167\uff0c\u76f4\u63a5\u8fd4\u56de" + key + "algoKey:" + algoKey);
                        return;
                    }
                    try {
                        if (EmptyUtil.isNoEmpty((String)key)) {
                            logger.info("\u771f\u6b63\u5f00\u59cb\u6267\u884c\u660e\u7ec6\u5feb\u7167\uff0cputMap" + key + "algoKey:" + algoKey);
                            fileToVersionMap.put(key, version);
                        }
                        this.storeDataSet(ds.copy(), key, Long.valueOf(orgViewId), version, queryDate, algoKey);
                    }
                    catch (IOException e) {
                        logger.error("\u5feb\u7167\u660e\u7ec6\u751f\u6210\u5931\u8d25\uff1a" + key + version + "algoKey:" + algoKey);
                        logger.error((Throwable)e);
                    }
                }
                finally {
                    dLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet dataSetFromFile(Long orgViewId, String key, Date queryDate) {
        block10: {
            DLock dLock = DLock.create((String)(key + "-fromDataSet"));
            if (dLock.tryLock(10000L)) {
                try {
                    String batchno;
                    block11: {
                        logger.info("\u8c03\u7528\u660e\u7ec6\u5feb\u7167\u751f\u4ea7dataset" + key);
                        if (!EmptyUtil.isNoEmpty((Long)orgViewId)) break block10;
                        DynamicObject version = SnapDataHelper.getSnapVersion((long)orgViewId, (Date)queryDate);
                        if (EmptyUtil.isEmpty((DynamicObject)version)) {
                            DataSet dataSet = null;
                            return dataSet;
                        }
                        batchno = version.getString("number");
                        try {
                            String detailStoreType = SysParamHelper.getSysParamValue("detailstoretype", String.class);
                            if (!"localfile".equals(detailStoreType)) break block11;
                            String filePath_data = this.getDataFilePatch(key, orgViewId, batchno, queryDate);
                            String filePath_field = this.getFieldFilePatch(key, orgViewId, batchno, queryDate);
                            DataSet dataSet = this.readLocalFileToDataSet(key, filePath_data, filePath_field);
                            return dataSet;
                        }
                        catch (IOException e) {
                            logger.error((Throwable)e);
                            break block10;
                        }
                    }
                    DataSet dataSet = this.readBaseDataToDataSet(orgViewId, batchno, key, queryDate);
                    return dataSet;
                }
                finally {
                    dLock.unlock();
                }
            }
        }
        return null;
    }

    private void storeDataSet(DataSet ds, String key, Long orgViewId, String version, Date queryDate, String algoKey) throws IOException {
        logger.info("\u771f\u6b63\u8c03\u7528storeDataSet\u4fdd\u5b58\u4e3a\u660e\u7ec6\u5feb\u7167" + key + "algoKey:" + algoKey + "time :" + DateUtils.formatString((Date)DateUtils.getCurrentDate(), (String)"yyyy-MM-dd HH:mm:ss") + System.currentTimeMillis());
        long beginTime = System.currentTimeMillis();
        ArrayList<AbstractRow> rowList = new ArrayList<AbstractRow>(0);
        for (Row row : ds) {
            rowList.add(((AbstractRow)row).persist());
        }
        String str = SerializationUtils.serializeToBase64(rowList);
        String data = GzipUtils.compress((String)str, (String)ENCODING);
        long endTime = System.currentTimeMillis();
        this.serialTime = endTime - beginTime;
        Field[] fieldList = ds.getRowMeta().getFields();
        String fields = GzipUtils.compress((String)SerializationUtils.serializeToBase64((Object)fieldList), (String)ENCODING);
        String detailStoreType = SysParamHelper.getSysParamValue("detailstoretype", String.class);
        if ("localfile".equals(detailStoreType)) {
            String filePath_data = this.getDataFilePatch(key, orgViewId, version, queryDate);
            String filePath_field = this.getFieldFilePatch(key, orgViewId, version, queryDate);
            this.storeLocalFile(rowList.size(), orgViewId, version, queryDate, filePath_data, filePath_field, data, fields);
        } else {
            logger.info("\u6570\u636e\u5e93\u5b58\u50a8\u660e\u7ec6\u5feb\u7167key:" + key + "algoKey:" + algoKey);
            this.storeBaseData(rowList.size(), orgViewId, key, version, queryDate, data, fields);
        }
    }

    private void storeLocalFile(int index, Long orgViewId, String version, Date queryDate, String filePath_data, String filePath_field, String ... data) throws IOException {
        long beginTime = System.currentTimeMillis();
        this.createNewFile(orgViewId, version, queryDate, filePath_data, filePath_field);
        this.writeByChannel(filePath_data, data[0]);
        this.writeByChannel(filePath_field, data[1]);
    }

    private void storeBaseData(int rowSize, Long orgViewId, String key, String version, Date queryDate, String ... data) throws IOException {
        long beginTime = System.currentTimeMillis();
        this.writeBaseData(rowSize, orgViewId, key, version, queryDate, data);
    }

    private void writeByChannel(String file, String data) throws IOException {
        byte[] dataBytes = data.getBytes();
        ByteBuffer buffer_data = ByteBuffer.allocate(1024);
        try (FileChannel targetChannel = FileChannel.open(new File(file).toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            for (int i = 0; i < dataBytes.length; i += 1024) {
                int readLens = dataBytes.length > i + 1024 ? 1024 : dataBytes.length - i;
                buffer_data.clear();
                buffer_data.put(dataBytes, i, readLens);
                buffer_data.flip();
                targetChannel.write(buffer_data);
            }
        }
    }

    private void writeBaseData(int rowSize, Long orgViewId, String key, String version, Date queryDate, String ... data) {
        DynamicObject dataSnap = TmcDataServiceHelper.newDynamicObject((String)"tda_detailsnap");
        dataSnap.set("number", (Object)key);
        dataSnap.set("name", (Object)key);
        if (EmptyUtil.isNoEmpty((Long)orgViewId)) {
            dataSnap.set("orgview", (Object)orgViewId);
        }
        dataSnap.set("version", (Object)version);
        dataSnap.set("snap_tag", (Object)data[0]);
        dataSnap.set("fields_tag", (Object)data[1]);
        dataSnap.set("snapdate", (Object)queryDate);
        dataSnap.set("rowsize", (Object)rowSize);
        dataSnap.set("creator", (Object)RequestContext.get().getCurrUserId());
        dataSnap.set("createtime", (Object)DateUtils.getCurrentTime());
        dataSnap.set("enable", (Object)1);
        dataSnap.set("status", (Object)BillStatusEnum.SAVE.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSnap});
    }

    private DataSet readLocalFileToDataSet(String dataKey, String filePath_data, String filePath_field) throws IOException {
        Path path_data = Paths.get(filePath_data, new String[0]);
        Path path_field = Paths.get(filePath_field, new String[0]);
        if (!Files.exists(path_data, new LinkOption[0]) || !Files.exists(path_field, new LinkOption[0])) {
            return null;
        }
        byte[] str = Files.readAllBytes(Paths.get(filePath_field, new String[0]));
        String fieldsTag = new String(str, ENCODING);
        Field[] fields = (Field[])SerializationUtils.deSerializeFromBase64((String)fieldsTag);
        try (FileChannel channel = FileChannel.open(Paths.get(filePath_data, new String[0]), StandardOpenOption.READ);){
            long fileSize = channel.size();
            DataSet columnBuffers = new ByteBuffer[(int)fileSize];
            channel.read((ByteBuffer[])columnBuffers);
            StringBuilder content = new StringBuilder();
            for (ByteBuffer buffer : columnBuffers) {
                buffer.flip();
                while (buffer.hasRemaining()) {
                    content.append((char)buffer.get());
                }
            }
            DataSet dataSet = this.toDataSet(content.toString(), fields, dataKey);
            return dataSet;
        }
    }

    private DataSet readBaseDataToDataSet(Long orgViewId, String version, String key, Date queryDate) throws IOException {
        QFilter filter = new QFilter("orgview.id", "=", (Object)orgViewId);
        filter.and(new QFilter("version", "=", (Object)version));
        filter.and(new QFilter("number", "=", (Object)key));
        filter.and(new QFilter("snapdate", "=", (Object)queryDate));
        DynamicObject detail = TmcDataServiceHelper.loadSingleFromCache((String)"tda_detailsnap", (String)"rowsize,snap_tag,fields_tag", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)detail)) {
            logger.info(key + ", \u660e\u7ec6\u5feb\u7167\u6570\u636e\u91cf: " + detail.getInt("rowsize"));
            String dataTag = detail.getString("snap_tag");
            String fieldsTag = detail.getString("fields_tag");
            Field[] fields = (Field[])SerializationUtils.deSerializeFromBase64((String)GzipUtils.uncompress((String)fieldsTag, (String)ENCODING));
            return this.toDataSet(dataTag, fields, key);
        }
        return null;
    }

    private DataSet toDataSet(String data, Field[] fields, String dataKey) throws IOException {
        CachedDataSet.Builder dataSetBuilder = Algo.create((String)dataKey).createCachedDataSetBuilder(new RowMeta(fields), this.hint(dataKey));
        List rows = (List)SerializationUtils.deSerializeFromBase64((String)GzipUtils.uncompress((String)data, (String)ENCODING));
        logger.info("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u5230\u660e\u7ec6\u6570\u636e\u5171" + rows.size() + "\u884c\u6570\u636e\uff0cdataKey = " + dataKey);
        for (Row row : rows) {
            if (!EmptyUtil.isNoEmpty((Object)row)) continue;
            dataSetBuilder.append(row);
        }
        return dataSetBuilder.build().toDataSet(Algo.create((String)dataKey), true);
    }

    private CacheHint hint(String cacheKey) {
        CacheHint hint = new CacheHint();
        hint.setTimeout(1800000L);
        hint.setCacheId(cacheKey);
        return hint;
    }

    private String getDataFilePatch(String key, Long orgViewId, String version, Date queryDate) {
        return this.getFilePatch(orgViewId, version, queryDate) + System.getProperty("file.separator") + key + "-data.text";
    }

    private String getFieldFilePatch(String key, Long orgViewId, String version, Date queryDate) {
        return this.getFilePatch(orgViewId, version, queryDate) + System.getProperty("file.separator") + key + "-field.text";
    }

    private String getFilePatch(Long orgViewId, String version, Date queryDate) {
        return System.getProperty("file.separator") + "tda" + System.getProperty("file.separator") + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd") + System.getProperty("file.separator") + orgViewId + System.getProperty("file.separator") + version;
    }

    private void createNewFile(Long orgViewId, String version, Date queryDate, String ... filePaths) throws IOException {
        for (String filePath : filePaths) {
            File file = new File(filePath);
            if (file.exists()) {
                if (file.delete()) {
                    logger.info("delete sucess");
                }
            } else {
                File file2 = new File(this.getFilePatch(orgViewId, version, queryDate));
                if (!file2.exists()) {
                    file2.mkdirs();
                }
            }
            if (!file.createNewFile()) continue;
            logger.info("createNewFile sucess");
        }
    }
}

