/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.enums;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum CurrencyTypeEnum {
    CNY(new MultiLangEnumBridge("\u4eba\u6c11\u5e01", "CurrencyTypeEnum_0", "tmc-tda-common"), "CNY", "0"),
    USD(new MultiLangEnumBridge("\u7f8e\u5143", "CurrencyTypeEnum_2", "tmc-tda-common"), "USD", "1"),
    HKD(new MultiLangEnumBridge("\u6e2f\u5e01", "CurrencyTypeEnum_1", "tmc-tda-common"), "HKD", "2"),
    OTHER(new MultiLangEnumBridge("\u5176\u4ed6", "CurrencyTypeEnum_3", "tmc-tda-common"), "OTH", "3");

    private MultiLangEnumBridge name;
    private String number;
    private String type;

    private CurrencyTypeEnum(MultiLangEnumBridge name, String number, String type) {
        this.name = name;
        this.number = number;
        this.type = type;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public static List<CurrencyTypeEnum> nonOtherValues() {
        return Stream.of(CurrencyTypeEnum.values()).filter(e -> e != OTHER).collect(Collectors.toList());
    }

    public static CurrencyTypeEnum getByNumber(String number) {
        CurrencyTypeEnum result = null;
        for (CurrencyTypeEnum typeEnum : CurrencyTypeEnum.values()) {
            if (!typeEnum.getNumber().equals(number)) continue;
            result = typeEnum;
            break;
        }
        if (result == null) {
            return OTHER;
        }
        return result;
    }

    public static CurrencyTypeEnum getByType(String type) {
        CurrencyTypeEnum result = null;
        for (CurrencyTypeEnum typeEnum : CurrencyTypeEnum.values()) {
            if (!typeEnum.getType().equals(type)) continue;
            result = typeEnum;
            break;
        }
        return result;
    }
}

