/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.enums;

import kd.tmc.fbp.common.enums.MultiLangEnumBridge;
import kd.tmc.fbp.common.util.EmptyUtil;

public enum FinanceTermYearEnum {
    WITHIN_SIX_MONTH(new MultiLangEnumBridge("6\u4e2a\u6708\u4ee5\u5185", "FinanceTermYearEnum_0", "tmc-tda-common"), 1),
    SIX_MONTH_ONE_YEAR(new MultiLangEnumBridge("6\u4e2a\u6708-1\u5e74", "FinanceTermYearEnum_5", "tmc-tda-common"), 2),
    ONE_THREE_YEAR(new MultiLangEnumBridge("1\u5e74-3\u5e74", "FinanceTermYearEnum_1", "tmc-tda-common"), 3),
    THREE_FIVE_YEAR(new MultiLangEnumBridge("3\u5e74-5\u5e74", "FinanceTermYearEnum_2", "tmc-tda-common"), 4),
    FIVE_TEN_YEAR(new MultiLangEnumBridge("5\u5e74-10\u5e74", "FinanceTermYearEnum_3", "tmc-tda-common"), 5),
    MORE_THEN_TEN_YEAR(new MultiLangEnumBridge("10\u5e74\u4ee5\u4e0a", "FinanceTermYearEnum_4", "tmc-tda-common"), 6);

    private MultiLangEnumBridge text;
    private int number;

    private FinanceTermYearEnum(MultiLangEnumBridge text, int number) {
        this.text = text;
        this.number = number;
    }

    public static FinanceTermYearEnum getTermYearNumber(String term) {
        FinanceTermYearEnum yearEnum;
        boolean isContainMonthDay;
        if (EmptyUtil.isEmpty((String)term)) {
            return MORE_THEN_TEN_YEAR;
        }
        int indexYear = term.indexOf("y");
        int indexMonth = term.indexOf("m");
        if (indexYear <= 0) {
            if (indexMonth <= 0) {
                return WITHIN_SIX_MONTH;
            }
            int month = Integer.parseInt(term.substring(0, indexMonth));
            if (month <= 5) {
                return WITHIN_SIX_MONTH;
            }
            if (month == 6 && !term.contains("d")) {
                return WITHIN_SIX_MONTH;
            }
            return SIX_MONTH_ONE_YEAR;
        }
        int year = Integer.parseInt(term.substring(0, indexYear));
        boolean bl = isContainMonthDay = term.contains("m") || term.contains("d");
        if (year <= 1) {
            yearEnum = SIX_MONTH_ONE_YEAR;
            if (year == 1 && isContainMonthDay) {
                yearEnum = ONE_THREE_YEAR;
            }
        } else if (year > 1 && year <= 3) {
            yearEnum = ONE_THREE_YEAR;
            if (year == 3 && isContainMonthDay) {
                yearEnum = THREE_FIVE_YEAR;
            }
        } else if (year > 3 && year <= 5) {
            yearEnum = THREE_FIVE_YEAR;
            if (year == 5 && isContainMonthDay) {
                yearEnum = FIVE_TEN_YEAR;
            }
        } else if (year > 5 && year <= 10) {
            yearEnum = FIVE_TEN_YEAR;
            if (year == 10 && isContainMonthDay) {
                yearEnum = MORE_THEN_TEN_YEAR;
            }
        } else {
            yearEnum = MORE_THEN_TEN_YEAR;
        }
        return yearEnum;
    }

    public String getText() {
        return this.text.loadKDString();
    }

    public int getNumber() {
        return this.number;
    }
}

