/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.TdaParameterHelper;

public abstract class AbstractFinanceFieldConvert {
    protected DataSet source;
    protected List<Long> ids = new ArrayList<Long>(10);
    protected boolean containZeroRate = TdaParameterHelper.getFinZeroRateFlag();
    protected Date queryDate;

    public AbstractFinanceFieldConvert(DataSet source, Date queryDate) {
        this.source = source;
        this.queryDate = queryDate;
        Iterator iterator = source.copy().select("id").groupBy(new String[]{"id"}).finish().iterator();
        while (iterator.hasNext()) {
            this.ids.add(((Row)iterator.next()).getLong("id"));
        }
    }

    protected DataSet convertSource() {
        this.source = this.covertSourceType(this.source);
        this.source = this.covertFinanceType(this.source);
        this.source = this.covertOutGroup(this.source);
        this.source = this.covertCreditortype(this.source);
        this.source = this.covertTextCreditor(this.source);
        this.source = this.covertBankCate(this.source);
        this.source = this.covertRegion(this.source);
        this.source = this.covertDrawAmount(this.source);
        this.source = this.covertStartIntDate(this.source);
        this.source = this.covertExpireDate(this.source);
        this.source = this.covertTerm(this.source);
        this.source = this.covertInterestType(this.source);
        this.source = this.covertBasis(this.source);
        this.source = this.covertLoanRate(this.source);
        this.source = this.covertFinanceMode(this.source);
        this.source = this.covertRepayedAmount(this.source);
        this.source = this.covertResidueTerm(this.source);
        this.source = this.covertRepayAmount(this.source);
        this.source = this.covertIsEquity(this.source);
        this.source = this.covertPerpetualbond(this.source);
        this.source = this.afterConvert(this.source);
        return this.source;
    }

    protected abstract DataSet covertSourceType(DataSet var1);

    protected abstract DataSet covertFinanceType(DataSet var1);

    protected abstract DataSet covertOutGroup(DataSet var1);

    protected abstract DataSet covertCreditortype(DataSet var1);

    protected abstract DataSet covertTextCreditor(DataSet var1);

    protected abstract DataSet covertBankCate(DataSet var1);

    protected abstract DataSet covertRegion(DataSet var1);

    protected abstract DataSet covertDrawAmount(DataSet var1);

    protected abstract DataSet covertStartIntDate(DataSet var1);

    protected DataSet covertExpireDate(DataSet source) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        QFilter qFilter = new QFilter("loanbilllist.drawbillid", "in", this.ids);
        qFilter.and("bizdate", "<=", (Object)this.queryDate);
        DataSet extendBillSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertExpireDate"), (String)"cfm_contractextendbill", (String)"contractbillno,loanbilllist.drawbillid as loanbillid,loanbilllist.lrenewalexpiredate as lrenewalexpiredate", (QFilter[])qFilter.toArray(), null);
        extendBillSet = extendBillSet.select("loanbillid,lrenewalexpiredate").groupBy(new String[]{"loanbillid"}).max("lrenewalexpiredate").finish();
        source = source.leftJoin(extendBillSet).on("id", "loanbillid").select(fieldNames, new String[]{"lrenewalexpiredate"}).finish().updateField("expiredate", "case when lrenewalexpiredate is null then expiredate else lrenewalexpiredate end");
        source = source.removeFields(new String[]{"lrenewalexpiredate"});
        return source;
    }

    protected DataSet covertTerm(DataSet source) {
        final RowMeta rowMeta = source.getRowMeta();
        source = source.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(20);
                for (String fieldName : rowMeta.getFieldNames()) {
                    if ("term".equals(fieldName) && EmptyUtil.isNoEmpty((Object)row.getDate("startintdate")) && EmptyUtil.isNoEmpty((Object)row.getDate("expiredate"))) {
                        String term = DateUtils.getDiff_ymd((Date)row.getDate("startintdate"), (Date)row.getDate("expiredate"));
                        rowInfo.add(term);
                        continue;
                    }
                    if ("residueterm".equals(fieldName) && EmptyUtil.isNoEmpty((Object)row.getDate("expiredate"))) {
                        String residueterm = DateUtils.getDiff_ymd((Date)AbstractFinanceFieldConvert.this.queryDate, (Date)row.getDate("expiredate"));
                        rowInfo.add(residueterm);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        return source;
    }

    protected abstract DataSet covertInterestType(DataSet var1);

    protected abstract DataSet covertBasis(DataSet var1);

    protected DataSet covertLoanRate(DataSet source) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        QFilter qFilter = new QFilter("id", "in", this.ids);
        qFilter.and("rateadjust_entry.ra_effectdate", "<=", (Object)this.queryDate);
        DataSet resetRateBillSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertLoanRate"), (String)"cfm_loanbill", (String)"id,rateadjust_entry.ra_yearrate as yearrate,rateadjust_entry.ra_effectdate as effectdate", (QFilter[])qFilter.toArray(), null);
        DataSet lastRateDate = resetRateBillSet.copy().select("id,effectdate").groupBy(new String[]{"id"}).max("effectdate").finish();
        resetRateBillSet = lastRateDate.leftJoin(resetRateBillSet).on("id", "id").on("effectdate", "effectdate").select(new String[]{"id", "effectdate"}, new String[]{"yearrate"}).finish();
        source = source.leftJoin(resetRateBillSet).on("id", "id").select(fieldNames, new String[]{"yearrate"}).finish().updateField("loanrate", "case when yearrate is null then 0 else yearrate end");
        source = source.removeFields(new String[]{"yearrate"});
        return source;
    }

    protected abstract DataSet covertFinanceMode(DataSet var1);

    protected DataSet covertRepayedAmount(DataSet source) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        QFilter qFilter = new QFilter("loans.e_loanbill", "in", this.ids);
        qFilter.and("bizdate", "<=", (Object)this.queryDate);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet repaymentBills = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertRepayedAmount"), (String)"cfm_repaymentbill", (String)"id,loans.e_loanbill as loanbillid,loans.e_repayamount as erepayamount", (QFilter[])qFilter.toArray(), null);
        repaymentBills = repaymentBills.select("loanbillid,erepayamount").groupBy(new String[]{"loanbillid"}).sum("erepayamount").finish();
        source = source.leftJoin(repaymentBills).on("id", "loanbillid").select(fieldNames, new String[]{"erepayamount"}).finish().updateField("repayedamount", "case when erepayamount is null then 0 else erepayamount end");
        source = source.removeFields(new String[]{"erepayamount"});
        return source;
    }

    protected abstract DataSet covertResidueTerm(DataSet var1);

    protected DataSet covertIsEquity(DataSet source) {
        return source;
    }

    protected DataSet covertPerpetualbond(DataSet source) {
        return source;
    }

    protected DataSet covertRepayAmount(DataSet source) {
        return source.updateFields(new String[]{"repayamount", "repayamountsum"}, new String[]{"drawamount-repayedamount", "drawamount-repayedamount"});
    }

    protected DataSet afterConvert(DataSet source) {
        return source;
    }
}

