/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.BasicParamSetFormDataHelper;
import kd.tmc.tda.common.helper.CtrlConditionHelper;

public class BasicParamHelper {
    private static final String ISDOMESTIC = "isdomestic";
    private static final String ISDOMESTIC_FUND = "isdomestic_fund";

    public static DataSet includeOverseasFunds(DataSet ds, List<Long> orgIds) {
        ds = ds.addField(ISDOMESTIC, ISDOMESTIC_FUND);
        final Set<Long> accountIds = BasicParamHelper.accountConfig("abroadapplyconditiontag", orgIds);
        if (EmptyUtil.isEmpty(accountIds)) {
            return ds;
        }
        final RowMeta rowMetas = ds.getRowMeta();
        return ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                Integer fundType = row.getInteger("fundtype");
                Long accountBank = row.getLong("accountbank");
                for (String fieldName : rowMetas.getFieldNames()) {
                    if (BasicParamHelper.ISDOMESTIC_FUND.equals(fieldName) && fundType != null && fundType == 0 && accountIds.contains(accountBank)) {
                        rowInfo.add("0");
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
    }

    public static DataSet excludePositionFilter(DataSet ds, List<Long> orgIds) {
        Set<Long> accountIds = BasicParamHelper.accountConfig("positionapplyconditiontag", orgIds);
        if (EmptyUtil.isNoEmpty(accountIds)) {
            ds = ds.filter("fundtype != 0 or (fundtype = 0 and accountbank not in accountIds)", Collections.singletonMap("accountIds", accountIds));
        }
        return ds;
    }

    public static Set<Long> accountConfig(String contentKey, List<Long> orgIds) {
        DynamicObject dynamicObjectTag = BasicParamHelper.getSrcDataEntities("tda_application_scenarios");
        if (dynamicObjectTag == null) {
            return Collections.emptySet();
        }
        String filterTag = (String)dynamicObjectTag.get(contentKey);
        if (EmptyUtil.isEmpty((String)filterTag)) {
            return Collections.emptySet();
        }
        QFilter filter = CtrlConditionHelper.getFilterFromTag("bd_accountbanks", filterTag);
        if (filter != null && EmptyUtil.isNoEmpty(orgIds)) {
            filter.and("company", "in", orgIds);
        }
        return CtrlConditionHelper.getBankAcctSet(filter);
    }

    public static DataSet getBasicParamApplicationConfigs(DataSet bankAcctSet, String contentKey) {
        DynamicObjectCollection dynamicObjects;
        DynamicObject dynamicObjectTag = BasicParamHelper.getSrcDataEntities("tda_application_scenarios");
        if (dynamicObjectTag == null) {
            return bankAcctSet;
        }
        String filterTag = (String)dynamicObjectTag.get(contentKey);
        if (EmptyUtil.isEmpty((String)filterTag)) {
            return bankAcctSet;
        }
        QFilter acctFilter = CtrlConditionHelper.getFilterFromTag("bd_accountbanks", filterTag);
        if (acctFilter != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)(dynamicObjects = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{acctFilter})))) {
            String idSet = dynamicObjects.stream().map(s -> s.get("id").toString()).collect(Collectors.joining(","));
            return bankAcctSet.filter("id not in (" + idSet + ")");
        }
        return bankAcctSet;
    }

    public static String getBasicParamGenericConfigs(String entityKey, String contentKey) {
        DynamicObject dynamicObjectContent = BasicParamHelper.getSrcDataEntities(entityKey);
        if (dynamicObjectContent != null && dynamicObjectContent.get(contentKey) != null) {
            return dynamicObjectContent.get(contentKey).toString();
        }
        return null;
    }

    public static boolean getAppBooleamParameter(String entityKey, String contentKey) {
        DynamicObject dynamicObjectContent = BasicParamHelper.getSrcDataEntities(entityKey);
        if (dynamicObjectContent != null && dynamicObjectContent.get(contentKey) != null) {
            return (Boolean)dynamicObjectContent.get(contentKey);
        }
        return false;
    }

    private static DynamicObject getSrcDataEntities(String entityKey) {
        QFilter qFilter = new QFilter("name", "=", (Object)entityKey);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tda_param_basic", (String)"id,nodeid,params_tag", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) {
            String jsonString = (String)dynamicObject.get("params_tag");
            MainEntityType subMainType = EntityMetadataCache.getDataEntityType((String)entityKey);
            DataEntityPropertyCollection dataEntityProperties = subMainType.getProperties();
            if (jsonString != null && !entityKey.equals("tda_application_scenarios")) {
                jsonString = BasicParamSetFormDataHelper.checkBuildJsonParamStr(jsonString, dataEntityProperties, dynamicObject, 0);
            }
            return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)jsonString, (IDataEntityType)subMainType);
        }
        return null;
    }
}

