/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.CashFundsDataHelper;

public class CashFundsTrendDataHelper {
    private static final Log logger = LogFactory.getLog(CashFundsTrendDataHelper.class);

    public static DataSet getFundDataSet(String algoKey, List<Long> orgIds, Date queryDate, Map<String, Object> paramMap, boolean usePositionAccSet) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        String cachekey = CashFundsTrendDataHelper.getCacheKey(orgViewId, orgId, queryDate);
        ThreadCache.put((Object)"orgViewId", (Object)orgViewId.toString());
        DataSet allDs = CacheManager.getCacheOrElseGet(orgViewId, CashFundsDataHelper.class.getName(), cachekey, () -> {
            DataSet currencyMonth = CashFundsDataHelper.getFundDataSet(algoKey, orgIds, queryDate, paramMap, false, usePositionAccSet).updateField("bizdate", "'" + DateUtils.formatString((Date)queryDate, (String)"yyyyMM") + "'").select("isoffset,company,bizdate,realvalibalance,realrestrictedamt").groupBy(new String[]{"isoffset", "company", "bizdate"}).sum("realvalibalance").sum("realrestrictedamt").finish();
            String[] fieldNames = currencyMonth.getRowMeta().getFieldNames();
            for (int i = 0; i < 11; ++i) {
                Date lastMonthDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)(-(i + 1)));
                DataSet tempLastMonth = CashFundsDataHelper.getFundDataSet(algoKey, orgIds, lastMonthDate, paramMap, false, usePositionAccSet).updateField("bizdate", "'" + DateUtils.formatString((Date)lastMonthDate, (String)"yyyyMM") + "'").select("isoffset,company,bizdate,realvalibalance,realrestrictedamt").groupBy(new String[]{"isoffset", "company", "bizdate"}).sum("realvalibalance").sum("realrestrictedamt").finish();
                currencyMonth = currencyMonth.union(tempLastMonth.select(fieldNames));
            }
            return currencyMonth;
        });
        return allDs;
    }

    public static String getCacheKey(Long orgviewId, Long orgId, Date queryDate) {
        return "CashFundsTrendDataHelper-cachekey-" + orgviewId + "-" + orgId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }
}

