/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.tda.extpoint.credit.ICreditGetDataInterface;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.SysParamHelper;

public class CreditDataHelper {
    public static String getCacheKey(Long orgviewId, Date queryDate) {
        return "creditDataHelper-cachekey-" + orgviewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }

    public static DataSet getAllCreditLimit(String algoKey, Long orgview, List<Long> allorgids, Date date, Long basecurrency) {
        Date queryDate = DateUtils.getNextDay((Date)DateUtils.truncateDate((Date)date), (int)1);
        String cacheKey = CreditDataHelper.getCacheKey(orgview, queryDate);
        boolean noCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        DataSet cacheOrElseGet = CacheManager.getCacheOrElseGet(orgview, algoKey, cacheKey, () -> CreditDataHelper.queryCreditLimitSet(orgview, allorgids, basecurrency, queryDate, noCache, isQueryCache));
        if (isQueryCache && !noCache) {
            cacheOrElseGet = cacheOrElseGet.filter("org in ids", Collections.singletonMap("ids", allorgids));
        }
        return cacheOrElseGet;
    }

    private static DataSet queryCreditLimitSet(Long orgview, List<Long> allorgids, Long basecurrency, Date queryDate, boolean noCache, boolean isQueryCache) {
        List quaryOrgIds = allorgids;
        if (isQueryCache && !noCache) {
            quaryOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgview);
        }
        QFilter creditFilter = CreditDataHelper.getCreditFilter(quaryOrgIds, queryDate);
        String selectColField = "id,number,org,sourcebillids.fbasedataid sourceid,totalamt,currency,currency.name currencyname,bank.finorgtype.type as finorgtype,bank.name bankorgname, bank.bank_cate as bankcate,bank.bank_cate.name as bankname,case when bank.country.twocountrycode = 'CN' then '1' else case when bank.country.threecountrycode = 'CHN' then '1' else case when bank.country = 0 or (TRIM(bank.country.twocountrycode) = '' and TRIM(bank.country.threecountrycode) = '') then '1' else '0' end end end isdomestic,closedate,creditprop,number creditno,contractno,banktype,credittype.name credittypename,startdate,enddate,guartype";
        DataSet allCreditLimitSet = QueryServiceHelper.queryDataSet((String)"DecisionAnlsHelper.getAllCreditLimit", (String)"cfm_creditlimit", (String)selectColField, (QFilter[])new QFilter[]{creditFilter}, null);
        String sic = "id,number,org,sourceid,totalamt,currency,currencyname,finorgtype,bankorgname,bankcate,bankname,isdomestic,closedate,creditprop,creditno,contractno,banktype,credittypename,startdate,enddate,guartype";
        allCreditLimitSet = allCreditLimitSet.leftJoin(allCreditLimitSet).on("id", "sourceid").select(sic.split(","), new String[]{"id as assrcid"}).finish().filter("assrcid is null").filter("closedate >= queryDate or closedate is null", Collections.singletonMap("queryDate", queryDate));
        DataSet creditLimitUse = CreditDataHelper.computeUsedAmount(allCreditLimitSet, queryDate);
        allCreditLimitSet = allCreditLimitSet.leftJoin(creditLimitUse).on("id", "creditlimit").select(sic.split(","), new String[]{"useamount", "returnamount"}).finish().updateFields(new String[]{"useamount", "returnamount"}, new String[]{"case when useamount is null or useamount<0 then 0.0 else useamount end", "case when returnamount is null or returnamount<0 then 0.0 else returnamount end"});
        String props = sic + ",totalamt originaltotalamt,case when creditprop='circle' then useamount-returnamount else useamount end useamt";
        allCreditLimitSet = allCreditLimitSet.select(props).addField("useamt", "originaluseamt");
        Date transDate = DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)queryDate, (int)-1), (boolean)false);
        allCreditLimitSet = AmountTransHelper.tranDataSetRate((DataSet)allCreditLimitSet, (Long)orgview, (Long)basecurrency, (String)"currency", Arrays.asList("totalamt", "useamt").stream().collect(Collectors.toSet()), (Date)transDate);
        return allCreditLimitSet;
    }

    private static DataSet computeUsedAmount(DataSet allCreditLimitSet, Date queryDate) {
        Set<Long> ids = DecisionCommonHelper.getFieldValues(allCreditLimitSet.copy(), "id", Long.class);
        QFilter creditUseFilter = new QFilter("creditlimit", "in", ids).and("amount", ">", (Object)BigDecimal.ZERO).and("createtime", "<", (Object)queryDate).and("sourcetype", "!=", (Object)"cfm_loan_apply").and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet creditLimitUse = QueryServiceHelper.queryDataSet((String)"DecisionAnlsHelper.getAllCreditLimit", (String)"cfm_credituse", (String)"id,creditlimit,amount", (QFilter[])new QFilter[]{creditUseFilter}, null);
        creditUseFilter.and("returnentry.e_returntime", "<", (Object)queryDate);
        DataSet creditLimitUseEntry = QueryServiceHelper.queryDataSet((String)"DecisionAnlsHelper.getAllCreditLimit", (String)"cfm_credituse", (String)"id,creditlimit,returnentry.e_amount returnamount", (QFilter[])new QFilter[]{creditUseFilter}, null);
        creditLimitUse = creditLimitUse.leftJoin(creditLimitUseEntry).on("id", "id").select(new String[]{"id", "creditlimit", "amount"}, new String[]{"returnamount"}).finish().select("id,creditlimit,amount,case when returnamount is null then 0 else returnamount end returnamount");
        creditLimitUse = creditLimitUse.select(new String[]{"id", "creditlimit", "amount", "returnamount"}).groupBy(new String[]{"id", "creditlimit", "amount"}).sum("returnamount").finish().select(new String[]{"creditlimit", "amount", "returnamount"}).groupBy(new String[]{"creditlimit"}).sum("amount", "useamount").sum("returnamount").finish();
        return creditLimitUse;
    }

    private static QFilter getCreditFilter(List<Long> allOrgIds, Date queryDate) {
        QFilter filter = new QFilter("org", "in", allOrgIds);
        filter.and("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("banktype", "=", (Object)"bd_finorginfo");
        Date endDate = DateUtils.getNextDay((Date)queryDate, (int)-1);
        filter.and("startdate", "<", (Object)queryDate).and("enddate", ">=", (Object)endDate);
        return CreditDataHelper.getExtendFilter(filter);
    }

    public static QFilter getExtendFilter(QFilter qFilter) {
        PluginProxy pluginProxy = PluginProxy.create(ICreditGetDataInterface.class, (String)"kd.sdk.tmc.tda.extpoint.credit.ICreditGetDataInterface");
        List lists = pluginProxy.callReplace(p -> p.getTdaCreditExtendFilter(qFilter));
        if (EmptyUtil.isNoEmpty((Object)lists) && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (QFilter)lists.get(0);
        }
        return qFilter;
    }
}

