/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.JSONUtils;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.snap.IDataSnapExecute;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.common.model.DesignDataSet;

public class CustomControlUtil {
    private static final Log logger = LogFactory.getLog(CustomControlUtil.class);
    private static final String QING_SORT = "qingsort";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String customControlDataForPlugin(String pluginName, Map<String, Object> paramMap) {
        try (DataSet ds = null;){
            IDataSnapExecute pluginInstance = (IDataSnapExecute)Class.forName(pluginName).newInstance();
            ds = CustomControlUtil.getBizDs(paramMap, pluginInstance);
            DesignDataSet designDataSet = CustomControlUtil.transDataSetArray(ds, pluginInstance);
            String string = JSONUtils.toString((Object)designDataSet);
            return string;
        }
    }

    public static QFilter[] getQueryFilters(Map<String, Object> paramMap) {
        LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
        qFilters.add(new QFilter("orgview", "=", paramMap.get("orgview")));
        qFilters.add(new QFilter("org", "=", paramMap.get("org")));
        qFilters.add(new QFilter("querydate", "=", paramMap.get("querydate")));
        qFilters.add(new QFilter("amountunit", "=", paramMap.get("amountunit")));
        qFilters.add(new QFilter("currency", "=", paramMap.get("currency")));
        qFilters.add(new QFilter("basecurrency", "=", paramMap.get("basecurrency")));
        CustomControlUtil.addOtherFilterFromMap(qFilters, paramMap, "custsupptype", "paymentday", "comloanrange", "customtype", "date", "termtype", "term", "ccrtermtype", "ccrdate", "ensuretype", "ccrareatype");
        return qFilters.toArray(new QFilter[0]);
    }

    public static Map<String, Object> getParamMap(IFormView view) {
        Object queryDate;
        Object amountUnit;
        Object currency;
        Object org;
        DynamicObject orgView;
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        if (null == view.getControl("orgview")) {
            DynamicObject set = TdaCommonHelper.getCurrentUserDefaultSet();
            if (null == set) {
                orgView = TmcDataServiceHelper.loadSingleFromCache((Object)8L, (String)"fbd_companysysviewsch");
                org = TmcDataServiceHelper.loadSingleFromCache((Object)OrgUnitServiceHelper.getRootOrgId(), (String)"bos_org");
                currency = TmcDataServiceHelper.loadSingleFromCache((Object)1L, (String)"bd_currency");
                amountUnit = "100000000";
            } else {
                orgView = set.getDynamicObject("orgview");
                Long defaultOrgId = TdaCommonHelper.getRootPermOrgIdByOrgView(orgView.getLong("id"));
                org = TmcDataServiceHelper.loadSingleFromCache((Object)defaultOrgId, (String)"bos_org");
                currency = TmcDataServiceHelper.loadSingleFromCache((Object)TdaCommonHelper.getDefaultCurrencyByOrg(defaultOrgId), (String)"bd_currency");
                amountUnit = set.get("amountunit");
            }
            queryDate = new Date();
        } else {
            IDataModel model = view.getModel();
            orgView = (DynamicObject)model.getValue("orgview");
            org = model.getValue("org");
            queryDate = model.getValue("querydate");
            currency = model.getValue("currency");
            amountUnit = model.getValue("amountunit");
            CustomControlUtil.putOtherSelectedValue(view, paramMap);
        }
        paramMap.put("orgview", orgView);
        paramMap.put("org", org);
        paramMap.put("querydate", queryDate);
        paramMap.put("currency", currency);
        paramMap.put("amountunit", amountUnit);
        paramMap.put("basecurrency", AmountTransHelper.getBaseCurrency((Long)orgView.getLong("id")));
        return paramMap;
    }

    private static void putOtherSelectedValue(IFormView view, Map<String, Object> paramMap) {
        TdaCommonHelper.putSelectValue(view, paramMap, "custsupptype");
        TdaCommonHelper.putSelectValue(view, paramMap, "paymentday");
        TdaCommonHelper.putSelectValue(view, paramMap, "comloanrange");
        TdaCommonHelper.putTypeLinkValue(view, paramMap, "customtype", "date");
        TdaCommonHelper.putTypeLinkValue(view, paramMap, "termtype", "term");
        TdaCommonHelper.putTypeLinkValue(view, paramMap, "ccrtermtype", "ccrdate");
        TdaCommonHelper.putSelectValue(view, paramMap, "ensuretype");
        TdaCommonHelper.putSelectValue(view, paramMap, "ccrareatype");
    }

    public static DataSet getBizDs(Map<String, Object> paramMap, IDataSnapExecute pluginInstance) throws Exception {
        QFilter[] qFilters = CustomControlUtil.getQueryFilters(paramMap);
        DataSet bizDs = pluginInstance.data(qFilters);
        bizDs = CustomControlUtil.filterResultDataSet(pluginInstance, bizDs, paramMap);
        Set<String> amountFields = TdaCommonHelper.getAmountFields(pluginInstance);
        if (EmptyUtil.isNoEmpty(amountFields)) {
            bizDs = AmountTransHelper.dealRowOtherValue((DataSet)bizDs, paramMap, amountFields);
        }
        return bizDs;
    }

    public static DesignDataSet transDataSetArray(DataSet ds, IDataSnapExecute pluginInstance) {
        DesignDataSet designDataSet = new DesignDataSet();
        if (ds == null) {
            return designDataSet;
        }
        List<Object[]> columns = CustomControlUtil.getColumnItems(pluginInstance);
        designDataSet.setDataindex(columns);
        LinkedList<Object[]> data = new LinkedList<Object[]>();
        CustomControlUtil.addColumnName(data, columns);
        Iterator it = ds.iterator();
        int sort = 0;
        while (it.hasNext()) {
            Row rs = (Row)it.next();
            Object[] row = new Object[columns.size()];
            for (int index = 0; index < columns.size(); ++index) {
                Object[] column = columns.get(index);
                String filed = (String)column[0];
                if (QING_SORT.equals(filed)) {
                    row[index] = sort++;
                    continue;
                }
                Object value = rs.get(filed);
                row[index] = value = CustomControlUtil.translateCellDisplay(pluginInstance, filed, value, rs);
            }
            data.add(row);
        }
        designDataSet.setRows(data);
        return designDataSet;
    }

    private static void addColumnName(List<Object[]> data, List<Object[]> columns) {
        Object[] row = new Object[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            row[i] = columns.get(i)[1];
        }
        data.add(row);
    }

    public static DataSet filterResultDataSet(IDataSnapExecute pluginInstance, DataSet ds, Map<String, Object> filterParam) {
        return (DataSet)TdaCommonHelper.invokeMethod(pluginInstance, "filterResultDataSet", ds, filterParam);
    }

    public static List<Object[]> getColumnItems(IDataSnapExecute pluginInstance) {
        return (List)TdaCommonHelper.invokeMethod(pluginInstance, "getColumnItems", new Object[0]);
    }

    public static Object translateCellDisplay(IDataSnapExecute pluginInstance, String Field2, Object value, Row rs) {
        return TdaCommonHelper.invokeMethod(pluginInstance, "translateCellDisplay", Field2, value, rs);
    }

    private static void addOtherFilterFromMap(List<QFilter> qFilters, Map<String, Object> paramMap, String ... keys) {
        if (paramMap == null || keys == null) {
            return;
        }
        for (String key : keys) {
            Object value = paramMap.get(key);
            if (!EmptyUtil.isNoEmpty((Object)value)) continue;
            qFilters.add(new QFilter(key, "=", value));
        }
    }
}

