/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;

public class DraftBillCostDateHelper {
    public static final String YEAR = "year";
    public static final Integer YEAR_RANGE = 6;
    public static final String HALFYEAR = "half";
    public static final Integer HALFYEAR_RANGE = 12;
    public static final String SEASON = "season";
    public static final Integer SEASON_RANGE = 12;
    public static final String MONTH = "month";
    public static final Integer MONTH_RANGE = 12;
    public static final String DAY = "day";
    public static final Integer DAY_RANGE = 1;

    public static List<String> parseDateIncludeCur(Date queryDate, String termType) {
        return DraftBillCostDateHelper.parseDate(queryDate, termType, true);
    }

    private static List<String> parseDate(Date queryDate, String termType, boolean includeCur) {
        if (DAY.equals(termType)) {
            return Collections.singletonList(DateUtils.formatString((Date)queryDate, (String)"yyyyMMdd"));
        }
        int end = 12;
        if (YEAR.equals(termType)) {
            end = 6;
        }
        ArrayList<String> termList = new ArrayList<String>(end + 1);
        DateRangeEnum rangeEnum = DateRangeEnum.getEnumByValue(termType);
        int offset = 1;
        if (includeCur) {
            offset = 0;
        }
        end += offset;
        for (int i = offset; i < end; ++i) {
            String term = FinanceCostDateHelper.getDateCaption(queryDate, rangeEnum.getValue(), rangeEnum.getShortName(), i);
            termList.add(term);
        }
        return termList;
    }

    public static List<Object[]> getTermDateList(Date queryDate, String dateType) {
        ArrayList<Object[]> dateList = new ArrayList<Object[]>(16);
        int range = MONTH_RANGE;
        switch (dateType) {
            case "month": 
            case "season": 
            case "half": {
                break;
            }
            case "year": {
                range = YEAR_RANGE;
                break;
            }
            case "day": {
                range = DAY_RANGE;
                break;
            }
        }
        for (int i = --range; i >= 0; --i) {
            Date firstDate = FinanceCostDateHelper.getFirstDateByOffset(queryDate, dateType, i);
            Date endDate = FinanceCostDateHelper.getEndDateByOffset(queryDate, dateType, i);
            Object[] objects = new Object[]{firstDate, endDate, dateType};
            dateList.add(objects);
        }
        return dateList;
    }
}

