/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.SysParamHelper;

public class DraftBillLetterCreditDataHelper {
    private static final Log logger = LogFactory.getLog(DraftBillLetterCreditDataHelper.class);
    private static final String CHANGE_HISTORY_PROPS = "id, bizid, bizentity, billinfo_tag,creator, createtime, seqnumber, lastversion, applyentity, applyid, applybillno, reason, version, applycreate";
    private static final String SELECT_FIELDS = "id,org orgid,org.name as orgname,applydate,credittype,credittype.name credittypename,bizdate,isforward,forwarddays,currency,bank.bank_cate bankcate,bank.bank_cate.name bankcatename,bank.name bankname,amount originalamount, 0.0 as amount,noticebank,benefiterother,amountscalelow,amountscaleupper,billstatus,0.0 as originalbalance, 0.0 as balance,case when isforward = '1' then 1 else 0 end as farcount,case when isforward = '0' then 1 else 0 end as spotcount";
    private static final String BILLNO = "billno";
    private static final String CREDITNO = "creditno";
    private static final String CREDIT_STATUS = "creditstatus";
    private static final String MODIFYTIME = "modifytime";
    private static final String LETTER_CREDIT_FIELDS = "id, orgid,orgname,billno,creditno,creditstatus,applydate,credittype,credittypename,bizdate,isforward,forwarddays,currency,bankcate,bankcatename,bankname,originalamount,amount,noticebank,benefiterother,amountscalelow,amountscaleupper,billstatus,originalbalance,balance,farcount,spotcount";

    public static DataSet getBillBalanceDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId) {
        return DraftBillLetterCreditDataHelper.queryBillDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId, "lc_lettercredit", "balance");
    }

    public static DataSet getBillAccruedDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId) {
        return DraftBillLetterCreditDataHelper.queryBillDataSet(algoKey, orgIds, queryDate, baseCurrency, orgViewId, "lc_lettercredit", "accrued");
    }

    private static DataSet queryBillDataSet(String algoKey, List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId, String entity, String amountType) {
        DataSet result;
        Date nextTruncateDate = DateUtils.truncateDate((Date)DateUtils.getNextDay((Date)queryDate, (int)1));
        String cacheKey = DraftBillLetterCreditDataHelper.getCacheKey(orgViewId, queryDate, amountType);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            result = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> "balance".equals(amountType) ? DraftBillLetterCreditDataHelper.getAllBalanceViewData(algoKey, nextTruncateDate, baseCurrency, orgViewId, allOrgIds, entity) : DraftBillLetterCreditDataHelper.getAllAccruedViewData(algoKey, nextTruncateDate, baseCurrency, orgViewId, allOrgIds, entity));
            result = result.filter("orgid in orgIds", Collections.singletonMap("orgIds", orgIds));
        } else {
            result = "balance".equals(amountType) ? DraftBillLetterCreditDataHelper.getAllBalanceViewData(algoKey, nextTruncateDate, baseCurrency, orgViewId, orgIds, entity) : DraftBillLetterCreditDataHelper.getAllAccruedViewData(algoKey, nextTruncateDate, baseCurrency, orgViewId, orgIds, entity);
        }
        return result;
    }

    private static DataSet getAllBalanceViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> orgIds, String entity) {
        long start = System.currentTimeMillis();
        QFilter qFilter = new QFilter("org", "in", orgIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("bizdate", "<", (Object)queryDate);
        String select = "id,org orgid,org.name as orgname,applydate,credittype,credittype.name credittypename,bizdate,isforward,forwarddays,currency,bank.bank_cate bankcate,bank.bank_cate.name bankcatename,bank.name bankname,amount originalamount, 0.0 as amount,noticebank,benefiterother,amountscalelow,amountscaleupper,billstatus,0.0 as originalbalance, 0.0 as balance,case when isforward = '1' then 1 else 0 end as farcount,case when isforward = '0' then 1 else 0 end as spotcount,creditno,billno,creditstatus,modifytime";
        DataSet allViewData = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)select, (QFilter[])qFilter.toArray(), null);
        DataSet[] allViewDatas = allViewData.splitByFilter(new String[]{"creditstatus in ('done_repeal','done_close')"}, true);
        allViewData = allViewDatas[0].filter("modifytime >= queryDate", Collections.singletonMap("queryDate", queryDate)).union(allViewDatas[1]);
        allViewData = allViewData.removeFields(new String[]{MODIFYTIME});
        Set<Long> letterCreditIds = DecisionCommonHelper.getFieldValues(allViewData.copy(), "id", Long.class);
        DataSet applyDataSet = DraftBillLetterCreditDataHelper.getApplyDataSet(algoKey, queryDate, letterCreditIds);
        DataSet[] applyDataSets = applyDataSet.splitByFilter(new String[]{"true", "true"}, false);
        Set<Long> applyLetterCreditIds = DecisionCommonHelper.getFieldValues(applyDataSets[0], "lettercredit", Long.class);
        allViewData = allViewData.filter("id not in applyLetterCreditIds", Collections.singletonMap("applyLetterCreditIds", applyLetterCreditIds));
        allViewData = allViewData.union(applyDataSets[1].select(allViewData.getRowMeta().getFieldNames()));
        DataSet allArrivalDataSet = DraftBillLetterCreditDataHelper.getAllArrivalDataSet(algoKey, queryDate, baseCurrency, orgViewId, letterCreditIds);
        Set<Long> arrivalIds = DecisionCommonHelper.getFieldValues(allArrivalDataSet.copy(), "id", Long.class);
        DataSet loanContractDataSet = DraftBillLetterCreditDataHelper.getLoanContractDataSet(algoKey, queryDate, baseCurrency, orgViewId, arrivalIds);
        allArrivalDataSet = allArrivalDataSet.leftJoin(loanContractDataSet).on("id", "arrivalId").select(new String[]{"lettercredit", "arrpayamount", "loancontractamount"}).finish();
        allArrivalDataSet = allArrivalDataSet.updateFields(new String[]{"arrpayamount", "loancontractamount"}, new String[]{"case when arrpayamount is null then 0.0 else arrpayamount end", "case when loancontractamount is null then 0.0 else loancontractamount end"});
        allArrivalDataSet = allArrivalDataSet.groupBy(new String[]{"lettercredit"}).sum("arrpayamount").sum("loancontractamount").finish();
        allViewData = allViewData.updateField("amount", "originalamount");
        allViewData = AmountTransHelper.tranDataSetRate((DataSet)allViewData, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Collections.singleton("amount"), (Date)queryDate);
        allViewData = allViewData.leftJoin(allArrivalDataSet).on("id", "lettercredit").select(allViewData.getRowMeta().getFieldNames(), new String[]{"arrpayamount", "loancontractamount"}).finish();
        allViewData = allViewData.updateFields(new String[]{"arrpayamount", "loancontractamount"}, new String[]{"case when arrpayamount is null then 0.0 else arrpayamount end", "case when loancontractamount is null then 0.0 else loancontractamount end"});
        allViewData = allViewData.addField("amount - arrpayamount - loancontractamount", "originalbalance2");
        allViewData = allViewData.updateFields(new String[]{"originalbalance", "balance"}, new String[]{"originalbalance2", "originalbalance2"}).select(LETTER_CREDIT_FIELDS);
        logger.info("\u4fe1\u7528\u8bc1\u4f59\u989d\u53d6\u6570\uff0c\u7ec4\u7ec7\u89c6\u56fe\uff1a + " + orgViewId + " \u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) / 1000L);
        return allViewData.filter("balance > 0");
    }

    private static DataSet getApplyDataSet(String algoKey, Date queryDate, Set<Long> letterCreditIds) {
        QFilter applyQfilter = new QFilter("biztype", "=", (Object)"edit_card").and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("lettercredit", "in", letterCreditIds);
        String select = "id,org orgid,org.name as orgname,applydate,credittype,credittype.name credittypename,bizdate,isforward,forwarddays,currency,bank.bank_cate bankcate,bank.bank_cate.name bankcatename,bank.name bankname,amount originalamount, 0.0 as amount,noticebank,benefiterother,amountscalelow,amountscaleupper,billstatus,0.0 as originalbalance, 0.0 as balance,case when isforward = '1' then 1 else 0 end as farcount,case when isforward = '0' then 1 else 0 end as spotcount,lettercredit,lettercredit.creditstatus creditstatus, lettercredit.number creditno, lettercredit.billno billno, auditdate";
        DataSet queryApplyDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"lc_bizapply", (String)select, (QFilter[])applyQfilter.toArray(), null);
        DataSet[] dataSets = queryApplyDataSet.splitByFilter(new String[]{"true", "true", "true"}, false);
        Set<Long> changeLetterCreditIds = DecisionCommonHelper.getFieldValues(dataSets[1], "lettercredit", Long.class);
        DataSet firstChangeVersionSet = DraftBillLetterCreditDataHelper.getFirstChangeHistoryByBizId(changeLetterCreditIds, dataSets[0].getRowMeta());
        DataSet bankcateSet = dataSets[2].groupBy(new String[]{"lettercredit", "bankcate", "bankcatename"}).finish();
        firstChangeVersionSet = firstChangeVersionSet.leftJoin(bankcateSet).on("lettercredit", "lettercredit").select(firstChangeVersionSet.getRowMeta().getFieldNames(), new String[]{"bankcate", "bankcatename"}).finish().select(dataSets[0].getRowMeta().getFieldNames());
        DataSet allApplyDataSet = dataSets[0].union(firstChangeVersionSet);
        allApplyDataSet = allApplyDataSet.filter("applydate < queryDate", Collections.singletonMap("queryDate", queryDate));
        DataSet[] allApplyDataSets = allApplyDataSet.splitByFilter(new String[]{"true", "true"}, false);
        DataSet lastApplyDataSet = allApplyDataSets[0].groupBy(new String[]{"lettercredit"}).max("auditdate").finish();
        lastApplyDataSet = lastApplyDataSet.leftJoin(allApplyDataSets[1]).on("lettercredit", "lettercredit").on("auditdate", "auditdate").select(allApplyDataSets[1].getRowMeta().getFieldNames()).finish();
        return lastApplyDataSet.updateField("id", "lettercredit");
    }

    private static DataSet getAllArrivalDataSet(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, Set<Long> letterCreditIds) {
        QFilter arrivalQfilter = new QFilter("lettercredit", "in", letterCreditIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("arrivaldate", "<", (Object)queryDate);
        DataSet allArrivalDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"lc_arrival", (String)"id, lettercredit, entrys.arrpayamount arrpayamount, entrys.arrpaycurrency arrpaycurrency, entrys.realpaydate realpaydate", (QFilter[])arrivalQfilter.toArray(), null);
        allArrivalDataSet = allArrivalDataSet.filter("realpaydate is null or realpaydate < queryDate", Collections.singletonMap("queryDate", queryDate));
        allArrivalDataSet = allArrivalDataSet.select("id, lettercredit, arrpayamount, arrpaycurrency, realpaydate");
        allArrivalDataSet = AmountTransHelper.tranDataSetRate((DataSet)allArrivalDataSet, (Long)orgViewId, (Long)baseCurrency, (String)"arrpaycurrency", Collections.singleton("arrpayamount"), (Date)queryDate);
        allArrivalDataSet = allArrivalDataSet.groupBy(new String[]{"id"}).max("lettercredit").sum("arrpayamount").finish();
        return allArrivalDataSet;
    }

    private static DataSet getLoanContractDataSet(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, Set<Long> arrivalIds) {
        QFilter loancontractQfilter = new QFilter("tradefin_entry.e_tf_relatebillid", "in", arrivalIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("startdate", "<", (Object)queryDate);
        DataSet loanContractDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cfm_loancontractbill", (String)"id,tradefin_entry.e_tf_relatebillid arrivalId,amount loancontractamount,currency,currency.name,startdate,enddate,auditdate", (QFilter[])loancontractQfilter.toArray(), null);
        loanContractDataSet = loanContractDataSet.select("arrivalId,loancontractamount,currency,startdate");
        loanContractDataSet = AmountTransHelper.tranDataSetRate((DataSet)loanContractDataSet, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Collections.singleton("loancontractamount"), (Date)queryDate);
        loanContractDataSet = loanContractDataSet.groupBy(new String[]{"arrivalId"}).sum("loancontractamount").finish();
        return loanContractDataSet;
    }

    private static DataSet getAllAccruedViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> orgIds, String entity) {
        Date minMonthDate = DateUtils.getMinMonthDate((Date)DateUtils.getLastMonth((Date)queryDate, (int)11));
        QFilter qFilter = new QFilter("org", "in", orgIds).and("bizdate", "<", (Object)queryDate).and("bizdate", ">=", (Object)minMonthDate).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(CREDIT_STATUS, "not in", Collections.singletonList("done_repeal"));
        String select = "id,org orgid,org.name as orgname,applydate,credittype,credittype.name credittypename,bizdate,isforward,forwarddays,currency,bank.bank_cate bankcate,bank.bank_cate.name bankcatename,bank.name bankname,amount originalamount, 0.0 as amount,noticebank,benefiterother,amountscalelow,amountscaleupper,billstatus,0.0 as originalbalance, 0.0 as balance,case when isforward = '1' then 1 else 0 end as farcount,case when isforward = '0' then 1 else 0 end as spotcount,creditno,billno,creditstatus";
        DataSet allViewData = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)select, (QFilter[])qFilter.toArray(), null);
        allViewData = allViewData.updateField("amount", "originalamount");
        allViewData = AmountTransHelper.tranDataSetRate((DataSet)allViewData, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Collections.singleton("amount"), (Date)queryDate);
        return allViewData.select(LETTER_CREDIT_FIELDS);
    }

    private static DataSet getFirstChangeHistoryByBizId(Set<Long> bizIds, RowMeta rowMeta) {
        QFilter qFilter = new QFilter("bizid", "in", bizIds).and("bizentity", "=", (Object)"lc_lettercredit").and("seqnumber", "=", (Object)1);
        DynamicObject[] firstChangeVersions = TmcDataServiceHelper.load((String)"fcs_changehistory", (String)CHANGE_HISTORY_PROPS, (QFilter[])qFilter.toArray());
        RowMeta builderRowMeta = DraftBillLetterCreditDataHelper.getBuilderRowMeta(rowMeta);
        DataSetBuilder builder = Algo.create((String)"BuildLetterCreditChangeVersionSet").createDataSetBuilder(builderRowMeta);
        for (DynamicObject firstChangeVersion : firstChangeVersions) {
            try {
                DynamicObject historyBill = BillChangeHistoryHelper.deserializeBillInfo((DynamicObject)firstChangeVersion);
                builder.append(new Object[]{historyBill.getLong("id"), historyBill.getDynamicObject("org") == null ? 0L : historyBill.getDynamicObject("org").getLong("id"), historyBill.getDynamicObject("org") == null ? "" : historyBill.getDynamicObject("org").getString("name"), historyBill.getDate("applydate"), historyBill.getDynamicObject("credittype") == null ? 0L : historyBill.getDynamicObject("credittype").getLong("id"), historyBill.getDynamicObject("credittype") == null ? "" : historyBill.getDynamicObject("credittype").getString("name"), historyBill.getDate("bizdate"), historyBill.getBoolean("isforward"), historyBill.getInt("forwarddays"), historyBill.getDynamicObject("currency") == null ? 0L : historyBill.getDynamicObject("currency").getLong("id"), historyBill.getDynamicObject("bank") == null ? "" : historyBill.getDynamicObject("bank").getString("name"), historyBill.getBigDecimal("amount"), new BigDecimal("0.0"), historyBill.getString("noticebank"), historyBill.getString("benefiterother"), historyBill.getBigDecimal("amountscalelow"), historyBill.getBigDecimal("amountscaleupper"), historyBill.getString("billstatus"), new BigDecimal("0.0"), new BigDecimal("0.0"), historyBill.getBoolean("isforward") ? 1 : 0, historyBill.getBoolean("isforward") ? 0 : 1, historyBill.getLong("id"), historyBill.getString(CREDIT_STATUS), historyBill.getString(CREDITNO), historyBill.getString(BILLNO), historyBill.getDate("auditdate")});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DataSet buildSet = builder.build();
        return buildSet;
    }

    private static RowMeta getBuilderRowMeta(RowMeta rowMeta) {
        int length = rowMeta.getFieldNames().length;
        ArrayList<String> fieldNames = new ArrayList<String>(length);
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(length);
        for (int i = 0; i < length; ++i) {
            String fieldName = rowMeta.getFieldName(i);
            if ("bankcate".equals(fieldName) || "bankcatename".equals(fieldName)) continue;
            fieldNames.add(rowMeta.getFieldName(i));
            dataTypes.add(rowMeta.getDataType(i));
        }
        RowMeta builderRowMeta = RowMetaFactory.createRowMeta((String[])fieldNames.toArray(new String[0]), (DataType[])dataTypes.toArray(new DataType[0]));
        return builderRowMeta;
    }

    private static String getCacheKey(Long orgViewId, Date queryDate, String amountType) {
        return "LetterDataHelper-" + amountType + "-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyyMMdd");
    }
}

