/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.CcrTermDateHelper;

public class FinanceCostDateHelper {
    public static final String YEAR = "year";
    public static final Integer YEAR_RANGE = 6;
    public static final String HALFYEAR = "half";
    public static final Integer HALFYEAR_RANGE = 12;
    public static final String SEASON = "season";
    public static final Integer SEASON_RANGE = 12;
    public static final String MONTH = "month";
    public static final Integer MONTH_RANGE = 12;
    public static final String DAY = "day";

    public static String[] parseNewDateType(Date queryDate) {
        String[] array = new String[42];
        int year = DateUtils.getYear((Date)queryDate);
        int month = DateUtils.getMonth((Date)queryDate);
        int season = (month - 1) / 3 + 1;
        int halfYear = month <= 6 ? 1 : 2;
        int yearIndex = 0;
        int monthIndex = 0;
        int seasonIndex = 0;
        int halfYearIndex = 0;
        int currYear = year;
        int oneIndex = 1;
        for (int i = 41; i >= 0; --i) {
            boolean isReset;
            boolean bl = isReset = i == 29 || i == 17;
            if (isReset) {
                currYear = year;
                oneIndex = 1;
            }
            if (i >= 30 && i <= 41) {
                int currMonth;
                if ((currMonth = month - monthIndex++) <= 0) {
                    currMonth += 12;
                }
                if (currMonth == 12 && monthIndex > 1) {
                    currYear = year - oneIndex++;
                }
                array[i] = String.format("%s%02d", currYear, currMonth);
                continue;
            }
            if (i >= 18 && i <= 29) {
                int currSeason;
                for (currSeason = season - seasonIndex++; currSeason <= 0; currSeason += 4) {
                }
                if (currSeason == 4 && seasonIndex > 1) {
                    currYear = year - oneIndex++;
                }
                array[i] = String.format("%1$sQ%2$s", currYear, currSeason);
                continue;
            }
            if (i >= 6 && i <= 17) {
                int currHalfYear;
                for (currHalfYear = halfYear - halfYearIndex++; currHalfYear <= 0; currHalfYear += 2) {
                }
                if (currHalfYear == 2 && halfYearIndex > 1) {
                    currYear = year - oneIndex++;
                }
                array[i] = currHalfYear == 1 ? currYear + "H1" : currYear + "H2";
                continue;
            }
            array[i] = "" + (year - yearIndex++);
        }
        return array;
    }

    public static Date getNewDate(Date queryDate) {
        Date currentDate = DateUtils.getCurrentDate();
        return currentDate.compareTo(queryDate) > 0 ? queryDate : DateUtils.getLastDay((Date)currentDate, (int)1);
    }

    public static String getDateCaption(Date queryDate, String dateRange, String dateRangeShortName, int diff) {
        Date offsetDate = DAY.equals(dateRange) ? queryDate : FinanceCostDateHelper.getFirstDateByOffset(queryDate, dateRange, diff);
        String yyyyMMdd = DateUtils.formatString((Date)offsetDate, (String)"yyyy-MM-dd");
        String[] dateSplit = yyyyMMdd.split("-");
        String year = dateSplit[0];
        int month = Integer.parseInt(dateSplit[1]);
        String caption = "";
        switch (dateRange) {
            case "month": {
                caption = year + dateSplit[1];
                break;
            }
            case "season": {
                caption = year + dateRangeShortName + DateUtils.getSeason((int)month);
                break;
            }
            case "half": {
                caption = year + dateRangeShortName + (month < 7 ? 1 : 2);
                break;
            }
            case "year": {
                caption = year;
                break;
            }
            case "day": {
                caption = DateUtils.formatString((Date)offsetDate, (String)"yyyyMMdd");
                break;
            }
        }
        return caption;
    }

    public static Date getFirstOrEndDateBySeasonOffset(Date queryDate, int seasonOffset, boolean isFirstMonth, boolean isFirstDate) {
        return FinanceCostDateHelper.getFirstOrEndDateByDimension(queryDate, seasonOffset, isFirstMonth, isFirstDate, 3);
    }

    public static Date getFirstOrEndDateByHalfYearOffset(Date queryDate, int halfOffset, boolean isFirstMonth, boolean isFirstDate) {
        return FinanceCostDateHelper.getFirstOrEndDateByDimension(queryDate, halfOffset, isFirstMonth, isFirstDate, 6);
    }

    public static Date getFirstOrEndDateByYearOffset(Date queryDate, int yearOffset, boolean isFirstMonth, boolean isFirstDate) {
        return FinanceCostDateHelper.getFirstOrEndDateByDimension(queryDate, yearOffset, isFirstMonth, isFirstDate, 12);
    }

    private static Date getFirstOrEndDateByDimension(Date queryDate, int offset, boolean isFirstMonth, boolean isFirstDate, int dimensionOffset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(queryDate);
        int firstMonthIndexForDimension = calendar.get(2) / dimensionOffset * dimensionOffset;
        int monthOffset = firstMonthIndexForDimension + offset * dimensionOffset;
        if (isFirstMonth) {
            calendar.set(2, monthOffset);
        } else {
            calendar.set(2, monthOffset + dimensionOffset - 1);
        }
        if (isFirstDate) {
            calendar.set(5, calendar.getActualMinimum(5));
        } else {
            calendar.set(5, calendar.getActualMaximum(5));
        }
        return calendar.getTime();
    }

    public static List<Object[]> getQueryDateList(Date queryDate, String dateType) {
        ArrayList<Object[]> dateList = new ArrayList<Object[]>(16);
        int range = MONTH_RANGE;
        switch (dateType) {
            case "month": 
            case "season": 
            case "half": {
                break;
            }
            case "year": {
                range = YEAR_RANGE;
                break;
            }
        }
        Date begin = new Date();
        for (int i = range - 1; i >= 1; --i) {
            Date firstDate = FinanceCostDateHelper.getFirstDateByOffset(queryDate, dateType, i);
            if (i == range - 1) {
                begin = FinanceCostDateHelper.getFirstDateByOffset(firstDate, YEAR, 0);
            }
            Date endDate = FinanceCostDateHelper.getEndDateByOffset(queryDate, dateType, i);
            if (DateUtils.getYear((Date)begin) != DateUtils.getYear((Date)endDate)) {
                begin = firstDate;
            }
            Object[] objects = new Object[]{begin, endDate, dateType};
            dateList.add(objects);
        }
        Date currentYearBeginDate = DateUtils.getFirstYearDate((Date)queryDate);
        dateList.add(new Object[]{currentYearBeginDate, queryDate, dateType});
        return dateList;
    }

    public static List<Object[]> getInvestQueryDateList(Date queryDate, String customType) {
        ArrayList<Object[]> dateList = new ArrayList<Object[]>(16);
        int range = MONTH_RANGE;
        switch (customType) {
            case "month": 
            case "season": 
            case "half": {
                break;
            }
            case "year": {
                range = YEAR_RANGE;
                break;
            }
        }
        for (int i = range - 1; i >= 0; --i) {
            Date firstDate = FinanceCostDateHelper.getFirstDateByOffset(queryDate, customType, i);
            Date endDate = FinanceCostDateHelper.getEndDateByOffset(queryDate, customType, i);
            Object[] objects = new Object[]{firstDate, endDate, customType};
            dateList.add(objects);
        }
        return dateList;
    }

    private static List<Object[]> getConcentrationQueryDateList(Date queryDate, String customType) {
        ArrayList<Object[]> dateList = new ArrayList<Object[]>(16);
        int range = 1;
        switch (customType) {
            case "month": {
                range = CcrTermDateHelper.getMonthEndOffset(queryDate);
                break;
            }
            case "season": {
                range = CcrTermDateHelper.getSeasonEndOffset(queryDate);
                break;
            }
            case "year": {
                range = 2;
                break;
            }
        }
        DateRangeEnum rangeEnum = DateRangeEnum.getEnumByValue(customType);
        for (int i = range - 1; i >= 0; --i) {
            Date firstDate = FinanceCostDateHelper.getFirstDateByOffset(queryDate, customType, i);
            Date endDate = i == 0 ? queryDate : FinanceCostDateHelper.getEndDateByOffset(queryDate, customType, i);
            String term = FinanceCostDateHelper.getDateCaption(queryDate, rangeEnum.getValue(), rangeEnum.getShortName(), i);
            Object[] objects = new Object[]{firstDate, endDate, customType, DateUtils.getDiffDays((Date)firstDate, (Date)endDate), term};
            dateList.add(objects);
        }
        return dateList;
    }

    public static List<Object[]> getAllQueryDateList(Date queryDate) {
        ArrayList<Object[]> queryDateList = new ArrayList<Object[]>(64);
        queryDateList.addAll(FinanceCostDateHelper.getQueryDateList(queryDate, YEAR));
        queryDateList.addAll(FinanceCostDateHelper.getQueryDateList(queryDate, SEASON));
        queryDateList.addAll(FinanceCostDateHelper.getQueryDateList(queryDate, MONTH));
        return queryDateList;
    }

    public static List<Object[]> getAllInvestQueryDateList(Date queryDate) {
        ArrayList<Object[]> queryDateList = new ArrayList<Object[]>(64);
        queryDateList.addAll(FinanceCostDateHelper.getInvestQueryDateList(queryDate, YEAR));
        queryDateList.addAll(FinanceCostDateHelper.getInvestQueryDateList(queryDate, HALFYEAR));
        queryDateList.addAll(FinanceCostDateHelper.getInvestQueryDateList(queryDate, SEASON));
        queryDateList.addAll(FinanceCostDateHelper.getInvestQueryDateList(queryDate, MONTH));
        return queryDateList;
    }

    public static List<Object[]> getAllConcentrationQueryDateList(Date queryDate) {
        ArrayList<Object[]> queryDateList = new ArrayList<Object[]>(64);
        queryDateList.addAll(FinanceCostDateHelper.getConcentrationQueryDateList(queryDate, YEAR));
        queryDateList.addAll(FinanceCostDateHelper.getConcentrationQueryDateList(queryDate, SEASON));
        queryDateList.addAll(FinanceCostDateHelper.getConcentrationQueryDateList(queryDate, MONTH));
        return queryDateList;
    }

    public static List<Object[]> getMothCcrQueryDateList(Date queryDate) {
        ArrayList<Object[]> dateList = new ArrayList<Object[]>(12);
        int range = 12;
        DateRangeEnum rangeEnum = DateRangeEnum.MONTH;
        String dateType = DateRangeEnum.MONTH.getValue();
        for (int i = range; i > 0; --i) {
            Date firstDate = FinanceCostDateHelper.getFirstDateByOffset(queryDate, dateType, i);
            Date endDate = FinanceCostDateHelper.getEndDateByOffset(queryDate, dateType, i);
            String term = FinanceCostDateHelper.getDateCaption(queryDate, rangeEnum.getValue(), rangeEnum.getShortName(), i);
            Object[] objects = new Object[]{firstDate, endDate, dateType, DateUtils.getDiffDays((Date)firstDate, (Date)endDate), term};
            dateList.add(objects);
        }
        return dateList;
    }

    public static Date getFirstDateByOffset(Date queryDate, String dateType, int offset) {
        Date firstDate = queryDate;
        switch (dateType) {
            case "month": {
                firstDate = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)(-offset));
                break;
            }
            case "season": {
                firstDate = FinanceCostDateHelper.getFirstOrEndDateBySeasonOffset(queryDate, -offset, true, true);
                break;
            }
            case "half": {
                firstDate = FinanceCostDateHelper.getFirstOrEndDateByHalfYearOffset(queryDate, -offset, true, true);
                break;
            }
            case "year": {
                firstDate = FinanceCostDateHelper.getFirstOrEndDateByYearOffset(queryDate, -offset, true, true);
                break;
            }
        }
        return firstDate;
    }

    public static Date getEndDateByOffset(Date queryDate, String dateType, int offset) {
        Date endDate = queryDate;
        switch (dateType) {
            case "month": {
                endDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)(-offset));
                break;
            }
            case "season": {
                endDate = FinanceCostDateHelper.getFirstOrEndDateBySeasonOffset(queryDate, -offset, false, false);
                break;
            }
            case "half": {
                endDate = FinanceCostDateHelper.getFirstOrEndDateByHalfYearOffset(queryDate, -offset, false, false);
                break;
            }
            case "year": {
                endDate = FinanceCostDateHelper.getFirstOrEndDateByYearOffset(queryDate, -offset, false, false);
                break;
            }
        }
        return endDate;
    }
}

