/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.tda.common.helper.AbstractFinanceFieldConvert;

public class FinanceFieldBankConvert
extends AbstractFinanceFieldConvert {
    protected DataSet finOrgSet;

    public FinanceFieldBankConvert(DataSet source, Date queryDate) {
        super(source, queryDate);
        DataSet finorginfos;
        HashSet<Long> creditors = new HashSet<Long>(16);
        Iterator iterator = source.copy().select("creditor").groupBy(new String[]{"creditor"}).finish().iterator();
        while (iterator.hasNext()) {
            creditors.add(((Row)iterator.next()).getLong("creditor"));
        }
        QFilter qFilter = new QFilter("id", "in", creditors);
        this.finOrgSet = finorginfos = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertOutGroup"), (String)"bd_finorginfo", (String)"id,org.id as finorgid,bank_cate.id as bankcate,bank_cate.name as bankcatename,finorgtype.type as banktype", (QFilter[])qFilter.toArray(), null);
    }

    @Override
    protected DataSet covertSourceType(DataSet source) {
        return source.updateField("sourcetype", "0");
    }

    @Override
    protected DataSet covertFinanceType(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertOutGroup(DataSet source) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        source = source.leftJoin(this.finOrgSet.copy()).on("creditor", "id").select(fieldNames, new String[]{"finorgid", "banktype"}).finish().updateField("finorgid", "case when finorgid is null then 0 else finorgid end");
        source = source.addField("case when creditortype = 'bank' or (creditortype = 'finorg' and finorgid = 0) then 1 else 0 end", "isoutgroup");
        source = source.updateField("creditorinnerorg", "case when  finorgid = 0 then 0 else finorgid end");
        source = source.updateField("creditortype", "case when creditorinnerorg > 0 and banktype = '3' then 'fincom' else creditortype end");
        source = source.removeFields(new String[]{"finorgid", "banktype"});
        return source;
    }

    @Override
    protected DataSet covertCreditortype(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertBankCate(DataSet source) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        source = source.leftJoin(this.finOrgSet.copy()).on("creditor", "id").select(fieldNames, new String[]{"bankcate", "bankcatename"}).finish().updateField("bankcate", "case when bankcate is null then 0 else bankcate end");
        source = source.updateField("bankcate", "case when creditortype = 'bank'  then bankcate else 0 end");
        return source;
    }

    @Override
    protected DataSet covertRegion(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertDrawAmount(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertStartIntDate(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertInterestType(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertBasis(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertFinanceMode(DataSet source) {
        source = source.addField("case when creditortype = 'settlecenter' then 1 else 0 end", "financemode");
        return source;
    }

    @Override
    protected DataSet covertResidueTerm(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertTextCreditor(DataSet source) {
        return source;
    }

    @Override
    protected DataSet afterConvert(DataSet source) {
        if (this.containZeroRate) {
            return source;
        }
        return source.filter("loanrate > 0");
    }
}

