/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.AbstractFinanceFieldConvert;

public class FinanceFieldBondConvert
extends AbstractFinanceFieldConvert {
    public FinanceFieldBondConvert(DataSet source, Date queryDate) {
        super(source, queryDate);
    }

    @Override
    protected DataSet covertSourceType(DataSet source) {
        return source.updateField("sourcetype", "1");
    }

    @Override
    protected DataSet covertFinanceType(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertOutGroup(DataSet source) {
        source = source.addField("1", "isoutgroup");
        return source;
    }

    @Override
    protected DataSet covertBankCate(DataSet source) {
        source = source.addField("0L", "bankcate");
        source = source.addField("''", "bankcatename");
        return source;
    }

    @Override
    protected DataSet covertRepayedAmount(DataSet source) {
        String[] fieldNames = source.getRowMeta().getFieldNames();
        QFilter qFilter = new QFilter("loans.e_loanbill", "in", (Object)this.ids);
        qFilter.and("isbuyback", "=", (Object)false);
        qFilter.and("bizdate", "<=", (Object)this.queryDate);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet repaymentBills = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertRepayedAmount"), (String)"cfm_repaymentbill", (String)"id,loans.e_loanbill as loanbillid,loans.e_repayamount as erepayamount", (QFilter[])qFilter.toArray(), null);
        repaymentBills = repaymentBills.select("loanbillid,erepayamount").groupBy(new String[]{"loanbillid"}).sum("erepayamount").finish();
        source = source.leftJoin(repaymentBills).on("id", "loanbillid").select(fieldNames, new String[]{"erepayamount"}).finish().updateField("repayedamount", "case when erepayamount is null then 0 else erepayamount end");
        source = source.removeFields(new String[]{"erepayamount"});
        return source;
    }

    @Override
    protected DataSet covertRegion(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertDrawAmount(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertStartIntDate(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertExpireDate(DataSet source) {
        source = super.covertExpireDate(source);
        source = source.updateField("expiredate", "case when perpetualbond then null else expiredate end");
        return source;
    }

    @Override
    protected DataSet covertTerm(DataSet source) {
        final RowMeta rowMeta = source.getRowMeta();
        source = source.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(20);
                for (String fieldName : rowMeta.getFieldNames()) {
                    if ("term".equals(fieldName)) {
                        Boolean perpetualbond = row.getBoolean("perpetualbond");
                        if (perpetualbond.booleanValue()) {
                            rowInfo.add("");
                            continue;
                        }
                        String term = DateUtils.getDiff_ymd((Date)row.getDate("startintdate"), (Date)row.getDate("expiredate"));
                        rowInfo.add(term);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        return source;
    }

    @Override
    protected DataSet covertInterestType(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertBasis(DataSet source) {
        return source;
    }

    @Override
    protected DataSet covertFinanceMode(DataSet source) {
        source = source.addField("1", "financemode");
        return source;
    }

    @Override
    protected DataSet covertResidueTerm(DataSet source) {
        final RowMeta rowMeta = source.getRowMeta();
        source = source.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(20);
                for (String fieldName : rowMeta.getFieldNames()) {
                    if ("residueterm".equals(fieldName)) {
                        Boolean perpetualbond = row.getBoolean("perpetualbond");
                        if (perpetualbond.booleanValue()) {
                            rowInfo.add("");
                            continue;
                        }
                        String residueterm = DateUtils.getDiff_ymd((Date)FinanceFieldBondConvert.this.queryDate, (Date)row.getDate("expiredate"));
                        rowInfo.add(residueterm);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        return source;
    }

    @Override
    protected DataSet covertCreditortype(DataSet source) {
        source = source.updateField("creditortype", "''");
        return source;
    }

    @Override
    protected DataSet covertTextCreditor(DataSet source) {
        source = source.updateField("creditortype", "''");
        return source;
    }

    @Override
    protected DataSet afterConvert(DataSet source) {
        String sic = "id,investor_entry.id as entryid,investor_entry.e_investortype as e_investortype,investor_entry.e_investorid as e_investorid,investor_entry.e_investorname as e_investorname,investor_entry.e_investamount as e_investamount,investor_entry.e_isselfsubscribe as e_isselfsubscribe";
        DataSet investEntry = QueryServiceHelper.queryDataSet((String)"FinanceFieldBondConvert.getInvestEntry", (String)"cfm_loanbill_bond", (String)sic, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.ids), new QFilter("investor_entry", "is not null", null)}, null);
        QFilter buyBackFilter = new QFilter("loans.e_loanbill", "in", (Object)this.ids);
        buyBackFilter.and("isbuyback", "=", (Object)true);
        buyBackFilter.and("bizdate", "<=", (Object)this.queryDate);
        buyBackFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet buyBackBills = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertRepayedAmount"), (String)"cfm_repaymentbill", (String)"loans.buyback_entry.e_investentryid as e_investentryid,loans.buyback_entry.e_buybackamt as e_buybackamt", (QFilter[])buyBackFilter.toArray(), null);
        buyBackBills = buyBackBills.groupBy(new String[]{"e_investentryid"}).sum("e_buybackamt").finish();
        investEntry = investEntry.leftJoin(buyBackBills).on("entryid", "e_investentryid").select(new String[]{"id", "entryid", "e_investortype", "e_investorid", "e_investorname", "e_investamount", "e_isselfsubscribe", "e_buybackamt"}).finish().updateField("e_buybackamt", "case when e_buybackamt is null then 0 else e_buybackamt end");
        DataSet[] copyDataSet = DataSetHelper.copy((DataSet)investEntry, (int)3);
        investEntry = copyDataSet[0].leftJoin(copyDataSet[1].groupBy(new String[]{"id"}).sum("e_buybackamt", "totale_buybackamt").finish()).on("id", "id").select(new String[]{"id", "entryid", "e_investortype", "e_investorid", "e_investorname", "e_investamount", "e_isselfsubscribe", "e_buybackamt"}, new String[]{"totale_buybackamt"}).finish();
        HashSet<Long> creditors = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Row row : copyDataSet[2].select("id,e_investorid")) {
            creditors.add(row.getLong("e_investorid"));
            entryIds.add(row.getLong("id"));
        }
        QFilter qFilter = new QFilter("id", "in", creditors);
        DataSet finorginfo = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "covertOutGroup"), (String)"bd_finorginfo", (String)"id,org.id as finorgid,bank_cate.id as e_bankcate,bank_cate.name as e_bankcatename,finorgtype.type as finorgtype", (QFilter[])qFilter.toArray(), null);
        String[] fieldNames1 = investEntry.getRowMeta().getFieldNames();
        investEntry = investEntry.leftJoin(finorginfo).on("e_investorid", "id").select(fieldNames1, new String[]{"finorgid", "e_bankcate", "e_bankcatename", "finorgtype"}).finish().updateField("finorgid", "case when finorgid is null then 0L else finorgid end").updateField("e_bankcate", "case when e_bankcate is null then 0L else e_bankcate end");
        DataSet[] splitSource = DataSetHelper.splitByFilter((DataSet)source, (String[])new String[]{"id in entryIds"}, Collections.singletonMap("entryIds", entryIds), (boolean)true);
        DataSet entrySource = splitSource[0];
        DataSet notEntrySource = splitSource[1];
        String[] sourceField = source.getRowMeta().getFieldNames();
        DataSet investSource = entrySource.leftJoin(investEntry).on("id", "id").select(sourceField, "finorgid,e_bankcate,e_bankcatename,e_investortype,e_investamount,e_isselfsubscribe,e_investorname,finorgtype,e_buybackamt,totale_buybackamt".split(",")).finish();
        investSource = investSource.updateField("bankcate", "case when e_bankcate is null then bankcate else e_bankcate end");
        investSource = investSource.updateField("bankcatename", "case when e_bankcatename is null then bankcatename else e_bankcatename end");
        investSource = investSource.updateField("e_buybackamt", "case when e_buybackamt is null then 0 else e_buybackamt end");
        investSource = investSource.updateField("totale_buybackamt", "case when totale_buybackamt is null then 0 else totale_buybackamt end");
        investSource = investSource.updateField("textcreditor", "e_investorname");
        investSource = investSource.updateField("creditorinnerorg", "case when  finorgid is null then 0L else finorgid end");
        investSource = investSource.updateField("repayedamount", "case when e_investamount is null then 0 else repayedamount * ((e_investamount-e_buybackamt) / (drawamount-totale_buybackamt)) end");
        investSource = investSource.updateField("repayamount", "e_investamount-e_buybackamt - repayedamount");
        investSource = investSource.updateField("drawamount", "case when e_investamount is null then drawamount else e_investamount end");
        investSource = investSource.updateField("creditortype", "case when creditorinnerorg > 0 and finorgtype = '3' then 'fincom' else creditortype end");
        DataSet groupByAmount = investSource.copy().groupBy(new String[]{"id", "totale_buybackamt"}).sum("e_investamount").finish();
        entrySource = entrySource.leftJoin(groupByAmount).on("id", "id").select(sourceField, new String[]{"e_investamount", "totale_buybackamt"}).finish();
        entrySource = entrySource.addField("case when e_investamount is null then drawamount else drawamount-e_investamount end", "tempdrawamount");
        entrySource = entrySource.updateField("repayedamount", "case when tempdrawamount is null then repayedamount else repayedamount * (tempdrawamount / (drawamount-totale_buybackamt)) end");
        entrySource = entrySource.updateField("drawamount", "tempdrawamount");
        entrySource = entrySource.updateField("repayamount", "drawamount - repayedamount");
        notEntrySource = notEntrySource.updateField("repayamount", "drawamount - repayedamount");
        source = notEntrySource.union(new DataSet[]{entrySource.select(sourceField), investSource.filter("e_isselfsubscribe = false").select(sourceField)});
        if (this.containZeroRate) {
            return source;
        }
        return source.filter("loanrate > 0");
    }
}

