/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.DecisionCommonHelper;

public class LiquidityDataCheckHelper {
    public static final String[] INDICATOR_FIELDS = new String[]{"assetsdebtrate", "intdebtrate", "quickratio", "flowratio", "intcoverratio", "duethreemonthamt", "fundduethreemthratio", "duethreemonthratio"};

    public static boolean checkCurAssetsDebtRate(Long orgViewId, Long orgId, Date queryDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(queryDate);
        int year = c.get(1);
        int month = c.get(2);
        if (month == 0) {
            --year;
            month = 12;
        }
        QFilter qFilter = new QFilter("orgview.id", "=", (Object)orgViewId);
        qFilter.and("org.id", "=", (Object)orgId);
        qFilter.and("accountyear", "=", (Object)year);
        qFilter.and("accountperiod", "=", (Object)month);
        DynamicObject liquidityData = BusinessDataServiceHelper.loadSingle((String)"tda_liquiditybill", (String)"id,assetsamt,debtamt", (QFilter[])qFilter.toArray());
        return liquidityData != null && liquidityData.getBigDecimal("assetsamt") != null && liquidityData.getBigDecimal("assetsamt").compareTo(BigDecimal.ZERO) > 0 && liquidityData.getBigDecimal("debtamt") != null && liquidityData.getBigDecimal("debtamt").compareTo(BigDecimal.ZERO) > 0;
    }

    public static Date getRealQueryDate(Map<String, Object> paramMap) {
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Object date = paramMap.get("querydate");
        Date queryDate = date == null ? DateUtils.getCurrentDate() : (date instanceof String ? DateUtils.stringToDate((String)((String)date), (String)"yyyy-MM-dd HH:mm:ss") : (Date)date);
        queryDate = DateUtils.truncateDate((Date)queryDate);
        queryDate = DecisionCommonHelper.fixQueryDate(queryDate);
        if (LiquidityDataCheckHelper.checkCurAssetsDebtRate(orgViewId, orgId, queryDate)) {
            return queryDate;
        }
        Date lastMonthDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-1);
        if (LiquidityDataCheckHelper.checkCurAssetsDebtRate(orgViewId, orgId, lastMonthDate)) {
            return lastMonthDate;
        }
        Date lastTwoMonthDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-2);
        if (LiquidityDataCheckHelper.checkCurAssetsDebtRate(orgViewId, orgId, lastTwoMonthDate)) {
            return lastTwoMonthDate;
        }
        return queryDate;
    }

    public static boolean isEmptyRow(Row row) {
        for (String col : INDICATOR_FIELDS) {
            BigDecimal decimal = row.getBigDecimal(col);
            if (decimal == null || BigDecimal.ZERO.compareTo(decimal) == 0) continue;
            return false;
        }
        return true;
    }
}

