/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.model.RepayPlan;
import kd.tmc.tda.common.model.RepayPlanRow;

public class RepayPlanHelper {
    public static DataSet handleRepayPlan(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, DataSet ds) {
        return RepayPlanHelper.handleRepayPlan(algoKey, queryDate, baseCurrency, orgViewId, ds, "cfm_loanbill");
    }

    public static DataSet handleRepayPlan(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, DataSet ds, String entityName) {
        ds = ds.removeFields(new String[]{"residueterm"});
        DataSet[] dataSets = DataSetHelper.copy((DataSet)ds, (int)3);
        ds = dataSets[0];
        Set<Long> ids = DecisionCommonHelper.getFieldValues(dataSets[1], "id", Long.class);
        DataSet repayPlanEntry = RepayPlanHelper.queryRepayPlan(algoKey, entityName, new QFilter[]{new QFilter("id", "in", ids)});
        DataSet entryDs = dataSets[2].leftJoin(repayPlanEntry).on("id", "id").select(new String[]{"id", "expiredate", "repayamountsum", "perpetualbond", "currency"}, new String[]{"exrepaymentdate", "exdrawamount"}).finish();
        entryDs = RepayPlanHelper.tranDataSetRate(entryDs, Collections.singleton("exdrawamount"), queryDate, orgViewId, baseCurrency);
        Map<Long, RepayPlan> repayPlanMap = RepayPlanHelper.repayPlanMap(entryDs, queryDate);
        DataSet result = RepayPlanHelper.buildDataSet(algoKey, repayPlanEntry.getRowMeta(), repayPlanMap);
        result = result.leftJoin(ds).on("id", "id").select(new String[]{"residueterm", "exrepaymentdate", "exdrawamount"}, ds.getRowMeta().getFieldNames()).finish();
        result = result.updateField("repayamount", "case when repayamountsum=0 then 0.0 else exdrawamount*repayamount/repayamountsum end");
        return result;
    }

    private static DataSet queryRepayPlan(String algoKey, String entityName, QFilter[] qFilters) {
        if ("cfm_loanbill".equals(entityName)) {
            String sic = "id, '' residueterm,repayplan_entry.exrepaymentdate as exrepaymentdate,repayplan_entry.exdrawamount as exdrawamount";
            return QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)sic, (QFilter[])qFilters, (String)"repayplan_entry.exrepaymentdate DESC");
        }
        if ("fl_leasecontractbill".equals(entityName)) {
            String sic = "id, '' residueterm,entry_rentplan.paydate as exrepaymentdate,entry_rentplan.principal as exdrawamount";
            return QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)sic, (QFilter[])qFilters, (String)"entry_rentplan.paydate DESC");
        }
        String sic = "id, '' residueterm,payplanentryentity.planpaydate as exrepaymentdate,payplanentryentity.rent as exdrawamount";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)sic, (QFilter[])qFilters, (String)"payplanentryentity.planpaydate DESC");
    }

    private static DataSet tranDataSetRate(DataSet ds, Set<String> transFields, Date queryDate, Long orgViewId, Long baseCurrency) {
        return AmountTransHelper.tranDataSetRate((DataSet)ds, (Long)orgViewId, (Long)baseCurrency, (String)"currency", transFields, (Date)queryDate);
    }

    private static Map<Long, RepayPlan> repayPlanMap(DataSet ds, Date queryDate) {
        HashMap<Long, RepayPlan> repayPlanMap = new HashMap<Long, RepayPlan>(1024);
        for (Row row : ds) {
            Long id = row.getLong("id");
            BigDecimal exdrawAmount = row.getBigDecimal("exdrawamount");
            BigDecimal repayAmount = row.getBigDecimal("repayamountsum");
            Date exrepaymentDate = row.getDate("exrepaymentdate");
            Date expireDate = row.getDate("expiredate");
            if (exrepaymentDate == null) {
                Date date = exrepaymentDate = expireDate == null ? queryDate : expireDate;
            }
            if (exdrawAmount == null) {
                exdrawAmount = repayAmount;
            }
            RepayPlanRow repayPlanRow = new RepayPlanRow(exdrawAmount, exrepaymentDate, queryDate);
            RepayPlan repayPlan = (RepayPlan)repayPlanMap.get(id);
            if (repayPlan == null) {
                repayPlan = new RepayPlan(id, queryDate, repayAmount == null ? BigDecimal.ZERO : repayAmount, row.getBoolean("perpetualbond"), expireDate);
                repayPlanMap.put(id, repayPlan);
            }
            repayPlan.add(repayPlanRow);
        }
        return repayPlanMap;
    }

    private static DataSet buildDataSet(String algoKey, RowMeta rowMeta, Map<Long, RepayPlan> repayPlanMap) {
        if (rowMeta == null) {
            rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"id", "residueterm", "exrepaymentdate", "exdrawamount"}, (DataType[])new DataType[]{DataType.LongType, DataType.StringType, DataType.DateType, DataType.BigDecimalType});
        }
        DataSetBuilder builder = Algo.create((String)(algoKey + ".RepayPlan")).createDataSetBuilder(rowMeta);
        int len = rowMeta.getFieldNames().length;
        for (Map.Entry<Long, RepayPlan> entry : repayPlanMap.entrySet()) {
            RepayPlan plan = entry.getValue().build();
            List<RepayPlanRow> repayPlanRows = plan.getRepayPlanRows();
            for (RepayPlanRow planRow : repayPlanRows) {
                ArrayList<Object> appendRow = new ArrayList<Object>(len);
                appendRow.add(plan.getId());
                appendRow.add(planRow.getResidueterm());
                appendRow.add(planRow.getExrepaymentDate());
                appendRow.add(planRow.getExdrawAmount());
                builder.append(appendRow.toArray());
            }
        }
        return builder.build();
    }
}

