/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.ReportSecondaryDevelopControlHelper;
import kd.tmc.tda.common.propertys.PeportDesignerVOProp;

public class ReportDesignControlHelper {
    public static DynamicObject buildDesignConfigData(JSONObject jsonData) {
        PeportDesignerVOProp designerVO = ReportDesignControlHelper.buildJSONObjectForConfig(jsonData);
        DynamicObject dynamicObjectNew = BusinessDataServiceHelper.newDynamicObject((String)"tda_largeboard");
        if (EmptyUtil.isNoEmpty((String)designerVO.getConfigId())) {
            dynamicObjectNew.set("id", (Object)designerVO.getConfigId());
        }
        dynamicObjectNew.set("billno", (Object)designerVO.getConfigtag());
        dynamicObjectNew.set("name", (Object)designerVO.getName());
        dynamicObjectNew.set("configtext_tag", (Object)designerVO.getContent().toJSONString());
        dynamicObjectNew.set("configtext", (Object)ReportDesignControlHelper.subStringFromJson(designerVO.getContent().toJSONString()));
        dynamicObjectNew.set("version", (Object)designerVO.getVersion());
        dynamicObjectNew.set("versiondescribe", (Object)designerVO.getVersiondesc());
        dynamicObjectNew.set("ispublish", (Object)designerVO.getIspublish());
        dynamicObjectNew.set("themecode", (Object)designerVO.getThemecode());
        dynamicObjectNew.set("themename", (Object)designerVO.getThemename());
        dynamicObjectNew.set("isinitial", (Object)designerVO.getIsinitial());
        dynamicObjectNew.set("creator", (Object)designerVO.getCreator());
        dynamicObjectNew.set("billstatus", (Object)"A");
        dynamicObjectNew.set("enable", (Object)1);
        dynamicObjectNew.set("version", (Object)1);
        return dynamicObjectNew;
    }

    public static DynamicObjectCollection buildDesignOptionData(JSONArray jsonArray, DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        Integer diagramNumber = ReportDesignControlHelper.getMaxDiagramNumber(dynamicObject);
        Set<Long> existsIDs = jsonArray.stream().map(object -> JSONObject.parseObject((String)object.toString())).filter(object -> object.get((Object)"pkid") != null && EmptyUtil.isNoEmpty((Object)object.get((Object)"pkid"))).map(object -> Long.valueOf(object.get((Object)"pkid").toString())).collect(Collectors.toSet());
        Map<Long, DynamicObject> existsDys = Arrays.stream(BusinessDataServiceHelper.load((Object[])existsIDs.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tda_diagram"))).collect(Collectors.toMap(dynamicObject1 -> dynamicObject1.getLong("id"), dynamicObject1 -> dynamicObject1));
        for (Object object2 : jsonArray) {
            PeportDesignerVOProp designerVO = ReportDesignControlHelper.buildJSONObjectForOption(JSONObject.parseObject((String)object2.toString()));
            if (EmptyUtil.isEmpty((Integer)designerVO.getDiagramnumber())) {
                Integer n = diagramNumber;
                Integer n2 = diagramNumber = Integer.valueOf(diagramNumber + 1);
                designerVO.setDiagramnumber(diagramNumber);
            }
            DynamicObject dynamicObjectNew = ReportDesignControlHelper.createBuildOptionJSONObect(dynamicObject, designerVO, existsDys);
            dynamicObjectCollection.add((Object)dynamicObjectNew);
        }
        return dynamicObjectCollection;
    }

    public static JSONObject buildDesignAllData(String configtag, String invokeKey) {
        JSONObject jsonData = new JSONObject();
        QFilter[] qFilters = new QFilter[]{new QFilter("billno", "in", (Object)configtag), new QFilter("ispublish", "=", (Object)1), new QFilter("enable", "=", (Object)"1")};
        DynamicObject dynamicObjectConfig = QueryServiceHelper.queryOne((String)"tda_largeboard", (String)"id, billno, name, configtext_tag, version, versiondescribe, ispublish,themename,parentbillno", (QFilter[])qFilters);
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObjectConfig)) {
            return null;
        }
        JSONObject pageConfig = JSONObject.parseObject((String)((String)dynamicObjectConfig.get("configtext_tag")));
        pageConfig.put("name", (Object)dynamicObjectConfig.get("name").toString());
        pageConfig.put("versiondesc", (Object)dynamicObjectConfig.get("versiondescribe").toString());
        pageConfig.put("themename", (Object)dynamicObjectConfig.get("themename").toString());
        pageConfig.put("configtag", (Object)dynamicObjectConfig.get("billno").toString());
        pageConfig.put("parentbillno", (Object)dynamicObjectConfig.get("parentbillno").toString());
        pageConfig.put("pkid", (Object)dynamicObjectConfig.get("id").toString());
        jsonData.put("pageConfig", (Object)pageConfig);
        return ReportDesignControlHelper.buildDesignForOption(jsonData, qFilters, invokeKey, true);
    }

    private static JSONArray getMapChangeJson(Map<String, Set<String>> stringSetMap) {
        JSONArray jsonArray = new JSONArray();
        if (EmptyUtil.isNoEmpty(stringSetMap)) {
            for (Map.Entry<String, Set<String>> entry : stringSetMap.entrySet()) {
                JSONObject jsonObject = new JSONObject();
                String key = entry.getKey();
                jsonObject.put("pluginname", (Object)key);
                jsonObject.put("ids", (Object)((JSONArray)JSON.toJSON(entry.getValue())));
                jsonArray.add((Object)jsonObject);
            }
        }
        return jsonArray;
    }

    public static JSONObject buildDesignForOption(JSONObject jsonData, QFilter[] qFilters, String invokeKey, Boolean userConfigFlag) {
        JSONArray jsonOptionArray = new JSONArray();
        HashMap<String, Set<String>> stringSetMap = new HashMap<String, Set<String>>();
        DynamicObjectCollection optionBills = QueryServiceHelper.query((String)"tda_diagram", (String)"id, billno, name, configtext_tag, type, pluginname, version, versiondescribe, ispublish, titletag, high, width, xaxis, yaxis, chartid, category, zindex, originname, largeboardname, chartcontrol_tag, modifytime, userxindex, useryindex, useryindex1,datafilter,datafilter_tag,sortfield,sortfield_tag,userseries,legendother,numberformat,numberformat_tag,tableColumns,defaultoption,defaultoption_tag,mapData, tenantid, parentversion, diffconfig, versionidentifier", (QFilter[])qFilters);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)optionBills)) {
            for (DynamicObject dynamicObject : optionBills) {
                JSONObject jsonOption = new JSONObject();
                jsonOption.put("pkid", (Object)dynamicObject.get("id").toString());
                jsonOption.put("title", dynamicObject.get("titletag"));
                jsonOption.put("type", dynamicObject.get("type"));
                jsonOption.put("h", dynamicObject.get("high"));
                jsonOption.put("w", dynamicObject.get("width"));
                jsonOption.put("x", dynamicObject.get("xaxis"));
                jsonOption.put("y", dynamicObject.get("yaxis"));
                jsonOption.put("t", dynamicObject.get("modifytime"));
                jsonOption.put("category", dynamicObject.get("category"));
                jsonOption.put("id", dynamicObject.get("chartid"));
                jsonOption.put("zindex", dynamicObject.get("zindex"));
                jsonOption.put("originname", dynamicObject.get("originname"));
                jsonOption.put("chartname", dynamicObject.get("name"));
                jsonOption.put("name", dynamicObject.get("name"));
                jsonOption.put("mapData", dynamicObject.get("mapData"));
                ReportDesignControlHelper.assembleDataConfig(jsonOption, dynamicObject, stringSetMap, userConfigFlag);
                jsonOptionArray.add((Object)jsonOption);
            }
            if (userConfigFlag.booleanValue()) {
                jsonData.put("pluginSet", (Object)ReportDesignControlHelper.getMapChangeJson(stringSetMap));
            }
            jsonData.put("invokeKey", (Object)(invokeKey + "/" + UUID.randomUUID()));
            jsonData.put("itemList", (Object)jsonOptionArray);
        }
        return jsonData;
    }

    public static PeportDesignerVOProp buildJSONObjectForConfig(JSONObject jsonObject) {
        PeportDesignerVOProp peportDesignerVOProp = (PeportDesignerVOProp)JSON.parseObject((String)String.valueOf(jsonObject.get((Object)"pageConfig")), PeportDesignerVOProp.class);
        if (EmptyUtil.isNoEmpty((String)peportDesignerVOProp.getPkid())) {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(peportDesignerVOProp.getPkid())), new QFilter("ispublish", "=", (Object)1), new QFilter("enable", "=", (Object)"1")};
            DynamicObject dynamicObjectConfig = QueryServiceHelper.queryOne((String)"tda_largeboard", (String)"id, billno, creator.id creator, isinitial, tenantid, parentversion, diffconfig, versionidentifier", (QFilter[])qFilters);
            peportDesignerVOProp.setCreator((Long)dynamicObjectConfig.get("creator"));
            peportDesignerVOProp.setIsinitial((Integer)dynamicObjectConfig.get("isinitial"));
            if (dynamicObjectConfig.get("billno").equals(peportDesignerVOProp.getConfigtag())) {
                peportDesignerVOProp.setConfigId(peportDesignerVOProp.getPkid());
            }
        }
        peportDesignerVOProp.setContent((JSONObject)jsonObject.get((Object)"pageConfig"));
        return peportDesignerVOProp;
    }

    public static PeportDesignerVOProp buildJSONObjectForOption(JSONObject jsonObject) {
        JSONObject object = new JSONObject();
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"chartcontrol"))) {
            JSONObject chartControl = (JSONObject)jsonObject.get((Object)"chartcontrol");
            jsonObject.putAll((Map)chartControl);
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"type")) && jsonObject.get((Object)"type").toString().equals("radio")) {
            JSONArray contentArray = (JSONArray)jsonObject.get((Object)"content");
            object.put("redioconfig", (Object)contentArray);
            jsonObject.put("content", (Object)object);
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"type")) && jsonObject.get((Object)"type").toString().equals("tips")) {
            String tipsContent = (String)jsonObject.get((Object)"content");
            object.put("tipscontent", (Object)tipsContent);
            jsonObject.put("content", (Object)object);
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"chartctrl")) && jsonObject.get((Object)"type").toString().equals("select")) {
            object.put("chartctrl", (Object)jsonObject.get((Object)"chartctrl").toString());
            object.putAll((Map)((JSONObject)jsonObject.get((Object)"content")));
            jsonObject.put("content", (Object)object);
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"userxindex"))) {
            JSONArray userXArray = (JSONArray)jsonObject.get((Object)"userxindex");
            jsonObject.put("userxindex", (Object)userXArray.toJSONString());
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"useryindex"))) {
            JSONArray userYArray = (JSONArray)jsonObject.get((Object)"useryindex");
            jsonObject.put("useryindex", (Object)userYArray.toJSONString());
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"useryindex1"))) {
            JSONArray userYArray1 = (JSONArray)jsonObject.get((Object)"useryindex1");
            jsonObject.put("useryindex1", (Object)userYArray1.toJSONString());
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"userseries"))) {
            JSONArray userSeries = (JSONArray)jsonObject.get((Object)"userseries");
            jsonObject.put("userseries", (Object)userSeries.toJSONString());
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"datafilter"))) {
            JSONArray dataFilter = (JSONArray)jsonObject.get((Object)"datafilter");
            jsonObject.put("datafilter", (Object)dataFilter);
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"defaultoption"))) {
            JSONArray defaultOption = (JSONArray)jsonObject.get((Object)"defaultoption");
            jsonObject.put("defaultoption", (Object)defaultOption);
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"sortfield"))) {
            JSONArray sortField = (JSONArray)jsonObject.get((Object)"sortfield");
            jsonObject.put("sortfield", (Object)sortField);
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"legendother"))) {
            JSONArray legendOtherArray = (JSONArray)jsonObject.get((Object)"legendother");
            jsonObject.put("legendother", (Object)legendOtherArray.toJSONString());
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"tableColumns"))) {
            JSONArray tableArray = (JSONArray)jsonObject.get((Object)"tableColumns");
            jsonObject.put("tableColumns", (Object)tableArray.toJSONString());
        }
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"numberformat"))) {
            JSONArray numberFormat = (JSONArray)jsonObject.get((Object)"numberformat");
            jsonObject.put("numberformat", (Object)numberFormat);
        }
        PeportDesignerVOProp peportDesignerVO = (PeportDesignerVOProp)JSON.parseObject((String)String.valueOf(jsonObject), PeportDesignerVOProp.class);
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"pkid"))) {
            peportDesignerVO.setOptionId(jsonObject.get((Object)"pkid").toString());
        }
        return peportDesignerVO;
    }

    public static void saveAndEditDesignerData(DynamicObject dynamicConfigObject, DynamicObjectCollection dynamicObjectOption, JSONArray jsonDelArray) {
        Set existsChartIds;
        Set<Object> existsIds = new HashSet(2);
        if (EmptyUtil.isNoEmpty((Object)jsonDelArray)) {
            List chartIdList = jsonDelArray.toJavaList(String.class);
            DynamicObjectCollection existsOptions = QueryServiceHelper.query((String)"tda_diagram", (String)"id", (QFilter[])new QFilter[]{new QFilter("chartid", "in", (Object)chartIdList), new QFilter("billno", "=", dynamicConfigObject.get("billno"))});
            existsIds = existsOptions.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        }
        String billno = EmptyUtil.isNoEmpty((Object)dynamicConfigObject.get("billno")) ? dynamicConfigObject.get("billno").toString() : null;
        DynamicObject existsBillno = new DynamicObject();
        if (EmptyUtil.isNoEmpty((String)billno)) {
            existsBillno = QueryServiceHelper.queryOne((String)"tda_largeboard", (String)"billno,versionidentifier,parentbillno,tenantid", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        }
        if (EmptyUtil.isNoEmpty(existsChartIds = dynamicObjectOption.stream().filter(s -> EmptyUtil.isNoEmpty((Object)s.get("chartid"))).map(o -> o.getString("chartid")).collect(Collectors.toSet()))) {
            DynamicObjectCollection existsChartIdOptions = QueryServiceHelper.query((String)"tda_diagram", (String)"chartid", (QFilter[])new QFilter[]{new QFilter("chartid", "in", existsChartIds), new QFilter("billno", "=", (Object)dynamicConfigObject.get("billno").toString())});
            existsChartIds = existsChartIdOptions.stream().map(o -> o.getString("chartid")).collect(Collectors.toSet());
        }
        DynamicObjectCollection dynamicSaveOptions = new DynamicObjectCollection();
        DynamicObjectCollection dynamicEditOptions = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : dynamicObjectOption) {
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("id")) || EmptyUtil.isNoEmpty(existsChartIds) && existsChartIds.contains(dynamicObject.get("chartid"))) {
                dynamicEditOptions.add((Object)dynamicObject);
                continue;
            }
            dynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
            dynamicObject.set("versionidentifier", existsBillno.get("versionidentifier"));
            dynamicObject.set("parentbillno", existsBillno.get("parentbillno"));
            dynamicObject.set("tenantid", existsBillno.get("tenantid"));
            dynamicSaveOptions.add((Object)dynamicObject);
        }
        if (EmptyUtil.isNoEmpty((Object)dynamicConfigObject.get("id")) || EmptyUtil.isNoEmpty((DynamicObject)existsBillno)) {
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicConfigObject});
        } else {
            dynamicConfigObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
            dynamicConfigObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            dynamicConfigObject.set("isinitial", (Object)1);
            dynamicConfigObject.set("tenantid", (Object)RequestContext.get().getTenantId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicConfigObject});
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicEditOptions)) {
            ReportDesignControlHelper.saveCheckSecondaryDevForOption(dynamicEditOptions);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicSaveOptions)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dynamicSaveOptions.toArray((Object[])new DynamicObject[0])));
        }
        if (EmptyUtil.isNoEmpty(existsIds)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"tda_diagram"), (Object[])existsIds.toArray(new Long[0]));
        }
    }

    private static void saveCheckSecondaryDevForOption(DynamicObjectCollection dynamicEditOptions) {
        DynamicObjectCollection dynamicObjectRawCollection = ReportSecondaryDevelopControlHelper.checkExistSecondaryDevDataForOption(dynamicEditOptions);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicObjectRawCollection)) {
            ReportSecondaryDevelopControlHelper.saveSecondaryDevDiff(dynamicEditOptions, dynamicObjectRawCollection);
        }
        SaveServiceHelper.update((DynamicObject[])((DynamicObject[])dynamicEditOptions.toArray((Object[])new DynamicObject[0])));
    }

    public static DynamicObject createBuildOptionJSONObect(DynamicObject dynamicObject, PeportDesignerVOProp designerVO, Map<Long, DynamicObject> existsDys) {
        DynamicObject dynamicObjectNew = BusinessDataServiceHelper.newDynamicObject((String)"tda_diagram");
        if (EmptyUtil.isNoEmpty((String)designerVO.getOptionId())) {
            if (EmptyUtil.isNoEmpty(existsDys)) {
                dynamicObjectNew = existsDys.get(Long.valueOf(designerVO.getOptionId()));
            } else {
                dynamicObjectNew.set("id", (Object)designerVO.getOptionId());
            }
        }
        if (EmptyUtil.isNoEmpty((Object)designerVO.getChartcontrol())) {
            dynamicObjectNew.set("chartcontrol", (Object)ReportDesignControlHelper.subStringFromJson(designerVO.getChartcontrol().toJSONString()));
            dynamicObjectNew.set("chartcontrol_tag", (Object)designerVO.getChartcontrol().toJSONString());
        }
        if (EmptyUtil.isNoEmpty((Object)designerVO.getContent())) {
            dynamicObjectNew.set("configtext", (Object)ReportDesignControlHelper.subStringFromJson(designerVO.getContent().toJSONString()));
            dynamicObjectNew.set("configtext_tag", (Object)designerVO.getContent().toJSONString());
        }
        if (EmptyUtil.isNoEmpty((Object)designerVO.getDataFilter())) {
            dynamicObjectNew.set("datafilter", (Object)ReportDesignControlHelper.subStringFromJson(designerVO.getDataFilter().toJSONString()));
            dynamicObjectNew.set("datafilter_tag", (Object)designerVO.getDataFilter().toJSONString());
        } else {
            dynamicObjectNew.set("datafilter", (Object)"");
            dynamicObjectNew.set("datafilter_tag", (Object)"");
        }
        if (EmptyUtil.isNoEmpty((Object)designerVO.getDefaultOption())) {
            dynamicObjectNew.set("defaultoption", (Object)ReportDesignControlHelper.subStringFromJson(designerVO.getDefaultOption().toJSONString()));
            dynamicObjectNew.set("defaultoption_tag", (Object)designerVO.getDefaultOption().toJSONString());
        }
        if (EmptyUtil.isNoEmpty((Object)designerVO.getSortField())) {
            dynamicObjectNew.set("sortfield", (Object)ReportDesignControlHelper.subStringFromJson(designerVO.getSortField().toJSONString()));
            dynamicObjectNew.set("sortfield_tag", (Object)designerVO.getSortField().toJSONString());
        }
        if (EmptyUtil.isNoEmpty((Object)designerVO.getNumberformat())) {
            dynamicObjectNew.set("numberformat", (Object)ReportDesignControlHelper.subStringFromJson(designerVO.getNumberformat().toJSONString()));
            dynamicObjectNew.set("numberformat_tag", (Object)designerVO.getNumberformat().toJSONString());
        }
        dynamicObjectNew.set("billno", dynamicObject.get("billno"));
        dynamicObjectNew.set("name", (Object)new LocaleString(designerVO.getName()));
        dynamicObjectNew.set("type", (Object)designerVO.getType());
        dynamicObjectNew.set("pluginname", (Object)designerVO.getPluginname());
        dynamicObjectNew.set("version", (Object)designerVO.getVersion());
        dynamicObjectNew.set("versiondescribe", (Object)designerVO.getVersiondesc());
        dynamicObjectNew.set("ispublish", (Object)designerVO.getIspublish());
        dynamicObjectNew.set("diagramnumber", (Object)designerVO.getDiagramnumber());
        dynamicObjectNew.set("isinitial", (Object)designerVO.getIsinitial());
        dynamicObjectNew.set("high", (Object)designerVO.getH());
        dynamicObjectNew.set("width", (Object)designerVO.getW());
        dynamicObjectNew.set("xaxis", (Object)designerVO.getX());
        dynamicObjectNew.set("yaxis", (Object)designerVO.getY());
        dynamicObjectNew.set("titletag", (Object)designerVO.getTitle());
        dynamicObjectNew.set("category", (Object)designerVO.getCategory());
        dynamicObjectNew.set("zindex", (Object)designerVO.getZindex());
        dynamicObjectNew.set("chartid", (Object)designerVO.getId());
        dynamicObjectNew.set("originname", (Object)new LocaleString(designerVO.getOriginname()));
        dynamicObjectNew.set("largeboardname", dynamicObject.get("name"));
        dynamicObjectNew.set("userxindex", (Object)designerVO.getUserxindex());
        dynamicObjectNew.set("legendother", (Object)designerVO.getLegendother());
        dynamicObjectNew.set("tableColumns", (Object)designerVO.getTableColumns());
        dynamicObjectNew.set("mapData", (Object)designerVO.getMapData());
        dynamicObjectNew.set("useryindex", (Object)designerVO.getUseryindex());
        dynamicObjectNew.set("useryindex1", (Object)designerVO.getUseryindex1());
        dynamicObjectNew.set("userseries", (Object)designerVO.getUserseries());
        dynamicObjectNew.set("billstatus", (Object)"A");
        dynamicObjectNew.set("enable", (Object)1);
        dynamicObjectNew.set("ispublish", (Object)1);
        return dynamicObjectNew;
    }

    public static DynamicObject editDesignConfigData(JSONObject jsonObject) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)((Long)jsonObject.get((Object)"id"))), new QFilter("enable", "=", (Object)"1")};
        DynamicObject dynamicConfigObject = BusinessDataServiceHelper.loadSingle((String)"tda_largeboard", (String)"id, billno, name, configtext_tag, version, versiondescribe, ispublish", (QFilter[])qFilters);
        if (EmptyUtil.isNoEmpty((DynamicObject)dynamicConfigObject)) {
            PeportDesignerVOProp designerVO = ReportDesignControlHelper.buildJSONObjectForOption(jsonObject);
            dynamicConfigObject.set("configtext_tag", (Object)designerVO.getConfig());
            dynamicConfigObject.set("configtext", (Object)ReportDesignControlHelper.subStringFromJson(designerVO.getConfig()));
            dynamicConfigObject.set("name", (Object)designerVO.getName());
            dynamicConfigObject.set("billno", (Object)designerVO.getConfigtag());
            dynamicConfigObject.set("version", (Object)designerVO.getVersion());
            dynamicConfigObject.set("versiondescribe", (Object)designerVO.getVersiondesc());
            dynamicConfigObject.set("themecode", (Object)designerVO.getThemecode());
            dynamicConfigObject.set("themename", (Object)designerVO.getThemename());
            dynamicConfigObject.set("isinitial", (Object)designerVO.getIsinitial());
            dynamicConfigObject.set("ispublish", (Object)designerVO.getIspublish());
        }
        return dynamicConfigObject;
    }

    public static DynamicObject editBuildOptionData(DynamicObject dynamicObject, PeportDesignerVOProp designerVO) {
        dynamicObject.set("configtext_tag", (Object)designerVO.getConfig());
        dynamicObject.set("configtext", (Object)ReportDesignControlHelper.subStringFromJson(designerVO.getConfig()));
        dynamicObject.set("optiontext_tag", (Object)designerVO.getOption());
        dynamicObject.set("optiontext", (Object)ReportDesignControlHelper.subStringFromJson(designerVO.getOption()));
        dynamicObject.set("type", (Object)designerVO.getType());
        dynamicObject.set("pluginname", (Object)designerVO.getPluginname());
        dynamicObject.set("version", (Object)designerVO.getVersion());
        dynamicObject.set("versiondescribe", (Object)designerVO.getVersiondesc());
        dynamicObject.set("ispublish", (Object)designerVO.getIspublish());
        return dynamicObject;
    }

    private static Integer getMaxDiagramNumber(DynamicObject dynamicObject) {
        QFilter[] qFilters = new QFilter[]{new QFilter("billno", "in", dynamicObject.get("billno")), new QFilter("enable", "=", (Object)"1")};
        DynamicObjectCollection dynamicOptionCollection = QueryServiceHelper.query((String)"tda_diagram", (String)"id, version, diagramnumber", (QFilter[])qFilters);
        Optional<Integer> maxDiagramNumber = dynamicOptionCollection.stream().map(s -> (Integer)s.get("diagramnumber")).max(Comparator.naturalOrder());
        if (maxDiagramNumber.isPresent()) {
            return maxDiagramNumber.get();
        }
        return 0;
    }

    public static String subStringFromJson(String jsonString) {
        if (EmptyUtil.isNoEmpty((String)jsonString)) {
            return jsonString.length() > 200 ? jsonString.substring(0, 200) : jsonString;
        }
        return jsonString;
    }

    private static void assembleDataConfig(JSONObject jsonOption, DynamicObject dynamicObject, Map<String, Set<String>> stringSetMap, Boolean userConfigFlag) {
        if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("configtext_tag"))) {
            JSONObject configtextTagObject = JSONObject.parseObject((String)dynamicObject.get("configtext_tag").toString());
            JSONObject chartControlTagObject = JSONObject.parseObject((String)dynamicObject.get("chartcontrol_tag").toString());
            if (dynamicObject.get("type").toString().equals("radio")) {
                jsonOption.put("content", (Object)((JSONArray)configtextTagObject.get((Object)"redioconfig")));
            } else if (dynamicObject.get("type").toString().equals("select")) {
                JSONObject ctlOption = JSONObject.parseObject((String)dynamicObject.get("configtext_tag").toString());
                jsonOption.put("chartctrl", ctlOption.get((Object)"chartctrl"));
                jsonOption.put("content", (Object)ctlOption);
            } else if (dynamicObject.get("type").toString().equals("tips")) {
                jsonOption.put("content", configtextTagObject.get((Object)"tipscontent"));
            } else {
                jsonOption.put("content", (Object)configtextTagObject);
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("pluginname"))) {
                jsonOption.put("pluginname", dynamicObject.get("pluginname"));
                String pulginName = dynamicObject.get("pluginname").toString();
                Set<Object> idSet = EmptyUtil.isNoEmpty(stringSetMap.get(pulginName)) ? stringSetMap.get(pulginName) : new HashSet();
                idSet.add(dynamicObject.get("id").toString());
                stringSetMap.put(pulginName, idSet);
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("userxindex")) && userConfigFlag.booleanValue()) {
                jsonOption.put("userxindex", (Object)JSON.parseArray((String)dynamicObject.get("userxindex").toString()));
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("useryindex")) && userConfigFlag.booleanValue()) {
                jsonOption.put("useryindex", (Object)JSON.parseArray((String)dynamicObject.get("useryindex").toString()));
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("useryindex1")) && userConfigFlag.booleanValue()) {
                jsonOption.put("useryindex1", (Object)JSON.parseArray((String)dynamicObject.get("useryindex1").toString()));
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("userseries")) && userConfigFlag.booleanValue()) {
                jsonOption.put("userseries", (Object)JSON.parseArray((String)dynamicObject.get("userseries").toString()));
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("datafilter_tag"))) {
                jsonOption.put("datafilter", (Object)JSON.parseArray((String)dynamicObject.get("datafilter_tag").toString()));
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("defaultoption_tag"))) {
                jsonOption.put("defaultoption", (Object)JSON.parseArray((String)dynamicObject.get("defaultoption_tag").toString()));
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("sortfield_tag"))) {
                jsonOption.put("sortfield", (Object)JSON.parseArray((String)dynamicObject.get("sortfield_tag").toString()));
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("legendother"))) {
                jsonOption.put("legendother", (Object)JSON.parseArray((String)dynamicObject.get("legendother").toString()));
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("tableColumns"))) {
                jsonOption.put("tableColumns", (Object)JSON.parseArray((String)dynamicObject.get("tableColumns").toString()));
            }
            if (EmptyUtil.isNoEmpty((Object)dynamicObject.get("numberformat_tag"))) {
                jsonOption.put("numberformat", (Object)JSON.parseArray((String)dynamicObject.get("numberformat_tag").toString()));
            }
            jsonOption.put("chartcontrol", (Object)chartControlTagObject);
        }
        if ("select".equals(dynamicObject.get("type").toString())) {
            JSONObject chartcontrolTagObject = JSONObject.parseObject((String)dynamicObject.get("chartcontrol_tag").toString());
            jsonOption.put("chartcontrol", (Object)chartcontrolTagObject);
        }
    }
}

