/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.ReportDesignControlHelper;

public class ReportSecondaryDevelopControlHelper {
    public static void saveSecondaryDevDiff(DynamicObjectCollection dynamicEditOptions, DynamicObjectCollection rawDataList) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rawDataList)) {
            Map<String, String> rawDataMap = rawDataList.stream().collect(Collectors.toMap(s -> s.get("chartid").toString(), s -> s.get("configtext_tag").toString()));
            for (DynamicObject dynamicObject : dynamicEditOptions) {
                if (!EmptyUtil.isNoEmpty((String)rawDataMap.get(dynamicObject.get("chartid")))) continue;
                JSONObject obj1 = JSON.parseObject((String)rawDataMap.get(dynamicObject.get("chartid")));
                JSONObject obj2 = JSON.parseObject((String)dynamicObject.get("configtext_tag").toString());
                HashMap<String, Object> differences = new HashMap<String, Object>();
                ReportSecondaryDevelopControlHelper.compareJsonForSecondary(obj1, obj2, "", differences);
                dynamicObject.set("diffconfig", (Object)ReportDesignControlHelper.subStringFromJson(JSON.toJSONString(differences)));
                dynamicObject.set("diffconfig_tag", (Object)JSON.toJSONString(differences));
            }
        }
    }

    private static void compareJsonForSecondary(JSONObject json1, JSONObject json2, String path, Map<String, Object> differences) {
        for (Map.Entry entry : json1.entrySet()) {
            String key = (String)entry.getKey();
            String fullPath = path.isEmpty() ? key : path + "." + key;
            Object value1 = new Object();
            Object value2 = new Object();
            if (json2.containsKey((Object)key)) {
                value1 = entry.getValue();
                value2 = json2.get((Object)key);
                if (value1 instanceof JSONObject && value2 instanceof JSONObject) {
                    ReportSecondaryDevelopControlHelper.compareJsonForSecondary((JSONObject)value1, (JSONObject)value2, fullPath, differences);
                    continue;
                }
                if (value1.equals(value2)) continue;
                differences.put(fullPath, new Object[]{value1, value2});
                continue;
            }
            differences.put(fullPath, new Object[]{value1, "missing"});
        }
        for (String key : json2.keySet()) {
            if (json1.containsKey((Object)key)) continue;
            String fullPath = path.isEmpty() ? key : path + "." + key;
            differences.put(fullPath, new Object[]{"missing", json2.get((Object)key)});
        }
    }

    public static DynamicObjectCollection checkExistSecondaryDevData(DynamicObject dynamicConfigObject) {
        QFilter filter = new QFilter("billno", "=", dynamicConfigObject.get("parentbillno"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("versionidentifier", "=", (Object)"0"));
        return QueryServiceHelper.query((String)"tda_largeboard", (String)"id", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection checkExistSecondaryDevDataForOption(DynamicObjectCollection dynamicObjects) {
        QFilter filter = new QFilter("billno", "=", ((DynamicObject)dynamicObjects.get(0)).get("parentbillno"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("versionidentifier", "=", (Object)"0"));
        return QueryServiceHelper.query((String)"tda_diagram", (String)"id,versionidentifier,chartid,configtext_tag,version,parentversion,diffconfig,diffconfig_tag,tenantid", (QFilter[])new QFilter[]{filter});
    }
}

