/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.tda.extpoint.transdetail.ITransDetailGetDataInterface;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.SysParamHelper;

public class SettleDataHelper {
    private static final String BIZ_DATE = "bizdate";
    private static final String ENTITY_TRANSDETAILSUMMARY = "tda_transdetailsummary";
    private static int dateOffset = 12;
    private static String MONTH_DATE = "monthdate";
    public static final String COMPANY = "company";
    public static final String[] FILTER_EXPRS = new String[]{"bizdate >= last7Day and bizdate <= queryDate", "bizdate >= lastMonth and bizdate <= queryDate", "bizdate >= last2Month and bizdate <= queryDate", "bizdate >= last6Month and bizdate <= queryDate"};

    public static DataSet queryTransDetail(String algoKey, Long orgViewId, Long baseCurrency, Date queryDate, List<Long> allOrgIds, String businessKey) {
        String cacheKey = SettleDataHelper.getCacheKey(orgViewId, queryDate, businessKey);
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        boolean noCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        DataSet cacheOrElseGet = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> {
            List quaryOrgIds = allOrgIds;
            if (isQueryCache && !noCache) {
                quaryOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            }
            String currDaySic = "company, currency, creditamount, debitamount, case when bank.country.twocountrycode = 'CN' then 'domestic' else case when bank.country.threecountrycode = 'CHN' then 'domestic' else case when bank.country = 0 or (bank.country.twocountrycode = ' ' and bank.country.threecountrycode = ' ') then 'domestic' else 'overseas' end end end as areaRange";
            QFilter transDetailsFilter = SettleDataHelper.getTransDetailsFilter(quaryOrgIds, queryDate);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bei_transdetail", (String)currDaySic, (QFilter[])transDetailsFilter.toArray(), null);
            dataSet = AmountTransHelper.tranDataSetRate((DataSet)dataSet, (Long)orgViewId, (Long)baseCurrency, (String)"currency", new HashSet<String>(Arrays.asList("creditamount", "debitamount")), (Date)queryDate);
            return dataSet;
        });
        if (isQueryCache && !noCache) {
            cacheOrElseGet = cacheOrElseGet.filter("company in ids", Collections.singletonMap("ids", allOrgIds));
        }
        return cacheOrElseGet;
    }

    private static QFilter getTransDetailsFilter(List<Long> allOrgIds, Date queryDate) {
        Date nextDay = DateUtils.getNextDay((Date)queryDate, (int)1);
        QFilter filter = new QFilter(COMPANY, "in", allOrgIds).and(BIZ_DATE, ">=", (Object)queryDate).and(BIZ_DATE, "<", (Object)nextDay).and("bank.finorgtype.type", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        return filter.and(SettleDataHelper.getExtendFilter());
    }

    public static QFilter getExtendFilter() {
        PluginProxy pluginProxy = PluginProxy.create(ITransDetailGetDataInterface.class, (String)"kd.sdk.tmc.tda.extpoint.transdetail.ITransDetailGetDataInterface");
        List lists = pluginProxy.callReplace(p -> p.getExtendFilter());
        if (EmptyUtil.isNoEmpty((Object)lists) && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (QFilter)lists.get(0);
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    public static DataSet queryTransDetailsSummary(String algoKey, Long orgViewId, Long baseCurrency, List<Long> allOrgIds, Date queryDate) {
        String cacheKey = SettleDataHelper.getCacheKey(orgViewId, queryDate, "transDetailsSummary");
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        boolean noCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        DataSet cacheOrElseGet = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> {
            List quaryOrgIds = allOrgIds;
            if (isQueryCache && !noCache) {
                quaryOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            }
            QFilter transDetailFilter = SettleDataHelper.getTransDetailsSummaryFilter(quaryOrgIds, queryDate);
            String selectTransDetailsSummary = "org, org.name org_name, monthdate, entry.currency currency, entry.creditamount creditamount, entry.debitamount debitamount,entry.creditcount creditcount, entry.debitcount debitcount, entry.area as areaRange";
            DataSet transDetailDataSet = QueryServiceHelper.queryDataSet((String)"SettleDataHelper", (String)ENTITY_TRANSDETAILSUMMARY, (String)selectTransDetailsSummary, (QFilter[])transDetailFilter.toArray(), null);
            DataSet dataSet = AmountTransHelper.tranDataSetRate((DataSet)transDetailDataSet, (Long)orgViewId, (Long)baseCurrency, (String)"currency", new HashSet<String>(Arrays.asList("creditamount", "debitamount")), (Date)queryDate);
            return dataSet;
        });
        if (isQueryCache && !noCache) {
            cacheOrElseGet = cacheOrElseGet.filter("org in ids", Collections.singletonMap("ids", allOrgIds));
        }
        return cacheOrElseGet;
    }

    private static QFilter getTransDetailsSummaryFilter(List<Long> allOrgIds, Date queryDate) {
        Date starDate = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)(-dateOffset));
        QFilter qFilter = new QFilter("org.id", "in", allOrgIds);
        qFilter.and(MONTH_DATE, ">=", (Object)starDate);
        return qFilter;
    }

    public static DataSet queryBigAmtSet(String algoKey, Long orgViewId, List<Long> allOrgIds, Date queryDate) {
        String cacheKey = SettleDataHelper.getCacheKey(orgViewId, queryDate, "queryBigAmt");
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        boolean noCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        DataSet cacheOrElseGetSet = CacheManager.getCacheOrElseGet(orgViewId, algoKey, cacheKey, () -> {
            List quaryOrgIds = allOrgIds;
            if (isQueryCache && !noCache) {
                quaryOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            }
            QFilter filter = SettleDataHelper.getBigAmtFilter(quaryOrgIds, queryDate);
            String selectFields = "billno, bizdate, creditamount, debitamount, org.id as orgid, org.id as rowid, org.name as orgname, currency, currency.id, currency.name as currencyname, accountbank.bankaccountnumber as accountbank, bank.name as bankname, entityname, moneyflow, oppname, region, usage";
            return QueryServiceHelper.queryDataSet((String)"SettleDataHelper", (String)"tda_bigamountbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        });
        if (isQueryCache && !noCache) {
            cacheOrElseGetSet = cacheOrElseGetSet.filter("orgid in ids", Collections.singletonMap("ids", allOrgIds));
        }
        return cacheOrElseGetSet;
    }

    protected static QFilter getBigAmtFilter(List<Long> allOrgIds, Date queryDate) {
        QFilter filter = new QFilter("org.id", "in", allOrgIds);
        filter.and(new QFilter(BIZ_DATE, "<=", (Object)queryDate));
        Date startDate = DateUtils.getDataFormat((Date)queryDate, (boolean)true);
        filter.and(new QFilter(BIZ_DATE, ">=", (Object)DateUtils.getFirstDateOfAnyMonth((Date)startDate, (int)-5)));
        return filter;
    }

    public static String getFilterDateStr(Date queryDate, String dateRange, Map<String, Object> dateParamsMap) {
        String filterDateStr = "bizdate>=";
        if (dateRange == null) {
            dateRange = "six_month";
        }
        switch (dateRange) {
            case "one_month": {
                Date last1Month = SettleDataHelper.getFirstDayTimeOfAnyMonth(queryDate, 0);
                filterDateStr = filterDateStr + "one_month";
                dateParamsMap.put("one_month", last1Month);
                break;
            }
            case "two_month": {
                Date last2Month = SettleDataHelper.getFirstDayTimeOfAnyMonth(queryDate, -1);
                filterDateStr = filterDateStr + "two_month";
                dateParamsMap.put("two_month", last2Month);
                break;
            }
            case "six_month": {
                Date last6Month = SettleDataHelper.getFirstDayTimeOfAnyMonth(queryDate, -5);
                filterDateStr = filterDateStr + "six_month";
                dateParamsMap.put("six_month", last6Month);
                break;
            }
            default: {
                Date last7Day = DateUtils.getLastDay((Date)queryDate, (int)7);
                filterDateStr = filterDateStr + "seven_day";
                dateParamsMap.put("seven_day", last7Day);
            }
        }
        return filterDateStr;
    }

    public static String getCacheKey(Long orgviewId, Date queryDate, String businessKey) {
        return "settleDataHelper-" + businessKey + "-cachekey-" + orgviewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }

    public static Date getFirstDayTimeOfAnyMonth(Date date, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, offset);
        calendar.set(5, calendar.getActualMinimum(5));
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        return calendar.getTime();
    }
}

