/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.tmc.tda.common.model.RepayPlanRow;

public class RepayPlan {
    private Long id;
    private Date queryDate;
    private BigDecimal repayAmount;
    private Boolean perpetualbond;
    private Date expireDate;
    private List<RepayPlanRow> repayPlanRows = new ArrayList<RepayPlanRow>(32);
    private BigDecimal allExdrawAmount = BigDecimal.ZERO;
    private boolean isBuild = false;

    public RepayPlan(Long id, Date queryDate, BigDecimal repayAmount, Boolean perpetualbond, Date expireDate) {
        this.id = id;
        this.queryDate = queryDate;
        this.repayAmount = repayAmount;
        this.perpetualbond = perpetualbond;
        this.expireDate = expireDate;
    }

    public void add(RepayPlanRow repayPlanRow) {
        boolean isAdd = true;
        if (!this.repayPlanRows.isEmpty()) {
            for (RepayPlanRow planRow : this.repayPlanRows) {
                if (!planRow.getExrepaymentDate().equals(repayPlanRow.getExrepaymentDate())) continue;
                isAdd = false;
                break;
            }
        }
        if (isAdd) {
            this.repayPlanRows.add(repayPlanRow);
        }
        if (isAdd && !this.isBuild) {
            this.allExdrawAmount = this.allExdrawAmount.add(repayPlanRow.getExdrawAmount());
        }
    }

    public RepayPlan build() {
        if (this.isBuild) {
            return this;
        }
        this.isBuild = true;
        if (this.repayPlanRows == null) {
            this.repayPlanRows = new ArrayList<RepayPlanRow>(2);
            this.add(new RepayPlanRow(this.repayAmount, this.expireDate, this.queryDate));
            return this;
        }
        if (this.repayAmount.compareTo(BigDecimal.ZERO) < 0) {
            for (int i = 0; i < this.repayPlanRows.size(); ++i) {
                RepayPlanRow row = this.repayPlanRows.get(i);
                if (i == this.repayPlanRows.size() - 1) {
                    row.setExdrawAmount(this.repayAmount);
                    continue;
                }
                row.setExdrawAmount(BigDecimal.ZERO);
            }
            return this;
        }
        if (this.allExdrawAmount.compareTo(this.repayAmount) == 0) {
            return this;
        }
        if (this.allExdrawAmount.compareTo(this.repayAmount) < 0) {
            this.repayPlanRows.add(new RepayPlanRow(this.repayAmount.subtract(this.allExdrawAmount), this.queryDate, this.queryDate));
            return this;
        }
        BigDecimal amount = BigDecimal.ZERO;
        boolean flag = true;
        for (int i = 0; i < this.repayPlanRows.size(); ++i) {
            RepayPlanRow row = this.repayPlanRows.get(i);
            BigDecimal exdrawAmount = row.getExdrawAmount();
            BigDecimal temp = amount.add(exdrawAmount);
            if (this.repayAmount.compareTo(temp) >= 0) {
                amount = temp;
                continue;
            }
            if (flag) {
                BigDecimal subtract = this.repayAmount.subtract(amount);
                amount = amount.add(subtract);
                row.setExdrawAmount(subtract);
                flag = false;
                continue;
            }
            row.setExdrawAmount(BigDecimal.ZERO);
        }
        return this;
    }

    public List<RepayPlanRow> getRepayPlanRows() {
        return this.repayPlanRows;
    }

    public boolean isBuild() {
        return this.isBuild;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getPerpetualbond() {
        return this.perpetualbond;
    }

    public void setPerpetualbond(Boolean perpetualbond) {
        this.perpetualbond = perpetualbond;
    }
}

