/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.business.cash;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;

public class PositionAccSetSaveAndEnableValidator
extends AbstractTmcBizOppValidator {
    private static final String USAGE_NUMBER = "usage.number";

    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("usage");
        return sl;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Set<String> usageNumberSet = this.getUsageNumberSet();
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject acctUsage = dataEntity.getDataEntity().getDynamicObject("usage");
            String usageNumber = acctUsage.getString("number");
            if (!usageNumberSet.contains(usageNumber)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u7528\u9014\u5df2\u88ab\u53d7\u9650\u8d44\u91d1\u7528\u9014\u7ef4\u62a4\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PositionAccSetSaveAndEnableValidator_0", (String)"tmc-tda-business", (Object[])new Object[0]));
        }
    }

    private Set<String> getUsageNumberSet() {
        DataSet positionUsageSet = QueryServiceHelper.queryDataSet((String)"positionUsage", (String)"am_restrictedfundusage", (String)"usage.number, enable", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())}, null);
        Iterator rowIterator = positionUsageSet.iterator();
        HashSet<String> usageNumberSet = new HashSet<String>(16);
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            String usageNumber = row.getString(USAGE_NUMBER);
            usageNumberSet.add(usageNumber);
        }
        return usageNumberSet;
    }
}

