/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.business.liquidity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.tmc.tda.extpoint.liquidity.ILiquidityCalculateInterface;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.FinanceInterestBearLiaDisDatahelper;

public class LiquidityGetDataService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(LiquidityGetDataService.class);
    private static Pattern threeMonth = Pattern.compile("(^([1-2]m)?([0-9]{1,2}d))|(^[1-3]m$)");
    private final int DEFAULT_SCALE = 10;

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("orgview");
        sic.add("org");
        sic.add("currency");
        sic.add("accountyear");
        sic.add("accountperiod");
        sic.add("assetsamt");
        sic.add("debtamt");
        sic.add("flowassetsamt");
        sic.add("stockamt");
        sic.add("flowdebtamt");
        sic.add("profitamt");
        sic.add("intfeeamt");
        sic.add("monetaryfundamt");
        sic.add("intdebtamt");
        sic.add("equityamt");
        sic.add("duethreemonthamt");
        sic.add("assetsdebtrate");
        sic.add("intdebtrate");
        sic.add("intdebtequityrate");
        sic.add("quickratio");
        sic.add("flowratio");
        sic.add("intcoverratio");
        sic.add("fundduethreemthratio");
        sic.add("duethreemonthratio");
        sic.add("ownerequityamt");
        return sic;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        ArrayList<DynamicObject> saveObjects = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (DynamicObject liquidityBill : dynamicObjects) {
            DynamicObject orgView = liquidityBill.getDynamicObject("orgview");
            DynamicObject org = liquidityBill.getDynamicObject("org");
            DynamicObject currency = liquidityBill.getDynamicObject("currency");
            int accountYear = liquidityBill.getInt("accountyear");
            int accountPeirod = liquidityBill.getInt("accountperiod");
            String billNo = liquidityBill.getString("billno");
            BigDecimal intDebtAmt = BigDecimal.ZERO;
            BigDecimal equityAmt = BigDecimal.ZERO;
            BigDecimal dueThreeMonthAmt = BigDecimal.ZERO;
            try {
                Long orgViewId = orgView.getLong("id");
                Long orgId = org.getLong("id");
                List orgIdSet = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
                Long baseCurrency = AmountTransHelper.getBaseCurrency((Long)orgViewId);
                DataSet financeAllData = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIdSet, (Date)this.getQueryDate(accountYear, accountPeirod), (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
                financeAllData = financeAllData.filter("rowoffset = 0 and coloffset = 0").select("repayamount,isequity").groupBy(new String[]{"isequity"}).sum("repayamount").finish();
                HashMap<String, Object> convertMap = new HashMap<String, Object>(4);
                convertMap.put("currency", currency);
                convertMap.put("orgview", orgView);
                convertMap.put("basecurrency", baseCurrency);
                financeAllData = AmountTransHelper.dealAmountConvert((DataSet)financeAllData, convertMap, Collections.singleton("repayamount"));
                for (Row financeAllDatum : financeAllData) {
                    boolean isEquity = financeAllDatum.getBoolean("isequity");
                    if (isEquity) {
                        equityAmt = financeAllDatum.getBigDecimal("repayamount");
                        continue;
                    }
                    intDebtAmt = financeAllDatum.getBigDecimal("repayamount");
                }
                DataSet ds = FinanceInterestBearLiaDisDatahelper.getInterstBearLiaDisDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIdSet, (Date)this.getQueryDate(accountYear, accountPeirod), (Long)baseCurrency, (Long)orgViewId, (Long)orgId, null);
                ds = ds.filter("isequity=false").select("isoutgroup,residueterm,repayamount,rowoffset,coloffset,perpetualbond");
                boolean enableoffsetshow = BasicParamHelper.getAppBooleamParameter((String)"tda_finance_param", (String)"enableoffsetshow");
                ds = enableoffsetshow ? ds.updateField("repayamount", "case when isoutgroup = 0 then repayamount + rowoffset else repayamount + rowoffset + coloffset end") : ds.updateField("repayamount", "repayamount + rowoffset + coloffset");
                ds = ds.filter(new FilterFunction(){

                    public boolean test(Row row) {
                        boolean perpetualbond = row.getBoolean("perpetualbond");
                        String residueterm = row.getString("residueterm");
                        if (!perpetualbond && EmptyUtil.isEmpty((String)residueterm)) {
                            return true;
                        }
                        if (EmptyUtil.isNoEmpty((String)residueterm)) {
                            Matcher matcher = threeMonth.matcher(residueterm);
                            return matcher.matches();
                        }
                        return false;
                    }
                });
                ds = ds.select("repayamount").groupBy().sum("repayamount").finish();
                for (Row row : ds) {
                    dueThreeMonthAmt = row.getBigDecimal("repayamount");
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u6709\u606f\u8d1f\u503a\u3001\u6743\u76ca\u5de5\u5177\u30013\u4e2a\u6708\u5185\u6709\u606f\u8d1f\u503a\u6570\u636e\u5931\u8d25\uff0cbillNo: " + billNo + "\u5931\u8d25\u4fe1\u606f\uff1a" + e);
                continue;
            }
            intDebtAmt = EmptyUtil.isEmpty((BigDecimal)intDebtAmt) ? BigDecimal.ZERO : intDebtAmt;
            equityAmt = EmptyUtil.isEmpty((BigDecimal)equityAmt) ? BigDecimal.ZERO : equityAmt;
            dueThreeMonthAmt = EmptyUtil.isEmpty((BigDecimal)dueThreeMonthAmt) ? BigDecimal.ZERO : dueThreeMonthAmt;
            liquidityBill = this.resetLiquidityCalcProps(liquidityBill, intDebtAmt, equityAmt, dueThreeMonthAmt);
            saveObjects.add(liquidityBill);
        }
        SaveServiceHelper.save((DynamicObject[])saveObjects.toArray(new DynamicObject[0]));
    }

    private DynamicObject resetLiquidityCalcProps(DynamicObject liquidityBill, BigDecimal intDebtAmt, BigDecimal equityAmt, BigDecimal dueThreeMonthAmt) {
        liquidityBill.set("intdebtamt", (Object)intDebtAmt.setScale(10, RoundingMode.HALF_UP));
        liquidityBill.set("equityamt", (Object)equityAmt.setScale(10, RoundingMode.HALF_UP));
        liquidityBill.set("duethreemonthamt", (Object)dueThreeMonthAmt.setScale(10, RoundingMode.HALF_UP));
        BigDecimal assetsAmt = liquidityBill.getBigDecimal("assetsamt");
        BigDecimal debtAmt = liquidityBill.getBigDecimal("debtamt");
        BigDecimal assetsDebtRate = EmptyUtil.isEmpty((BigDecimal)assetsAmt) ? BigDecimal.ZERO : debtAmt.divide(assetsAmt, 10, RoundingMode.HALF_UP);
        liquidityBill.set("assetsdebtrate", (Object)assetsDebtRate);
        BigDecimal intDebtRate = EmptyUtil.isEmpty((BigDecimal)debtAmt) ? BigDecimal.ZERO : intDebtAmt.divide(debtAmt, 10, RoundingMode.HALF_UP);
        liquidityBill.set("intdebtrate", (Object)intDebtRate);
        BigDecimal intDebtEquityRate = EmptyUtil.isEmpty((BigDecimal)debtAmt) ? BigDecimal.ZERO : intDebtAmt.add(equityAmt).divide(debtAmt, 10, RoundingMode.HALF_UP);
        liquidityBill.set("intdebtequityrate", (Object)intDebtEquityRate);
        BigDecimal flowAssetsAmt = liquidityBill.getBigDecimal("flowassetsamt");
        BigDecimal stockAmt = liquidityBill.getBigDecimal("stockamt");
        BigDecimal flowDebtAmt = liquidityBill.getBigDecimal("flowdebtamt");
        BigDecimal quickRatio = EmptyUtil.isEmpty((BigDecimal)flowDebtAmt) ? BigDecimal.ZERO : flowAssetsAmt.subtract(stockAmt).divide(flowDebtAmt, 10, RoundingMode.HALF_UP);
        liquidityBill.set("quickratio", (Object)quickRatio);
        BigDecimal flowRatio = EmptyUtil.isEmpty((BigDecimal)flowDebtAmt) ? BigDecimal.ZERO : flowAssetsAmt.divide(flowDebtAmt, 10, RoundingMode.HALF_UP);
        liquidityBill.set("flowratio", (Object)flowRatio);
        BigDecimal profitAmt = liquidityBill.getBigDecimal("profitamt");
        BigDecimal intFeeAmt = liquidityBill.getBigDecimal("intfeeamt");
        BigDecimal intCoverRatio = EmptyUtil.isEmpty((BigDecimal)intFeeAmt) ? BigDecimal.ZERO : intFeeAmt.add(profitAmt).divide(intFeeAmt, 10, RoundingMode.HALF_UP);
        liquidityBill.set("intcoverratio", (Object)intCoverRatio);
        BigDecimal monetaryFundAmt = liquidityBill.getBigDecimal("monetaryfundamt");
        BigDecimal fundDueThreeMthRatio = EmptyUtil.isEmpty((BigDecimal)dueThreeMonthAmt) ? BigDecimal.ZERO : monetaryFundAmt.divide(dueThreeMonthAmt, 10, RoundingMode.HALF_UP);
        liquidityBill.set("fundduethreemthratio", (Object)fundDueThreeMthRatio);
        BigDecimal dueThreeMonthRatio = EmptyUtil.isEmpty((BigDecimal)intDebtAmt) ? BigDecimal.ZERO : dueThreeMonthAmt.divide(intDebtAmt, 10, RoundingMode.HALF_UP);
        liquidityBill.set("duethreemonthratio", (Object)dueThreeMonthRatio);
        return LiquidityGetDataService.resetCalculationFormula(liquidityBill);
    }

    public static DynamicObject resetCalculationFormula(DynamicObject liquidityBill) {
        PluginProxy pluginProxy = PluginProxy.create(ILiquidityCalculateInterface.class, (String)"kd.sdk.tmc.tda.extpoint.liquidity.ILiquidityCalculateInterface");
        List lists = pluginProxy.callReplace(p -> p.resetCalculationFormula(liquidityBill));
        if (EmptyUtil.isNoEmpty((Object)lists) && EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)lists.get(0)))) {
            return (DynamicObject)lists.get(0);
        }
        return liquidityBill;
    }

    private Date getQueryDate(int accountYear, int accountPeirod) {
        return DateUtils.getLastDayOfMonth((Date)DateUtils.getAppointDay((int)accountYear, (int)accountPeirod, (int)1));
    }
}

