/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.business.snapschedule;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.enums.SnapDataStateEnum;

public class DecisAnlsSnapScheduleService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("orgview");
        sic.add("org");
        sic.add("ishistory");
        return sic;
    }

    public void process(DynamicObject[] snapSchedules) throws KDException {
        CacheManager.clearDataSetCache();
        try (TXHandle tx = TX.notSupported();){
            DynamicObjectCollection colls = new DynamicObjectCollection();
            for (DynamicObject snapSchedule : snapSchedules) {
                DynamicObject version = this.genSnapVersionSchedule(snapSchedule);
                if (!EmptyUtil.isNoEmpty((DynamicObject)version)) continue;
                colls.add((Object)version);
            }
            TmcOperateServiceHelper.execOperate((String)"save", (String)"tda_decisanlsversion", (DynamicObject[])((DynamicObject[])colls.toArray((Object[])new DynamicObject[colls.size()])), (OperateOption)OperateOption.create());
        }
    }

    private DynamicObject genSnapVersionSchedule(DynamicObject snapSchedule) {
        DynamicObject orgView = snapSchedule.getDynamicObject("orgview");
        DynamicObject org = snapSchedule.getDynamicObject("org");
        Date queryDate = DateUtils.getCurrentDate();
        DynamicObject version = TmcDataServiceHelper.newDynamicObject((String)"tda_decisanlsversion");
        String number = SnapDataHelper.createDecisAnlsVersion((DynamicObject)snapSchedule.getDynamicObject("orgview"));
        version.set("number", (Object)number);
        version.set("name", (Object)number);
        version.set("orgview", (Object)orgView);
        version.set("org", (Object)org);
        version.set("querydate", (Object)queryDate);
        version.set("begintime", (Object)DateUtils.getCurrentTime());
        version.set("versionstate", (Object)SnapDataStateEnum.LOADING.getValue());
        version.set("enable", (Object)1);
        version.set("creator", (Object)RequestContext.get().getCurrUserId());
        version.set("isupdate", (Object)snapSchedule.getBoolean("ishistory"));
        return version;
    }
}

