/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.MQ;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.enums.SnapDataStateEnum;
import kd.tmc.tda.mservice.snap.DecsAnlsSnapBatchScheduleService;

public class SnapScheduleConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(SnapScheduleConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        logger.info("SnapScheduleConsumer : " + JSON.toJSONString((Object)message));
        Map param = (Map)message;
        String type = (String)param.get("type");
        String batch = (String)param.get("batch");
        Boolean ishistory = (Boolean)param.get("ishistory");
        int index = (Integer)param.get("index");
        if (ishistory != null && !ishistory.booleanValue() && !this.isCurrentOldestBatch(batch)) {
            acker.discard(messageId);
            return;
        }
        logger.info("\u6267\u884c\u7b2c" + index + " :\u6279\u8c03\u5ea6 \uff1a " + JSON.toJSONString((Object)message));
        try {
            Long orgViewId = (Long)param.get("orgViewId");
            List orgList = (List)param.get("orgList");
            String updateStatusBatch = (String)param.get("updateStatusBatch");
            Date queryDate = (Date)param.get("queryDate");
            Long scheduleId = (Long)param.get("schedule");
            DynamicObject schedule = TmcDataServiceHelper.loadSingleFromCache((Object)scheduleId, (String)"tda_decisanlsreportsnap");
            DecsAnlsSnapBatchScheduleService service = new DecsAnlsSnapBatchScheduleService();
            service.batchRunSnapSchedule(orgViewId, orgList, schedule, batch, queryDate, updateStatusBatch);
        }
        catch (Exception e) {
            logger.info("\u6267\u884c\u7b2c" + index + " :\u6279\u8c03\u5ea6\u5f02\u5e38 \uff1a " + JSON.toJSONString((Object)message) + "\n " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            acker.deny(messageId);
        }
        acker.ack(messageId);
    }

    private boolean isCurrentOldestBatch(String batch) {
        DynamicObject[] versions;
        QFilter filter = new QFilter("number", "=", (Object)batch);
        DynamicObject version = TmcDataServiceHelper.loadSingleFromCache((String)"tda_decisanlsversion", (String)"orgview,querydate", (QFilter[])filter.toArray());
        filter = new QFilter("orgview.id", "=", version.getDynamicObject("orgview").getPkValue());
        filter = filter.and(new QFilter("querydate", "=", (Object)version.getDate("querydate")));
        filter = filter.and(new QFilter("versionstate", "=", (Object)SnapDataStateEnum.LOADING.getValue()));
        for (DynamicObject newVersion : versions = TmcDataServiceHelper.load((String)"tda_decisanlsversion", (String)"number,id,modifytime", (QFilter[])filter.toArray(), (String)"createtime asc")) {
            if (batch.equals(newVersion.getString("number"))) {
                logger.info("\u8dd1\u5f53\u524d\u6d88\u606f\u7684\u8c03\u5ea6\u7248\u672c \uff1a " + newVersion);
                return true;
            }
            if (DateUtils.getDiffMinute((Date)newVersion.getDate("modifytime"), (Date)new Date()) >= 60) continue;
            logger.info("\u6700\u65b0\u53ef\u8c03\u5ea6\u7248\u672c\u662f \uff1a " + newVersion + ", \u8be5\u7248\u672c:" + batch + "\u6d88\u606f\u5c06\u4e22\u5f03");
            return false;
        }
        return false;
    }
}

