/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.arap.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.mservice.arap.ApBillSummaryService;
import kd.tmc.tda.mservice.arap.ArBillSummaryService;
import kd.tmc.tda.mservice.arap.PayBillSummaryService;
import kd.tmc.tda.mservice.arap.RecBillSummaryService;
import org.apache.commons.lang3.tuple.Pair;

public class ArapSummaryScheduleTask
extends AbstractTask {
    private final List<DynamicObject> saveList = new ArrayList<DynamicObject>(10);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        ApBillSummaryService apService;
        Pair<Map<String, Integer>, DataSet> apBills;
        ArBillSummaryService arService;
        Pair<Map<String, Integer>, DataSet> arBills;
        String date = (String)map.get("date");
        Date dealDate = DateUtils.getCurrentDate();
        if (EmptyUtil.isNoEmpty((String)date)) {
            dealDate = DateUtils.stringToDate((String)date, (String)"yyyy-MM-dd");
        }
        if ((arBills = (arService = new ArBillSummaryService()).genArapDataSetByBillType(dealDate)) != null) {
            this.saveArapSummaryData((Map)arBills.getLeft(), (DataSet)arBills.getRight(), "ar_finarbill", dealDate);
        }
        if ((apBills = (apService = new ApBillSummaryService()).genArapDataSetByBillType(dealDate)) != null) {
            this.saveArapSummaryData((Map)apBills.getLeft(), (DataSet)apBills.getRight(), "ap_finapbill", dealDate);
        }
        PayBillSummaryService payService = new PayBillSummaryService();
        DataSet payBills = payService.genPayRecDataSetByBillType(dealDate);
        this.savePayRecSummaryData(payBills, "cas_paybill", dealDate);
        RecBillSummaryService recService = new RecBillSummaryService();
        DataSet recBills = recService.genPayRecDataSetByBillType(dealDate);
        this.savePayRecSummaryData(recBills, "cas_recbill", dealDate);
        if (EmptyUtil.isNoEmpty(this.saveList)) {
            QFilter delFilter = new QFilter("paymentday", "=", (Object)DateUtils.formatString((Date)DateUtils.getLastMonth((Date)dealDate, (int)1), (String)"yyyy-MM"));
            DeleteServiceHelper.delete((String)"tda_arap_sumbill", (QFilter[])delFilter.toArray());
            SaveServiceHelper.save((DynamicObject[])this.saveList.toArray(new DynamicObject[0]));
        }
    }

    private void saveArapSummaryData(Map<String, Integer> seqMap, DataSet dataSet, String entityNumber, Date dealDate) {
        if (dataSet == null) {
            return;
        }
        HashMap<String, DynamicObject> recordMap = new HashMap<String, DynamicObject>(16);
        for (Row row : dataSet) {
            DynamicObject summarBill;
            Long orgId = row.getLong("orgid");
            String aging = row.getString("aging");
            String mapKey = orgId + "_" + aging;
            DynamicObject mapValue = recordMap.getOrDefault(mapKey, null);
            if (mapValue != null) {
                summarBill = mapValue;
            } else {
                summarBill = TmcDataServiceHelper.newDynamicObject((String)"tda_arap_sumbill");
                summarBill.set("billtype", (Object)entityNumber);
                summarBill.set("org", (Object)orgId);
                summarBill.set("paymentday", (Object)DateUtils.formatString((Date)DateUtils.getLastMonth((Date)dealDate, (int)1), (String)"yyyy-MM"));
                summarBill.set("agingseq", (Object)seqMap.get(aging));
                summarBill.set("agingname", (Object)aging);
            }
            DynamicObjectCollection entrys = summarBill.getDynamicObjectCollection("entry");
            DynamicObject addNew = entrys.addNew();
            String baseField = "ar_finarbill".equals(entityNumber) ? "customer" : "supplier";
            addNew.set(baseField, (Object)row.getLong("custsuppid"));
            addNew.set(baseField + "name", (Object)row.getString("custsuppname"));
            addNew.set("custsupptype", (Object)row.getString("custsupptype"));
            addNew.set("currency", (Object)row.getLong("currencyid"));
            addNew.set("amount", (Object)row.getBigDecimal("amount"));
            addNew.set("count", (Object)row.getInteger("count"));
            recordMap.put(mapKey, summarBill);
        }
        this.saveList.addAll(recordMap.values());
    }

    private void savePayRecSummaryData(DataSet dataSet, String entityNumber, Date dealDate) {
        if (dataSet == null) {
            return;
        }
        HashMap<String, DynamicObject> recordMap = new HashMap<String, DynamicObject>(16);
        for (Row row : dataSet) {
            DynamicObject summarBill;
            Long orgId = row.getLong("orgid");
            String mapKey = String.valueOf(orgId);
            DynamicObject mapValue = recordMap.getOrDefault(mapKey, null);
            if (mapValue != null) {
                summarBill = mapValue;
            } else {
                summarBill = TmcDataServiceHelper.newDynamicObject((String)"tda_arap_sumbill");
                summarBill.set("billtype", (Object)entityNumber);
                summarBill.set("org", (Object)orgId);
                summarBill.set("paymentday", (Object)DateUtils.formatString((Date)DateUtils.getLastMonth((Date)dealDate, (int)1), (String)"yyyy-MM"));
            }
            DynamicObjectCollection entrys = summarBill.getDynamicObjectCollection("entry");
            DynamicObject addNew = entrys.addNew();
            String baseField = "cas_paybill".equals(entityNumber) ? "supplier" : "customer";
            addNew.set(baseField, (Object)row.getLong("custsuppid"));
            addNew.set(baseField + "name", (Object)row.getString("custsuppname"));
            addNew.set("custsupptype", (Object)row.getString("custsupptype"));
            addNew.set("currency", (Object)row.getLong("currencyid"));
            addNew.set("amount", (Object)row.getBigDecimal("amount"));
            addNew.set("count", (Object)row.getInteger("count"));
            recordMap.put(mapKey, summarBill);
        }
        this.saveList.addAll(recordMap.values());
    }
}

