/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.bigamount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FundFlowTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;

public class BigAmountSummaryService {
    public void batchBigAmount(List<String> bigAmounts) {
        DynamicObject bigAmountSet = TmcDataServiceHelper.loadSingle((String)"tda_bigamountset", (String)"bigamountthreshold,bigamountgetterway,tradetextfield_tag", (QFilter[])new QFilter[0]);
        BigDecimal thresholdAmount = bigAmountSet.getBigDecimal("bigamountthreshold");
        ArrayList<DynamicObject> genBigAmountBills = new ArrayList<DynamicObject>(10);
        String transSelect = "id,billno,company,currency,debitamount,creditamount,bizdate,accountbank, accountbank.bank bank,accountbank.bank.country country, accountbank.bank.country.twocountrycode twocountrycode,oppunit,oppbank,oppbanknumber,description";
        QFilter qFilter = new QFilter("billno", "in", bigAmounts);
        QFilter filterFromTag = this.getFilterFromTag("bei_transdetail", bigAmountSet.getString("tradetextfield_tag"));
        if (filterFromTag != null) {
            qFilter.and(filterFromTag);
        }
        DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail", (String)transSelect, (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject transDetail : transDetails) {
            long currencyId = transDetail.getLong("currency");
            long orgId = transDetail.getLong("company");
            BigDecimal debitAmount = transDetail.getBigDecimal("debitamount");
            BigDecimal creditAmount = transDetail.getBigDecimal("creditamount");
            BigDecimal transAmount = debitAmount.intValue() == 0 ? creditAmount : debitAmount;
            BigDecimal rmbAmount = this.transToRmbAmount(transAmount, currencyId, orgId, rateMap);
            if (rmbAmount.compareTo(thresholdAmount) < 0) continue;
            DynamicObject bigAmountBill2 = TmcDataServiceHelper.newDynamicObject((String)"tda_bigamountbill");
            this.setCommonProperty(transDetail, bigAmountBill2, "bei_transdetail");
            this.setTransDetailProperties(transDetail, bigAmountBill2);
            genBigAmountBills.add(bigAmountBill2);
        }
        if (EmptyUtil.isNoEmpty(genBigAmountBills)) {
            this.delTransDetailData(genBigAmountBills.stream().map(bigAmountBill -> bigAmountBill.getString("billno")).collect(Collectors.toList()));
            SaveServiceHelper.save((DynamicObject[])genBigAmountBills.toArray(new DynamicObject[0]));
        }
    }

    public void batchPayOrRecBigAmount(String entityName, List<String> bigAmounts) {
        boolean setSuccess;
        DynamicObject bigAmountBill2;
        Map<Object, DynamicObject> countryMap;
        Map finOrgInfoMap;
        DynamicObject bigAmountSet = TmcDataServiceHelper.loadSingle((String)"tda_bigamountset", (String)"bigamountthreshold,bigamountgetterway,rectextfield_tag,paytextfield_tag", (QFilter[])new QFilter[0]);
        BigDecimal thresholdAmount = bigAmountSet.getBigDecimal("bigamountthreshold");
        ArrayList<DynamicObject> genBigAmountBills = new ArrayList<DynamicObject>(10);
        List idList = bigAmounts.stream().map(Long::valueOf).collect(Collectors.toList());
        if ("cas_paybill".equals(entityName)) {
            DynamicObject[] payBills;
            List<DynamicObject> payBillList;
            String selectPay = "billstatus,payeracctbank,currency,org,billno,payeebanknum,payeename,payeebankname,actpayamt,paydate,entry,entry.e_actamt,entry.e_fundflowitem,description";
            QFilter payFilter = new QFilter("id", "in", idList);
            QFilter payFilterFromTag = this.getFilterFromTag("cas_paybill", bigAmountSet.getString("paytextfield_tag"));
            if (payFilterFromTag != null) {
                payFilter.and(payFilterFromTag);
            }
            if (EmptyUtil.isEmpty(payBillList = this.getEffectivePayOrRecBills(payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)selectPay, (QFilter[])payFilter.toArray()), "actpayamt", "payeracctbank", thresholdAmount))) {
                return;
            }
            Set payerbankIds = payBillList.stream().map(bill -> ((DynamicObject)bill.get("payeracctbank")).getLong("bank_id")).collect(Collectors.toSet());
            finOrgInfoMap = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"id,country", (QFilter[])new QFilter("id", "in", payerbankIds).toArray());
            countryMap = this.getCountryMap(finOrgInfoMap);
            for (DynamicObject payBill : payBillList) {
                bigAmountBill2 = TmcDataServiceHelper.newDynamicObject((String)"tda_bigamountbill");
                this.setCommonProperty(payBill, bigAmountBill2, "cas_paybill");
                setSuccess = this.setPayBillProperties(payBill, bigAmountBill2, finOrgInfoMap, countryMap);
                if (!setSuccess) continue;
                genBigAmountBills.add(bigAmountBill2);
            }
        }
        if ("cas_recbill".equals(entityName)) {
            DynamicObject[] recBills;
            List<DynamicObject> recBillList;
            String selectRec = "billstatus,accountbank,currency,org,billno,actrecamt,payeracctbanknum,payerbankname,payername,payeedate,entry,entry.e_actamt,entry.e_fundflowitem,txt_description";
            QFilter recFilter = new QFilter("id", "in", idList);
            QFilter recFilterFromTag = this.getFilterFromTag("cas_recbill", bigAmountSet.getString("rectextfield_tag"));
            if (recFilterFromTag != null) {
                recFilter.and(recFilterFromTag);
            }
            if (EmptyUtil.isEmpty(recBillList = this.getEffectivePayOrRecBills(recBills = TmcDataServiceHelper.load((String)"cas_recbill", (String)selectRec, (QFilter[])recFilter.toArray()), "actrecamt", "accountbank", thresholdAmount))) {
                return;
            }
            Set recbankIds = recBillList.stream().map(bill -> ((DynamicObject)bill.get("accountbank")).getLong("bank_id")).collect(Collectors.toSet());
            finOrgInfoMap = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"id,country", (QFilter[])new QFilter("id", "in", recbankIds).toArray());
            countryMap = this.getCountryMap(finOrgInfoMap);
            for (DynamicObject recBill : recBillList) {
                bigAmountBill2 = TmcDataServiceHelper.newDynamicObject((String)"tda_bigamountbill");
                this.setCommonProperty(recBill, bigAmountBill2, "cas_recbill");
                setSuccess = this.setRecBillProperties(recBill, bigAmountBill2, finOrgInfoMap, countryMap);
                if (!setSuccess) continue;
                genBigAmountBills.add(bigAmountBill2);
            }
        }
        if (EmptyUtil.isNoEmpty(genBigAmountBills)) {
            this.delTransDetailData(genBigAmountBills.stream().map(bigAmountBill -> bigAmountBill.getString("billno")).collect(Collectors.toList()));
            SaveServiceHelper.save((DynamicObject[])genBigAmountBills.toArray(new DynamicObject[0]));
        }
    }

    private void setTransDetailProperties(DynamicObject transData, DynamicObject bigAmountBill) {
        bigAmountBill.set("org", (Object)transData.getString("company"));
        this.setTransDate(bigAmountBill, transData.getDate("bizdate"));
        bigAmountBill.set("accountbank", (Object)transData.getLong("accountbank"));
        bigAmountBill.set("bank", (Object)transData.getLong("bank"));
        bigAmountBill.set("oppaccountbank", (Object)transData.getString("oppbanknumber"));
        bigAmountBill.set("oppname", (Object)transData.getString("oppunit"));
        bigAmountBill.set("oppbank", (Object)transData.getString("oppbank"));
        BigDecimal debitAmount = transData.getBigDecimal("debitamount");
        BigDecimal creditAmount = transData.getBigDecimal("creditamount");
        bigAmountBill.set("debitamount", (Object)debitAmount);
        bigAmountBill.set("creditamount", (Object)creditAmount);
        if (debitAmount.intValue() != 0) {
            bigAmountBill.set("moneyflow", (Object)FundFlowTypeEnum.OUT_FLOW.getValue());
        } else if (creditAmount.intValue() != 0) {
            bigAmountBill.set("moneyflow", (Object)FundFlowTypeEnum.IN_FLOW.getValue());
        }
        bigAmountBill.set("usage", (Object)transData.getString("description"));
        Long country = transData.getLong("country");
        if (country == null || country.equals(0L)) {
            bigAmountBill.set("region", (Object)AcctDisplayByBankTypeEnum.DOMESTIC.getValue());
        } else {
            String twoCountryCode = transData.getString("twocountrycode");
            if (EmptyUtil.isEmpty((String)twoCountryCode) || twoCountryCode.equals("CN")) {
                bigAmountBill.set("region", (Object)AcctDisplayByBankTypeEnum.DOMESTIC.getValue());
            } else {
                bigAmountBill.set("region", (Object)AcctDisplayByBankTypeEnum.OVERSEAS.getValue());
            }
        }
    }

    public void delTransDetailData(List<String> billNoList) {
        QFilter qFilter = new QFilter("billno", "in", billNoList);
        DeleteServiceHelper.delete((String)"tda_bigamountbill", (QFilter[])new QFilter[]{qFilter});
    }

    private void setCommonProperty(DynamicObject transData, DynamicObject bigAmountBill, String entityName) {
        bigAmountBill.set("billno", transData.get("billno"));
        bigAmountBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        bigAmountBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        bigAmountBill.set("createtime", (Object)DateUtils.getCurrentTime());
        bigAmountBill.set("currency", transData.get("currency"));
        bigAmountBill.set("entityname", (Object)entityName);
    }

    private boolean setPayBillProperties(DynamicObject payBill, DynamicObject bigAmountBill, Map<Object, DynamicObject> finOrgInfos, Map<Object, DynamicObject> countries) {
        if (!this.setRegion(payBill, "payeracctbank", bigAmountBill, finOrgInfos, countries)) {
            return Boolean.FALSE;
        }
        bigAmountBill.set("accountbank", payBill.get("payeracctbank"));
        bigAmountBill.set("org", payBill.get("org"));
        bigAmountBill.set("oppaccountbank", payBill.get("payeebanknum"));
        bigAmountBill.set("oppname", payBill.get("payeename"));
        bigAmountBill.set("oppbank", payBill.get("payeebankname"));
        bigAmountBill.set("debitamount", payBill.get("actpayamt"));
        bigAmountBill.set("moneyflow", (Object)FundFlowTypeEnum.OUT_FLOW.getValue());
        this.setUsage(payBill, bigAmountBill);
        this.setTransDate(bigAmountBill, payBill.getDate("paydate"));
        return Boolean.TRUE;
    }

    private boolean setRecBillProperties(DynamicObject recBill, DynamicObject bigAmountBill, Map<Object, DynamicObject> finOrgInfos, Map<Object, DynamicObject> countries) {
        if (!this.setRegion(recBill, "accountbank", bigAmountBill, finOrgInfos, countries)) {
            return Boolean.FALSE;
        }
        bigAmountBill.set("accountbank", recBill.get("accountbank"));
        bigAmountBill.set("org", recBill.get("org"));
        bigAmountBill.set("oppaccountbank", recBill.get("payeracctbanknum"));
        bigAmountBill.set("oppbank", recBill.get("payerbankname"));
        bigAmountBill.set("oppname", recBill.get("payername"));
        bigAmountBill.set("creditamount", recBill.get("actrecamt"));
        bigAmountBill.set("moneyflow", (Object)FundFlowTypeEnum.IN_FLOW.getValue());
        this.setUsage(recBill, bigAmountBill);
        this.setTransDate(bigAmountBill, recBill.getDate("payeedate"));
        return Boolean.TRUE;
    }

    private boolean setRegion(DynamicObject billObject, String acctName, DynamicObject bigAmountBill, Map<Object, DynamicObject> finOrgInfos, Map<Object, DynamicObject> countries) {
        DynamicObject billAcctbank = (DynamicObject)billObject.get(acctName);
        long bankId = billAcctbank.getLong("bank_id");
        DynamicObject finOrgInfo = finOrgInfos.get(bankId);
        if (finOrgInfo == null) {
            return Boolean.FALSE;
        }
        bigAmountBill.set("bank", (Object)bankId);
        if (finOrgInfo.get("country") == null || ((DynamicObject)finOrgInfo.get("country")).getLong("id") == 0L || countries.get(((DynamicObject)finOrgInfo.get("country")).getLong("id")) == null) {
            bigAmountBill.set("region", (Object)AcctDisplayByBankTypeEnum.DOMESTIC.getValue());
            return Boolean.TRUE;
        }
        DynamicObject countryInfo = countries.get(((DynamicObject)finOrgInfo.get("country")).getLong("id"));
        String twoCountryCode = countryInfo.getString("twocountrycode");
        if (EmptyUtil.isEmpty((String)twoCountryCode) || twoCountryCode.equals("CN")) {
            bigAmountBill.set("region", (Object)AcctDisplayByBankTypeEnum.DOMESTIC.getValue());
        } else {
            bigAmountBill.set("region", (Object)AcctDisplayByBankTypeEnum.OVERSEAS.getValue());
        }
        return Boolean.TRUE;
    }

    private BigDecimal transToRmbAmount(BigDecimal amount, Long fromCurrencyId, Long orgId, Map<Long, BigDecimal> rateMap) {
        BigDecimal rate;
        long tarCurrencyId = 1L;
        if (fromCurrencyId.equals(tarCurrencyId)) {
            rate = BigDecimal.ONE;
        } else {
            rate = rateMap.get(fromCurrencyId);
            if (rate == null) {
                rate = TmcBusinessBaseHelper.getExchangeRate((long)fromCurrencyId, (long)tarCurrencyId, (long)orgId, (Date)DateUtils.getCurrentDate());
                if (rate == null) {
                    rate = BigDecimal.ONE;
                }
                rateMap.put(fromCurrencyId, rate);
            }
        }
        return amount.multiply(rate);
    }

    private void setUsage(DynamicObject transData, DynamicObject bigAmountBill) {
        Optional<DynamicObject> maxAmtEntry;
        DynamicObjectCollection billEntryCollection = (DynamicObjectCollection)transData.get("entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)billEntryCollection) && (maxAmtEntry = billEntryCollection.stream().max(Comparator.comparing(e -> e.getBigDecimal("e_actamt")))).isPresent()) {
            DynamicObject fundFlowItem = maxAmtEntry.get().getDynamicObject("e_fundflowitem");
            if (fundFlowItem != null) {
                bigAmountBill.set("usage", (Object)fundFlowItem.getString("name"));
            } else {
                String entityName = transData.getDataEntityType().getName();
                if (entityName.equals("cas_paybill")) {
                    bigAmountBill.set("usage", (Object)transData.getString("description"));
                } else if (entityName.equals("cas_recbill")) {
                    bigAmountBill.set("usage", (Object)transData.getString("txt_description"));
                }
            }
        }
    }

    private void setTransDate(DynamicObject bigAmountBill, Date date) {
        bigAmountBill.set("bizdate", (Object)DateUtils.getDataFormat((Date)date, (boolean)true));
    }

    private List<DynamicObject> getEffectivePayOrRecBills(DynamicObject[] bills, String amountName, String bankAcctName, BigDecimal thresholdAmount) {
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>(bills.length);
        ArrayList<DynamicObject> collect = new ArrayList<DynamicObject>(bills.length);
        List<DynamicObject> dynamicObjects = Arrays.asList(bills);
        for (DynamicObject bill : dynamicObjects) {
            BigDecimal transToRmbAmount;
            DynamicObject org;
            DynamicObject currency;
            DynamicObject bankAcct;
            if (!BillStatusEnum.PAYED.getValue().equals(bill.get("billstatus")) || (bankAcct = (DynamicObject)bill.get(bankAcctName)) == null || bankAcct.getLong("bank_id") == 0L || (currency = (DynamicObject)bill.get("currency")) == null || currency.getLong("id") == 0L || (org = (DynamicObject)bill.get("org")) == null || org.getLong("id") == 0L || (transToRmbAmount = this.transToRmbAmount(bill.getBigDecimal(amountName), currency.getLong("id"), org.getLong("id"), rateMap)).compareTo(thresholdAmount) < 0) continue;
            collect.add(bill);
        }
        return collect;
    }

    private Map<Object, DynamicObject> getCountryMap(Map<Object, DynamicObject> finOrgInfoMap) {
        Set countryIds = finOrgInfoMap.values().stream().filter(finorginfo -> finorginfo.get("country") != null && ((DynamicObject)finorginfo.get("country")).getLong("id") != 0L).map(finorginfo -> ((DynamicObject)finorginfo.get("country")).getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(countryIds)) {
            return TmcDataServiceHelper.loadFromCache((String)"bd_country", (String)"id,twocountrycode", (QFilter[])new QFilter("number", "=", (Object)"001").toArray());
        }
        return TmcDataServiceHelper.loadFromCache((String)"bd_country", (String)"id,twocountrycode", (QFilter[])new QFilter("id", "in", countryIds).toArray());
    }

    private QFilter getFilterFromTag(String entryName, String filterTag) {
        if (EmptyUtil.isEmpty((String)filterTag)) {
            return null;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterTag, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entryName);
        FilterBuilder fb = new FilterBuilder(dataType, filterCondition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }
}

