/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.design;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CustomControlUtil;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.propertys.PeportDesignerTableVOProp;

public class DesignScheduleTask
implements Callable {
    private JSONObject jsonObject;
    private JSONArray itemList;
    private Map<String, Object> paramMap;
    private CountDownLatch latch;
    private String plugin;
    private static final Log logger = LogFactory.getLog(DesignScheduleTask.class);

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public DesignScheduleTask(String plugin, Map<String, Object> paramMap, CountDownLatch latch, JSONObject jsonObject) {
        this.plugin = plugin;
        this.paramMap = paramMap;
        this.latch = latch;
        this.jsonObject = jsonObject;
    }

    public JSONObject call() {
        try {
            String dataset = CustomControlUtil.customControlDataForPlugin((String)this.plugin, this.paramMap);
            this.buildJSONObject(this.plugin, dataset, this.jsonObject);
        }
        finally {
            this.latch.countDown();
        }
        return this.jsonObject;
    }

    private void buildJSONObject(String plugin, String pluginData, JSONObject jsonObjectA) {
        JSONArray resultList = new JSONArray();
        JSONArray itemList = (JSONArray)jsonObjectA.get((Object)"itemList");
        for (Object obj : itemList) {
            JSONObject jsonObject = (JSONObject)obj;
            if (!EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"pluginname")) || !plugin.equals(jsonObject.get((Object)"pluginname"))) continue;
            jsonObject.put("dataset", (Object)JSONObject.parseObject((String)pluginData));
            this.buildTableDataSet(jsonObject);
            resultList.add((Object)jsonObject);
        }
        jsonObjectA.put("itemList", (Object)resultList);
    }

    private void buildTableDataSet(JSONObject jsonObject) {
        if (EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"type")) && (jsonObject.get((Object)"type").toString().equals("table") || jsonObject.get((Object)"type").toString().equals("newtable") || jsonObject.get((Object)"type").toString().equals("mergetable")) && EmptyUtil.isNoEmpty((Object)jsonObject.get((Object)"dataset"))) {
            JSONObject jsonTableObject = (JSONObject)jsonObject.get((Object)"dataset");
            JSONArray arrayDataIndex = (JSONArray)jsonTableObject.get((Object)"dataindex");
            JSONArray arrayRows = (JSONArray)jsonTableObject.get((Object)"rows");
            JSONArray numberFormats = (JSONArray)jsonObject.get((Object)"numberformat");
            HashMap<String, String> alignMap = new HashMap<String, String>(16);
            if (EmptyUtil.isNoEmpty((Object)numberFormats)) {
                for (Object numberFormat : numberFormats) {
                    alignMap.put(((JSONObject)numberFormat).getString("key"), ((JSONObject)numberFormat).getString("align"));
                }
            }
            Integer percentColumnWidth = 100;
            Integer chartWidth = jsonObject.getInteger("w");
            JSONArray tableColumn = jsonObject.getJSONArray("tableColumns");
            if (EmptyUtil.isNoEmpty((Integer)chartWidth) && EmptyUtil.isNoEmpty((Object)tableColumn) && tableColumn.size() > 0) {
                percentColumnWidth = chartWidth / tableColumn.size();
            }
            ArrayList<PeportDesignerTableVOProp> voList = new ArrayList<PeportDesignerTableVOProp>(4);
            for (int i = 0; i < arrayDataIndex.size(); ++i) {
                PeportDesignerTableVOProp vo = new PeportDesignerTableVOProp();
                JSONArray subArray = arrayDataIndex.getJSONArray(i);
                if (subArray.size() < 2) continue;
                vo.setCode(subArray.getString(0));
                vo.setName(subArray.getString(1));
                vo.setDataIndex(subArray.getString(0));
                vo.setTitle(subArray.getString(1));
                vo.setWidth(String.valueOf(percentColumnWidth));
                if (jsonObject.get((Object)"type").toString().equals("newtable")) {
                    vo.setWidth("auto");
                }
                if (EmptyUtil.isNoEmpty((String)((String)alignMap.get(subArray.getString(0))))) {
                    vo.setAlign((String)alignMap.get(subArray.getString(0)));
                } else if (2 == subArray.getInteger(2)) {
                    vo.setAlign("right");
                } else if (1 == subArray.getInteger(2)) {
                    vo.setAlign("left");
                } else {
                    vo.setAlign("center");
                }
                voList.add(vo);
            }
            if (EmptyUtil.isNoEmpty(voList)) {
                if ("kd.tmc.tda.report.liquidity.qing.LiquidityIndicatorDetailDiagramDataPlugin".equals(jsonObject.get((Object)"pluginname"))) {
                    ArrayList voLiquidityList = new ArrayList(4);
                    voLiquidityList.add(voList.get(0));
                    PeportDesignerTableVOProp longVo = new PeportDesignerTableVOProp();
                    PeportDesignerTableVOProp shortVo = new PeportDesignerTableVOProp();
                    longVo.setTitle(ResManager.loadKDString((String)"\u957f\u671f\u507f\u503a\u80fd\u529b", (String)"DesignScheduleTask_0", (String)"tmc-tda-mservice", (Object[])new Object[0]));
                    shortVo.setTitle(ResManager.loadKDString((String)"\u77ed\u671f\u507f\u503a\u80fd\u529b", (String)"DesignScheduleTask_1", (String)"tmc-tda-mservice", (Object[])new Object[0]));
                    longVo.setChildren(new ArrayList());
                    shortVo.setChildren(new ArrayList());
                    for (int i = 1; i < voList.size(); ++i) {
                        if (i <= 3) {
                            longVo.getChildren().add(voList.get(i));
                            continue;
                        }
                        shortVo.getChildren().add(voList.get(i));
                    }
                    voLiquidityList.add(longVo);
                    voLiquidityList.add(shortVo);
                    jsonObject.put("columns", voLiquidityList);
                } else if ("kd.tmc.tda.report.synthesis.qing.data.SynthesisDiagramTableDataPlugin".equals(jsonObject.get((Object)"pluginname"))) {
                    ArrayList voLiquidityList = new ArrayList(4);
                    Date queryDate = DecisionCommonHelper.fixQueryDate((Date)((Date)this.paramMap.get("querydate")));
                    Date bizDate = null;
                    try {
                        if (arrayRows != null && arrayRows.size() > 1) {
                            bizDate = new Date((Long)((JSONArray)arrayRows.get(1)).get(11));
                        }
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                    if (bizDate != null) {
                        queryDate = bizDate;
                    }
                    Date currentMonth = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-1);
                    String currentMonthStr = new SimpleDateFormat("yyyy-MM").format(currentMonth);
                    Date lastMonth = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-2);
                    String lastMonthStr = new SimpleDateFormat("yyyy-MM").format(lastMonth);
                    for (int i = 0; i < voList.size(); ++i) {
                        if (i == 1 || i == 3 || i == 5) {
                            ((PeportDesignerTableVOProp)voList.get(i)).setTitle(currentMonthStr);
                        }
                        if (i != 2 && i != 4 && i != 6) continue;
                        ((PeportDesignerTableVOProp)voList.get(i)).setTitle(lastMonthStr);
                    }
                    voLiquidityList.add(voList.get(0));
                    PeportDesignerTableVOProp mergeCol = new PeportDesignerTableVOProp();
                    PeportDesignerTableVOProp inCol = new PeportDesignerTableVOProp();
                    PeportDesignerTableVOProp outCol = new PeportDesignerTableVOProp();
                    PeportDesignerTableVOProp compareCol = new PeportDesignerTableVOProp();
                    mergeCol.setTitle(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"DesignScheduleTask_2", (String)"tmc-tda-mservice", (Object[])new Object[0]));
                    inCol.setTitle(ResManager.loadKDString((String)"\u5883\u5185", (String)"DesignScheduleTask_3", (String)"tmc-tda-mservice", (Object[])new Object[0]));
                    outCol.setTitle(ResManager.loadKDString((String)"\u5883\u5916", (String)"DesignScheduleTask_4", (String)"tmc-tda-mservice", (Object[])new Object[0]));
                    compareCol.setTitle(ResManager.loadKDString((String)"\u73af\u6bd4", (String)"DesignScheduleTask_5", (String)"tmc-tda-mservice", (Object[])new Object[0]));
                    mergeCol.setChildren(new ArrayList());
                    inCol.setChildren(new ArrayList());
                    outCol.setChildren(new ArrayList());
                    compareCol.setChildren(new ArrayList());
                    mergeCol.getChildren().add(voList.get(1));
                    mergeCol.getChildren().add(voList.get(2));
                    inCol.getChildren().add(voList.get(3));
                    inCol.getChildren().add(voList.get(4));
                    outCol.getChildren().add(voList.get(5));
                    outCol.getChildren().add(voList.get(6));
                    voLiquidityList.add(mergeCol);
                    voLiquidityList.add(inCol);
                    voLiquidityList.add(outCol);
                    voLiquidityList.add(voList.get(7));
                    voLiquidityList.add(voList.get(8));
                    compareCol.getChildren().add(voList.get(9));
                    compareCol.getChildren().add(voList.get(10));
                    voLiquidityList.add(compareCol);
                    jsonObject.put("columns", voLiquidityList);
                } else {
                    jsonObject.put("columns", voList);
                }
            }
            if (EmptyUtil.isNoEmpty(voList)) {
                ArrayList mapList = new ArrayList(4);
                for (int i = 1; i < arrayRows.size(); ++i) {
                    HashMap<String, Object> stringMap = new HashMap<String, Object>(4);
                    JSONArray subArray = arrayRows.getJSONArray(i);
                    int j = 0;
                    for (PeportDesignerTableVOProp vo : voList) {
                        if (subArray.get(j).toString().contains("zh_CN")) {
                            JSONObject object = (JSONObject)subArray.get(j);
                            stringMap.put(vo.code, object.get((Object)"zh_CN").toString());
                        } else {
                            stringMap.put(vo.code, subArray.get(j));
                        }
                        ++j;
                    }
                    mapList.add(stringMap);
                }
                if (EmptyUtil.isNoEmpty(mapList)) {
                    jsonObject.put("dataSource", mapList);
                }
            }
        }
    }
}

