/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.design;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.mservice.design.DesignScheduleTask;

public class ReportDesignScheduleService {
    private static final Log logger = LogFactory.getLog(ReportDesignScheduleService.class);
    private static final Map<String, ExecutorService> EXECUTOR_MAP = new HashMap<String, ExecutorService>();

    public JSONObject batchRunDesignSchedule(List<String> pluginlist, Map<String, Object> paramMap, JSONObject jsonObject) {
        JSONObject jsonData = new JSONObject();
        CountDownLatch latch = new CountDownLatch(pluginlist.size());
        try {
            int coreTreadCount = Runtime.getRuntime().availableProcessors();
            logger.info("coreTreadCount = " + coreTreadCount + "; \u672c\u6b21\u6267\u884c\u7684\u63d2\u4ef6 \uff1a" + JSON.toJSONString(pluginlist));
            ExecutorService executor = this.getExecutorService();
            for (String plugin : pluginlist) {
                Future future = this.DesignSchedule(executor, plugin, paramMap, latch, jsonObject);
                try {
                    jsonData = (JSONObject)future.get();
                }
                catch (ExecutionException e) {
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            latch.await();
            logger.info("\u5355\u6b21\u8bf7\u6c42\u7ebf\u7a0b\u6c60\u6267\u884c\u5b8c\u6210\uff0c \u672c\u6b21\u6267\u884c\u7684\u63d2\u4ef6 \uff1a" + JSON.toJSONString(pluginlist));
        }
        catch (InterruptedException e) {
            logger.info("\u5355\u6b21\u8bf7\u6c42\u7ebf\u7a0b\u6c60\u6267\u884c\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return jsonData;
    }

    private Future DesignSchedule(ExecutorService executor, String plugin, Map<String, Object> paramMap, CountDownLatch latch, JSONObject jsonObject) {
        DesignScheduleTask task = new DesignScheduleTask(plugin, paramMap, latch, jsonObject);
        return executor.submit(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        Map<String, ExecutorService> map = EXECUTOR_MAP;
        synchronized (map) {
            String tenantId = RequestContext.get().getTenantId();
            ExecutorService executorService = EXECUTOR_MAP.get(tenantId);
            if (executorService == null) {
                executorService = ThreadPools.newCachedExecutorService((String)("ReportDesignScheduleService" + tenantId), (int)this.getCoreThreadSize(), (int)this.getMaxThreadSize());
                EXECUTOR_MAP.put(tenantId, executorService);
            }
            return executorService;
        }
    }

    private int getMaxThreadSize() {
        int maxThreadCount = (Integer)SysParamHelper.getSysParamValue((String)"maxthreadcount", Integer.class);
        if (maxThreadCount <= 0) {
            maxThreadCount = 8;
        }
        logger.info("\u6700\u5927\u7ebf\u7a0b\u6570\uff1a" + maxThreadCount);
        return maxThreadCount;
    }

    private int getCoreThreadSize() {
        int coreThreadSize = (Integer)SysParamHelper.getSysParamValue((String)"corethreadcount", Integer.class);
        logger.info("\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a" + coreThreadSize);
        return coreThreadSize;
    }
}

