/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.liquidity.task;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.mservice.liquidity.service.LiquidityUpdateService;

public class LiquidityScheduleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(LiquidityScheduleTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        Timestamp beginTime = DateUtils.getCurrentTime();
        String taskNum = "LSupdate-" + DateUtils.formatString((Date)beginTime, (String)"yyyy-MM-dd HH:mm:ss");
        Date today = DateUtils.getCurrentDate();
        Date lastMonth = DateUtils.getLastDateOfAnyMonth((Date)today, (int)-1);
        Date lastTwoMonth = DateUtils.getLastDateOfAnyMonth((Date)today, (int)-2);
        Date lastThreeMonth = DateUtils.getLastDateOfAnyMonth((Date)today, (int)-3);
        QFilter lastFilter = LiquidityScheduleTask.getYearAndMonthFilter(lastMonth);
        QFilter lastTwoFilter = LiquidityScheduleTask.getYearAndMonthFilter(lastTwoMonth);
        QFilter lastThreeFilter = LiquidityScheduleTask.getYearAndMonthFilter(lastThreeMonth);
        QFilter queryFilter = lastFilter.or(lastTwoFilter).or(lastThreeFilter);
        DataSet liquidities = QueryServiceHelper.queryDataSet((String)"liquidityscheduletask", (String)"tda_liquiditybill", (String)"id,orgview.id,org.id,accountyear,accountperiod", (QFilter[])queryFilter.toArray(), (String)"accountyear asc ,accountperiod asc");
        if (liquidities.isEmpty()) {
            logger.error("\u6d41\u52a8\u6027\u66f4\u65b0\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u66f4\u65b0\u6570\u636e");
            return;
        }
        HashSet<Long> orgViewIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Date> synthsisLoadDates = new HashSet<Date>(16);
        HashMap<Long, String> liquiditys = new HashMap<Long, String>(16);
        for (Row liquidity : liquidities) {
            Long liquidityId = liquidity.getLong("id");
            Long orgViewId = liquidity.getLong("orgview.id");
            Long orgId = liquidity.getLong("org.id");
            int accountYear = liquidity.getInteger("accountyear");
            int accountPeirod = liquidity.getInteger("accountperiod");
            Date synthsisQueryDate = DateUtils.getNextDay((Date)DateUtils.getLastDayOfMonth((Date)DateUtils.getAppointDay((int)accountYear, (int)accountPeirod, (int)1)), (int)1);
            orgViewIds.add(orgViewId);
            orgIds.add(orgId);
            synthsisLoadDates.add(synthsisQueryDate);
            String key = "" + orgViewId + orgId + accountYear + accountPeirod;
            liquiditys.put(liquidityId, key);
        }
        logger.info("\u6d41\u52a8\u6027\u6570\u636e\u8c03\u5ea6\u66f4\u65b0\u603b\u6761\u6570\uff1a" + liquiditys.size());
        QFilter synthesisFilter = new QFilter("bizdate", "in", synthsisLoadDates);
        synthesisFilter.and("orgview", "in", orgViewIds);
        synthesisFilter.and("org", "in", orgIds);
        DataSet synthesises = QueryServiceHelper.queryDataSet((String)"liquidityscheduletask", (String)"tda_synthesissumdata", (String)"id,orgview.id,orgview.number,org.id,org.number,bizdate,currency.number", (QFilter[])synthesisFilter.toArray(), null);
        HashSet<String> reloadData = new HashSet<String>(16);
        HashMap<String, Long> reloanIds = new HashMap<String, Long>(16);
        for (Row synthesise : synthesises) {
            try {
                Date bizdate = synthesise.getDate("bizdate");
                Date lastMonthDate = DateUtils.getLastDateOfAnyMonth((Date)bizdate, (int)-1);
                Pair<Integer, Integer> yearAndMonth = LiquidityScheduleTask.getYearAndMonth(lastMonthDate);
                int year = (Integer)yearAndMonth.getValue0();
                int period = (Integer)yearAndMonth.getValue1();
                String synString = synthesise.getString("orgview.number") + synthesise.getString("org.number") + DateUtils.formatString((Date)synthesise.getDate("bizdate"), (String)"yyyy-MM-dd") + synthesise.getString("currency.number");
                if (!reloadData.add(synString)) continue;
                String key = "" + synthesise.getLong("orgview.id") + synthesise.getLong("org.id") + year + period;
                reloanIds.put(key, synthesise.getLong("id"));
            }
            catch (Exception e) {
                logger.info("\u7efc\u5408\u5206\u6790\u6570\u636e\u53bb\u91cd\u62a5\u9519" + e.getMessage());
            }
        }
        logger.info("\u7efc\u5408\u5206\u6790\u6570\u636e\u8c03\u5ea6\u66f4\u65b0\u603b\u6761\u6570\u53bb\u91cd\uff1a" + reloanIds.size());
        logger.info("\u7efc\u5408\u5206\u6790\u6570\u636e\u8c03\u5ea6\u66f4\u65b0\u6570\u636e\uff1a" + String.join((CharSequence)",", reloadData));
        LiquidityUpdateService.batchUpdateData(taskNum, beginTime, liquiditys, reloanIds);
    }

    public static Pair<Integer, Integer> getYearAndMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new Pair((Object)calendar.get(1), (Object)(calendar.get(2) + 1));
    }

    public static QFilter getYearAndMonthFilter(Date date) {
        Pair<Integer, Integer> yearAndMonth = LiquidityScheduleTask.getYearAndMonth(date);
        QFilter filter = new QFilter("accountyear", "=", yearAndMonth.getValue0()).and("accountperiod", "=", yearAndMonth.getValue1());
        return filter;
    }
}

