/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.snap;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.mservice.snap.SnapScheduleTask;

public class DecsAnlsSnapBatchScheduleService {
    private static final Log logger = LogFactory.getLog(DecsAnlsSnapBatchScheduleService.class);
    private static final Map<String, ExecutorService> EXECUTOR_MAP = new HashMap<String, ExecutorService>();

    public void batchRunSnapSchedule(Long orgViewId, List<Long> orgIds, DynamicObject schedule, String batch, Date queryDate, String updateStatusBatch) {
        CountDownLatch latch = new CountDownLatch(orgIds.size());
        try {
            int coreTreadCount = Runtime.getRuntime().availableProcessors();
            logger.info("coreTreadCount = " + coreTreadCount + "batch = " + batch + "; \u6279\u6b21\u8c03\u5ea6\u7684\u7ec4\u7ec7 \uff1a" + JSON.toJSONString(orgIds));
            ExecutorService executor = this.getExecutorService();
            for (Long orgId : orgIds) {
                this.snapSchedule(executor, schedule, orgViewId, orgId, batch, queryDate, latch);
            }
            latch.await();
            logger.info("\u5355\u6279\u7ec4\u7ec7\u7ebf\u7a0b\u6c60\u6267\u884c\u8c03\u5ea6\u5b8c\u6210\uff0cbatch = " + batch + "; \u6279\u6b21\u8c03\u5ea6\u7684\u7ec4\u7ec7 \uff1a" + JSON.toJSONString(orgIds));
        }
        catch (InterruptedException e) {
            logger.info("\u5355\u6279\u7ec4\u7ec7\u7ebf\u7a0b\u6c60\u6267\u884c\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        this.updateFinishState(updateStatusBatch);
    }

    private synchronized void updateFinishState(String batch) {
        QFilter filter = new QFilter("number", "=", (Object)batch);
        DynamicObject version = TmcDataServiceHelper.loadSingle((String)"tda_decisanlsversion", (String)"id,number,querydate,isupdate,orgview,org,versionstate,begintime,endtime,finishcount,totalexeccount", (QFilter[])filter.toArray());
        if (version.getInt("finishcount") + 1 == version.getInt("totalexeccount")) {
            version.set("finishcount", (Object)version.getInt("totalexeccount"));
            version.set("versionstate", (Object)"active");
            version.set("endtime", (Object)DateUtils.getCurrentTime());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{version});
            this.deleteOldVersion(version);
            logger.info("\u7ed3\u675f\u6267\u884c\u5feb\u7167\u8c03\u5ea6\u670d\u52a1\uff0c\u5feb\u7167\u7f16\u7801 \uff1a " + batch);
        } else {
            version.set("finishcount", (Object)(version.getInt("finishcount") + 1));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{version});
        }
    }

    private void deleteOldVersion(DynamicObject version) {
        QFilter filter = new QFilter("number", "!=", (Object)version.getString("number"));
        filter.and(new QFilter("orgview.id", "=", version.getDynamicObject("orgview").getPkValue()));
        filter.and(new QFilter("querydate", "=", (Object)version.getDate("querydate")));
        filter.and("isupdate", "=", (Object)version.getBoolean("isupdate"));
        Map oldVersions = TmcDataServiceHelper.loadFromCache((String)"tda_decisanlsversion", (QFilter[])filter.toArray());
        DeleteServiceHelper.delete((String)"tda_decisanlsversion", (QFilter[])filter.toArray());
        ThreadPools.executeOnceIncludeRequestContext((String)"deleteDataSnap", () -> {
            QFilter fi = new QFilter("version", "!=", (Object)version.getString("number"));
            fi.and(new QFilter("orgview.id", "=", version.getDynamicObject("orgview").getPkValue()));
            fi.and(new QFilter("snapdate", "=", (Object)version.getDate("querydate")));
            DeleteServiceHelper.delete((String)"tda_detailsnap", (QFilter[])fi.toArray());
            if (EmptyUtil.isNoEmpty((Object)oldVersions)) {
                List numbers = oldVersions.values().stream().map(v -> v.getString("number")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("number", "in", numbers);
                DeleteServiceHelper.delete((String)"fcs_datasnap", (QFilter[])qFilter.toArray());
            }
        });
    }

    private Future snapSchedule(ExecutorService executor, DynamicObject schedule, Long orgViewId, Long orgId, String batch, Date queryDate, CountDownLatch latch) {
        SnapScheduleTask task = new SnapScheduleTask(schedule, orgViewId, orgId, batch, queryDate, latch);
        return executor.submit(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        Map<String, ExecutorService> map = EXECUTOR_MAP;
        synchronized (map) {
            String tenantId = RequestContext.get().getTenantId();
            ExecutorService executorService = EXECUTOR_MAP.get(tenantId);
            if (executorService == null) {
                executorService = ThreadPools.newCachedExecutorService((String)("DecsAnlsSnapScheduleService_" + tenantId), (int)this.getCoreThreadSize(), (int)this.getMaxThreadSize());
                EXECUTOR_MAP.put(tenantId, executorService);
            }
            return executorService;
        }
    }

    private int getMaxThreadSize() {
        int maxThreadCount = (Integer)SysParamHelper.getSysParamValue((String)"maxthreadcount", Integer.class);
        if (maxThreadCount <= 0) {
            maxThreadCount = 8;
        }
        logger.info("\u6700\u5927\u7ebf\u7a0b\u6570\uff1a" + maxThreadCount);
        return maxThreadCount;
    }

    private int getCoreThreadSize() {
        int coreThreadSize = (Integer)SysParamHelper.getSysParamValue((String)"corethreadcount", Integer.class);
        logger.info("\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a" + coreThreadSize);
        return coreThreadSize;
    }
}

